/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.web.controller.api;

import com.irdstudio.allinapaas.executor.application.executor.rest.init.ExecutorResourceLoader;
import com.irdstudio.allinapaas.executor.application.executor.rest.job.BatchStarter;
import com.irdstudio.allinapaas.executor.facade.PipeFlowEngineFacade;
import com.irdstudio.allinapaas.executor.facade.dto.ResponseDTO;
import com.irdstudio.framework.beans.core.util.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BatchController
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BatchStarter.class);
    @Value(value="${agent.batch.log.path}")
    private String logPath;
    @Autowired
    private PipeFlowEngineFacade pipeFlowEngineFacade;

    @RequestMapping(value={"/batch/start"}, method={RequestMethod.GET})
    public ResponseDTO startBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction, @RequestParam(value="envId", required=false) String envId) {
        return this.pipeFlowEngineFacade.startBatch(batchSerialNo, batchId, envId, null);
    }

    @RequestMapping(value={"/batch/start"}, method={RequestMethod.POST})
    public ResponseDTO startWithParamBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction, @RequestParam(value="envId", required=false) String envId, @RequestBody Map<String, Object> param) {
        return this.pipeFlowEngineFacade.startBatch(batchSerialNo, batchId, envId, param);
    }

    @RequestMapping(value={"/batch/log"}, method={RequestMethod.GET})
    public ResponseDTO getBatchRunLogs(@RequestParam(value="batchId", required=false) String batchId, @RequestParam(value="batchSerialNo", required=false) String batchSerialNo) {
        ResponseDTO responseVO;
        block4: {
            logger.info("\u83b7\u53d6\u6279\u6b21\u65e5\u5fd7\u4fe1\u606f\u5f00\u59cb\uff0c\u6279\u6b21\u53f7:" + batchId);
            responseVO = new ResponseDTO();
            try {
                File file = new File(this.logPath);
                if (file.exists() && Objects.nonNull(file.listFiles())) {
                    File[] files;
                    for (File f : files = file.listFiles()) {
                        if (!f.isFile() || !f.getName().contains(batchSerialNo)) continue;
                        String output = FileUtil.readFileByLines((String)f.getAbsolutePath());
                        responseVO.setFlag("success");
                        responseVO.setMsg(output);
                    }
                    break block4;
                }
                throw new Exception("\u8def\u5f84:" + this.logPath + "\uff0c\u4e0d\u5b58\u5728\u6587\u4ef6");
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6279\u6b21\u65e5\u5fd7\u4fe1\u606f\u51fa\u9519\uff0c\u6279\u6b21\u53f7:" + batchId);
                e.printStackTrace();
                responseVO.setFlag("fail");
                responseVO.setMsg(e.getMessage());
            }
        }
        return responseVO;
    }

    public void afterPropertiesSet() throws Exception {
        ExecutorResourceLoader.me().start();
    }
}

