/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.SSubsDatasourceService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsDatasourceDTO;
import com.irdstudio.paas.dbo.acl.repository.DboSqlLogRepository;
import com.irdstudio.paas.dbo.application.service.db.DatabaseDao;
import com.irdstudio.paas.dbo.domain.entity.DboSqlLogDO;
import com.irdstudio.paas.dbo.facade.DboSqlLogService;
import com.irdstudio.paas.dbo.facade.dto.DboSqlLogDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="dboSqlLogServiceImpl")
public class DboSqlLogServiceImpl
extends BaseServiceImpl<DboSqlLogDTO, DboSqlLogDO, DboSqlLogRepository>
implements DboSqlLogService {
    @Autowired
    @Lazy
    private SSubsDatasourceService sSubsDatasourceService;
    @Autowired
    @Lazy
    private PaasEcsInfoService paasEcsInfoService;

    public String sqlConnection(SSubsDatasourceDTO sSubsDatasourceVo) {
        try {
            SSubsDatasourceDTO rslSSubsDatasource = (SSubsDatasourceDTO)this.sSubsDatasourceService.queryByPk((Object)sSubsDatasourceVo);
            if (Objects.nonNull(rslSSubsDatasource)) {
                DatabaseDao DatabaseDao2 = new DatabaseDao();
                return DatabaseDao2.sqlConnection(rslSSubsDatasource);
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)var5);
        }
        return null;
    }

    public List<String> getTableName(SSubsDatasourceDTO sSubsDatasourceVo) {
        try {
            SSubsDatasourceDTO rslSSubsDatasource = (SSubsDatasourceDTO)this.sSubsDatasourceService.queryByPk((Object)sSubsDatasourceVo);
            if (Objects.nonNull(rslSSubsDatasource)) {
                DatabaseDao DatabaseDao2 = new DatabaseDao();
                return DatabaseDao2.getTableName(rslSSubsDatasource);
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)var5);
        }
        return null;
    }

    public List<String> getTableNameForProject(SSubsDatasourceDTO sSubsDatasourceVo) {
        try {
            String projectId = sSubsDatasourceVo.getSubsDsCode();
            String subsId = sSubsDatasourceVo.getSubsId();
            String envId = sSubsDatasourceVo.getDsUserId();
            String dsDbName = sSubsDatasourceVo.getDsDbName();
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            ecsParam.setSubsId(subsId);
            ecsParam.setAppId(projectId);
            ecsParam.setEnvId(envId);
            List ecsList = this.paasEcsInfoService.queryListByPage((Object)ecsParam);
            SSubsDatasourceDTO rslSSubsDatasource = null;
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                for (PaasEcsInfoDTO ecs : ecsList) {
                    if (ecs.getPaasDuId().equals("G000001")) {
                        rslSSubsDatasource = new SSubsDatasourceDTO();
                        rslSSubsDatasource.setSubsDsType("05");
                        rslSSubsDatasource.setDsConnStr(String.format("jdbc:mysql://%s:%s", ecs.getEcsIp(), ecs.getEcsPort()));
                        rslSSubsDatasource.setDsUserId(ecs.getEcsLoginUser());
                        rslSSubsDatasource.setDsUserPwd(ecs.getEcsLoginPwd());
                        continue;
                    }
                    if (!ecs.getPaasDuId().equals("G000002")) continue;
                    rslSSubsDatasource = new SSubsDatasourceDTO();
                    rslSSubsDatasource.setSubsDsType("1");
                    rslSSubsDatasource.setDsDbName("");
                    rslSSubsDatasource.setDsUserId(ecs.getEcsLoginUser());
                    rslSSubsDatasource.setDsUserPwd(ecs.getEcsLoginPwd());
                }
            }
            if (Objects.nonNull(rslSSubsDatasource)) {
                rslSSubsDatasource.setDsDbName(dsDbName);
                DatabaseDao DatabaseDao2 = new DatabaseDao();
                return DatabaseDao2.getTableName(rslSSubsDatasource);
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)var5);
        }
        return null;
    }

    public List<Map<String, Object>> doExcetueSql(SSubsDatasourceDTO sSubsDatasourceVo, String remark, String sql) {
        try {
            SSubsDatasourceDTO rslSSubsDatasource = (SSubsDatasourceDTO)this.sSubsDatasourceService.queryByPk((Object)sSubsDatasourceVo);
            if (Objects.nonNull(rslSSubsDatasource)) {
                DatabaseDao DatabaseDao2 = new DatabaseDao();
                return DatabaseDao2.doExcetueSql(rslSSubsDatasource, remark, sql, (DboSqlLogRepository)this.getRepository());
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)var5);
        }
        return null;
    }

    public List<Map<String, Object>> doExcetueSql(Map<String, String> param) {
        try {
            String subsId = param.get("subsId");
            String appId = param.get("appId");
            String envId = param.get("envId");
            String sql = param.get("sql");
            String dboRemarks = param.get("dboRemarks");
            String paasDuId = param.get("paasDuId");
            String dsDbName = param.get("dsDbName");
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            ecsParam.setSubsId(subsId);
            ecsParam.setAppId(appId);
            ecsParam.setEnvId(envId);
            List ecsList = this.paasEcsInfoService.queryListByPage((Object)ecsParam);
            SSubsDatasourceDTO rslSSubsDatasource = null;
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                rslSSubsDatasource = new SSubsDatasourceDTO();
                PaasEcsInfoDTO db = (PaasEcsInfoDTO)ecsList.get(0);
                if (db.getPaasDuId().equals("G000001")) {
                    String ip = db.getEcsOutIp();
                    if (StringUtils.isBlank((CharSequence)ip)) {
                        ip = db.getEcsIp();
                    }
                    rslSSubsDatasource.setSubsDsType("05");
                    rslSSubsDatasource.setDsConnStr(String.format("jdbc:mysql://%s:%s", ip, db.getEcsPort()));
                    rslSSubsDatasource.setDsDbName(dsDbName);
                } else if (db.getPaasDuId().equals("G000002")) {
                    rslSSubsDatasource.setSubsDsType("1");
                    rslSSubsDatasource.setDsDbName("");
                }
                rslSSubsDatasource.setDsUserId(db.getEcsLoginUser());
                rslSSubsDatasource.setDsUserPwd(db.getEcsLoginPwd());
                rslSSubsDatasource.setSubsId(subsId);
            }
            if (Objects.nonNull(rslSSubsDatasource)) {
                rslSSubsDatasource.setSubsId(appId);
                DatabaseDao DatabaseDao2 = new DatabaseDao();
                return DatabaseDao2.doExcetueSql(rslSSubsDatasource, dboRemarks, sql, (DboSqlLogRepository)this.getRepository());
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            throw (RuntimeException)var5;
        }
        return null;
    }
}

