/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.web.controller.api;

import com.irdstudio.paas.dbo.facade.DataQualityRuleService;
import com.irdstudio.paas.dbo.facade.dto.DataQualityRuleDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DataQualityRuleController
extends BaseController<DataQualityRuleDTO, DataQualityRuleService> {
    @Autowired
    @Qualifier(value="dataQualityRuleServiceImpl")
    private DataQualityRuleService dataQualityRuleService;

    @RequestMapping(value={"/api/data/quality/rules"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DataQualityRuleDTO>> queryDataQualityRuleAll(DataQualityRuleDTO vo) {
        List outputVo = this.dataQualityRuleService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/rule/{ruleId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DataQualityRuleDTO> queryByPk(@PathVariable(value="ruleId") String ruleId) {
        DataQualityRuleDTO inVo = new DataQualityRuleDTO();
        inVo.setRuleId(ruleId);
        DataQualityRuleDTO outputVo = (DataQualityRuleDTO)this.dataQualityRuleService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/rule"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DataQualityRuleDTO inDataQualityRuleVo) {
        int outputVo = this.dataQualityRuleService.deleteByPk((Object)inDataQualityRuleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/rule"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DataQualityRuleDTO inDataQualityRuleVo) {
        int outputVo = this.dataQualityRuleService.updateByPk((Object)inDataQualityRuleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/rule"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDataQualityRule(@RequestBody DataQualityRuleDTO inDataQualityRuleVo) {
        inDataQualityRuleVo.setRuleId(UUIDUtil.getUUID());
        inDataQualityRuleVo.setCreateUser(inDataQualityRuleVo.getLoginUserId());
        inDataQualityRuleVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dataQualityRuleService.insert((Object)inDataQualityRuleVo);
        return this.getResponseData(outputVo);
    }
}

