/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.web.controller.api;

import com.irdstudio.paas.dbo.facade.DboBackupConfService;
import com.irdstudio.paas.dbo.facade.dto.DboBackupConfDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DboBackupConfController
extends BaseController<DboBackupConfDTO, DboBackupConfService> {
    @Autowired
    @Qualifier(value="dboBackupConfServiceImpl")
    private DboBackupConfService dboBackupConfService;

    @RequestMapping(value={"/api/dbo/backup/confs/{subsCode}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DboBackupConfDTO>> queryDboBackupConfAll(DboBackupConfDTO vo, @PathVariable(value="subsCode") String subsCode) {
        vo.setSubsId(subsCode);
        List outputVo = this.dboBackupConfService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dbo/backup/conf/{jobCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DboBackupConfDTO> queryByPk(@PathVariable(value="jobCode") String jobCode) {
        DboBackupConfDTO inVo = new DboBackupConfDTO();
        inVo.setJobCode(jobCode);
        DboBackupConfDTO outputVo = (DboBackupConfDTO)this.dboBackupConfService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dbo/backup/conf"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DboBackupConfDTO inDboBackupConfVo) {
        int outputVo = this.dboBackupConfService.deleteByPk((Object)inDboBackupConfVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dbo/backup/conf"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DboBackupConfDTO inDboBackupConfVo) {
        int outputVo = this.dboBackupConfService.updateByPk((Object)inDboBackupConfVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dbo/backup/conf/change/subs/code"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySubsCode(@RequestBody Map<String, String> subsCodeBase) {
        String newSubsCode = MapUtils.getString(subsCodeBase, (Object)"newSubsCode");
        String oldSubsCode = MapUtils.getString(subsCodeBase, (Object)"oldSubsCode");
        int outputVo = this.dboBackupConfService.updateBySubsCode(oldSubsCode, newSubsCode);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dbo/backup/conf"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDboBackupConf(@RequestBody DboBackupConfDTO inDboBackupConfVo) {
        int outputVo = this.dboBackupConfService.insert((Object)inDboBackupConfVo);
        return this.getResponseData(outputVo);
    }
}

