(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    // 卡片开发的骨架预览卡片  不展示数据
    exports.CARD0123Card = {
        mixins: [CardComponents.BaseCard],
        data(){
            return {
                // 设计管理进来首页
                rdmEnter: this.searchParams.rdmEnter,
                // 卡片内容数据
                queryParams: {
                    subsId: this.searchParams.subsId
                },
                tableData: [],
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                filterCond: [],

                subsName: "",

                spacer : Vue.h(ElementPlus.ElDivider, { direction: 'vertical' }),

                envInfo: {}
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            queryParamsHandler(params){
                const self = this;
                
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            // 卡片内容函数
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.toRaw(self.pageInfo),
                    ...Vue.toRaw(self.queryParams)
                }
                params[self.allName] = self.all
                self.queryParamsHandler(params)
                // 指标不分页
                params.size = 100;
                $.restfulPostJson('../../../../api/card/query/CARD0123', params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            refreshCard() {
                const self = this;
                self.queryList();
            },
        },
        computed:{
            DIC() {
                return {
                }
            },
            tabTitle() {
                return this.cardName
            },
        },
        mounted() {
            const self = this;

            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="cardWidth" class="draggable pure-theme" :card-id="localCard.cardId">
    <el-card class="box-card" :class="{ 'box-card-header-color': !!cardColor }" :style="{'border-top': !!cardColor ? '5px solid transparent' : '', 'border-top-color': cardColor}" shadow="never">
        <template #header>
            <div class="card-header">
                <span><i class="drag-handler iconfont icon-move" ></i>{{tabTitle}}</span>
                <div>
                    <el-button class="button" icon="Refresh" text size="small" @click="refreshCard"></el-button>
                    <el-popover placement="bottom-start" :width="400" trigger="click" v-model:visible="cardMorePop" v-if="!fixedFlag">
                        <template #reference>
                            <el-button class="button" icon="More" text size="small"></el-button>
                        </template>
                        <el-row>
                            <el-col class="card-color-picker" >
                                <label class="card-more-label">卡片颜色</label>
                                <template v-for="(el, index) in colors">
                                    <el-button class="card-color-btn" :color="el.color" @click="changeCardColor(el.color)" size="small"></el-button>
                                </template>
                                <el-color-picker v-model="cardColor" @change="changeCardColor(cardColor)"/>
                            </el-col>
                            <el-col>
                                <label class="card-more-label">选择卡片宽度</label>
                                <template v-for="(el, index) in widths">
                                    <el-button size="small" text @click="changeCardWidth(el.width)">{{el.name}}</el-button>
                                </template>
                            </el-col>
                            <el-divider style="margin: 5px;"></el-divider>
                            <el-col>
                                <el-button type="default" text @click="openCardConfig">配置卡片</el-button>
                            </el-col>
                            <el-col>
                                
                                <el-popconfirm title="确定移除该卡片？可通过顶部的「添加卡片」按钮重新添加！" width="300" @confirm="removeCard">
                                    <template #reference>
                                        <el-button type="danger" text >移除</el-button>
                                    </template>
                                </el-popconfirm>
                            </el-col>
                        </el-row>
                    </el-popover>

                </div>
            </div>
        </template>
        <div>
            <div :style="styleObject">
                <el-row>
                    <el-col :span="24" v-loading="loading">
                        <el-space :spacer="spacer" class="summary-space">
                            <div v-for="(item, i) in tableData" :key="i" class="summary-item">
                                <div class="summary-num-div" :class="{ 'danger': item.num == 0 }">
                                    <span class="summary-num" >{{item.num || '0'}}</span>
                                    <span class="summary-unit">{{item.unit||'个'}}</span>
                                </div>
                                <div class="summary-name" >{{item.cName}}</div>
                            </div>
                        </el-space>
                    </el-col>
                </el-row>
            </div>
            <div class="card-bottom-move" v-if="!fixedFlag">
                <el-button class="card-bottom-move-btn" text icon="BottomRight" :style="moveBtnStyle" size="small" @mousedown="resizeCardStart"></el-button>
            </div>
        </div>
        
    </el-card>
    <div v-if="resizeStart" :style="shadowDivStyle" style="position: absolute; display: block; border-radius: 10px;"></div>
    
    <el-dialog v-model="dialogVisible" title="配置卡片" width="30%">
        <el-form
            ref="form"
            :rules="rules"
            :model="localCard"
            label-width="auto"
            label-position="top"
          >
            <el-form-item label="名称" prop="cardName">
                <el-input v-model="localCard.cardName" />
            </el-form-item>
        </el-form>
        <template #footer>
          <span class="dialog-footer center">
            <el-button icon="Close" @click="dialogVisible = false">取消</el-button>
            <el-button icon="Select" type="primary" @click="saveCardConfig" v-loading="loading">保存</el-button>
          </span>
        </template>
    </el-dialog>
</el-col>
        `
    }


}));