(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 流水线 树形编辑器
    exports.BatBatchInfoConfigTree = {
        props: ['batchId', 'batchName', 'subsId'],
        inject: ['searchParams', 'windowHeight', 'cardStyle'],
        data(){
            return {
                signUserId: signUserId,
                formData: {
                    "batchId" : "",
                    "batchName" : "",
                    "subsId" : "",
                    "launchType" : "",
                    "batchCronValue" : "",
                    "validDate" : "",
                    "equallyTaskAmount" : "",
                    "isRunAgain" : "",
                    "agentId" : "",
                    "alType" : "",
                    "alDescTemplate" : "",
                    "batchMgrType" : "",
                    "batchGuideUrl" : "",
                    "remark" : "",

                    "pipelineTemplateId": "",
                    "adapterAppTemplatename": "",
                    "adapterAppType1": "",
                    "adapterAppType2": "",
                    "adapterAppTemplateid": "",
                    "adapterCbaCode": "",
                    "adapterCbaName": "",
                },
                loading: false,

                treeData: [],

            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            addTab() {
                this.$refs.nav.addTab.apply(this.$refs.nav, arguments);
            },
            closeTab(){
                this.$refs.nav.closeTab.apply(this.$refs.nav, arguments)
            },
            queryList() {
                const self = this;
                self.loading = true;

                $.restfulPostJson(window.contextPath + 'api/BatBatchInfoConfig/queryByPk', { batchId: this.batchId }, function(data){
                    self.formData = data.rows;
                    // self.loading = false;
                }, function(){ self.loading = false; }, true);
                const { batchId, batchName, subsId } = self;

                // 阶段列表
                $.restfulPostJson(window.contextPath + 'api/BatBatchStageConfig/queryList', { batchId: batchId, size: 1000,  ascOrder: 'stage_order' }, function(data){
                    const stageList = data.rows;
                    //任务列表
                    $.restfulPostJson(window.contextPath + 'api/BatTaskUnitConfig/queryList', { batchId: batchId, size: 1000, ascOrder: 'stage_id,task_id' }, function(data){
                        const taskList = data.rows;
                        stageList.forEach(function(stage){
                            stage.taskList = taskList.filter(function(task){
                                return task.stageId == stage.stageId
                            })
                            // stage.taskList = JSON.parse(JSON.stringify(taskList))
                        })

                        self.treeData = [{
                            "text": batchName ,
                            "state": "open",
                            "iconCls": "icon iconfont icon-menu2",
                            "url": null,
                            "children": [
                                {
                                    "text": `基本信息`,
                                    "parentText": batchName ,
                                    "iconCls": "icon iconfont icon-qiyemenhu" ,
                                    "openPage": true,
                                    "url": `${window.contextPath}page/allinbsp/console/manual/BatBatchInfoConfigTreeUpdate.html?batchId=${batchId}&batchName=${batchName}&subsId=${subsId}`,
                                },
                                {
                                    "text": `数据源`,
                                    "parentText": batchName ,
                                    "iconCls": "icon iconfont icon-dashujukeshihuaico-" ,
                                    "openPage": true,
                                    "url": `${window.contextPath}page/allinbsp/console/manual/SSubsDatasourceTreeUpdate.html?batchId=${batchId}&batchName=${batchName}&subsId=${subsId}`,
                                },
                                {
                                    "text": `触发方式`,
                                    "parentText": batchName,
                                    "iconCls": "icon iconfont icon-ico_usetime" ,
                                    "openPage": true,
                                    "url": `${window.contextPath}page/allinbsp/console/manual/BatBatchInfoCronConfigTreeUpdate.html?batchId=${batchId}&batchName=${batchName}&subsId=${subsId}`,
                                },
                                {
                                    "text": '流程配置',
                                    "state": "open",
                                    "iconCls": "icon iconfont icon-menu2",
                                    "url": null,
                                    "children": [
                                        {
                                            "text": `全部任务(${taskList.length})`,
                                            "parentText": batchName + '-流程配置',
                                            "iconCls": "icon iconfont icon-task" ,
                                            "openPage": true,
                                            "url": `${window.contextPath}page/allinbsp/console/manual/BatTaskUnitConfigList.html?showHeader=true&batchId=${batchId}&batchName=${batchName}&subsId=${subsId}`,
                                        },
                                        {
                                            "text": '阶段根目录' ,
                                            "state": "open",
                                            "iconCls": "icon iconfont icon-menu2",
                                            "url": null,
                                            "children": stageList.map(stage=>{
                                                return {
                                                    "id": stage.stageId,
                                                    "text": stage.stageName + `(${stage.taskList.length})`,
                                                    "parentText": batchName + '-流程配置-阶段根目录-' + stage.stageName ,
                                                    "iconCls": "icon iconfont icon-ziyuan-fenzu",
                                                    "openPage": true,
                                                    "url": `${window.contextPath}page/allinbsp/console/manual/BatTaskUnitConfigList.html?showHeader=true&batchId=${batchId}&batchName=${batchName}&subsId=${subsId}&stageId=${stage.stageId}&stageName=${stage.stageName}`,
                                                }
                                            })
                                        }
                                    ]
                                },

                            ]

                        }]

                        self.$refs.nav.refreshTree();

                        self.loading = false;
                    }, function(){ self.loading = false; }, true);
                }, function(){ self.loading = false; }, true);


            },
            handleSelect(node, key, keyPath, parents) {
                if (node.openPage && node.url) {
                    let parentText = (node.parentText || this.batchName) + '-';
                    if (parents && parents.length > 0) {
                        parentText = parents.map(el=>el.text).join('-') + '-'
                    }
                    let url = node.url;
                    if (url.lastIndexOf('?') < 0) {
                        url += "?"
                    }
                    this.addTab(node.text, url + '&tabTitle=' + encodeURIComponent(parentText + node.text.replace(/\(\d+\)/, '')) , true, node.type )
                }

            },
            closeForm(){
                ElementDialog.closeDialog();
            },
            saveFromParent() {
                this.submitForm();
            },
            submitForm() {
                const self = this;
            },
        },
        computed:{
            DIC() {
                return {
                }
            },
            breadcrumb() {
                return [ this.batchName]
            },

        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24" class="dev-card-col">
    
    <tree-container ref="nav" v-loading="loading" :menu-data="treeData" active-first default-active="0-0"  @select="handleSelect" :offset="40"></tree-container>
</el-col>
        `
    }

}));