(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 数据源
    exports.SSubsDatasourceList = {
        props: ['batchId', 'batchName', 'subsId'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {

                dgUrl: window.contextPath + 'api/SSubsDatasource/queryList' ,
                signUserId: signUserId,
                queryParams: {
                    batchId: this.batchId,
                    subsId: this.subsId,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: {},

            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            formatterFixNull(value, row, index) {
                if (value) {
                    return value;
                } else {
                    return '无'
                }
            },
            handlerTableCurrentChange(row) {
                // this.currentRow = row;
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all ;

                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            reloadList() {
                this.queryList();
                
            },
            doAdd(row){
                const self = this
                ElementDialog.createDialog(`新增`,`${window.contextPath}page/allinbsp/console/conf/SSubsDatasourceAdd.html?subsId=` + this.subsId)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doUpdate(row){
                const self = this
                ElementDialog.createDialog(`修改`,`${window.contextPath}page/allinbsp/console/conf/SSubsDatasourceUpdate.html?subsDsCode=${row.subsDsCode}&subsId=${row.subsId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doDelete(row){
                const self = this
                ElementPlus.ElMessageBox.confirm(
                    '你确定要删除这条记录?',
                    '提示',
                    {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning',
                    }
                ).then(() => {
                    $.restfulPostJson(window.contextPath + 'api/SSubsDatasource/deleteByPk', {
                        'subsDsCode' : row.subsDsCode,
                        'subsId' : row.subsId,
                    }, function(data){
                        if (data.success) {
                            ElementPlus.ElMessage({
                                showClose: true,
                                message: data.message,
                                type: 'success',
                            })
                            self.queryList();
                        } else {
                            ElementPlus.ElMessage({
                                showClose: true,
                                message: data.message,
                                type: 'error',
                            })
                        }
                    }, undefined, true);
                })
            },
            doView(row){
                const self = this
                ElementDialog.createDialog(`查看`,`${window.contextPath}page/allinbsp/console/conf/SSubsDatasourceView.html?subsDsCode=${row.subsDsCode}&subsId=${row.subsId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
        },
        computed:{
            DIC() {
                return {
                    SOLUTION_TYPE: window.SOLUTION_TYPE || [],

                }
            },
            breadcrumb() {
                return [ `${this.batchName}` ,'数据源列表']
            },
            filterConfig() {
                return [
                    { key: 'subsDsCode', name: '数据源代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'subsDsName', name: '系统数据源名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'dsSchemaName', name: '数据源-模式', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'dsDbName', name: '数据源-数据库名', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                ]
            },
            sortConfig() {
                return [
                    {label: '按数据源代码顺序', key: 'subsDsCode', type: 'asc'},
                    {label: '按数据源代码倒序', key: 'subsDsCode', type: 'desc'},
                ]
            },
            dashboardData() {
                const self = this;
                if (!self.dashboardView) return [];
                return ECS_REGION.map(function(el) {
                    const list = self.tableData.filter(function(item){
                        return item.ecsRegion == el.enname;
                    }) || []
                    return {
                        key: el.enname,
                        name: el.cnname,
                        count: list.length,
                        list: list
                    }
                })
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24" class="dev-card-col">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             v-model="queryParams.searchKey"
                             :dg-url="dgUrl"
                             :query-params="queryParams"
                             :enable-filter="false"
                             enable-search
                             :all-items="[{label: '阶段编号', value: 'stageId'},{label: '阶段名称', value: 'stageName'}]"
                             @all-search="allSearch"
                >
                    <template #tool>
                        <el-button text icon="Plus" @click="doAdd">新增</el-button>
                    </template>
                </page-search>
                <el-table :data="tableData"
                          v-loading="loading"
                          stripe
                          highlight-current-row
                          @current-change="handlerTableCurrentChange"
                          style="width: 100%" >
                    <el-table-column type="index" width="45" ></el-table-column>
                    <el-table-column prop="subsDsCode" label="数据源代码"  show-overflow-tooltip   >
                        <template #default="{row, $index}">
                            <el-link type="primary" :underline="false" @click="subsDsCodeColHandler(row)">{{row.subsDsCode}}</el-link>
                        </template>
                    </el-table-column>
                    <el-table-column prop="subsDsName" label="数据源名称"  show-overflow-tooltip   >
                    </el-table-column>
                    <el-table-column prop="dsConnStr" label="数据源-连接字符串"  show-overflow-tooltip   >
                    </el-table-column>
                    <el-table-column prop="dsSchemaName" label="数据源-模式"  show-overflow-tooltip   >
                    </el-table-column>
                    <el-table-column prop="dsDbName" label="数据源-数据库名"  show-overflow-tooltip   >
                    </el-table-column>
                    <el-table-column prop="subsDsType" label="数据源类型"  show-overflow-tooltip  :formatter="(row, column, value)=>formatterDic('S_SUBS_DS_TYPE', value)">                                        </el-table-column>
                    <el-table-column label="操作" width="300" header-align="center">
                        <template #default="{row, $index}">
                        <el-button class="button" text type="default"  icon="Edit"  @click="doUpdate(row)">修改</el-button>
                        <el-button class="button" text type="default"  icon="Delete"  @click="doDelete(row)">删除</el-button>
                        </template>
                    </el-table-column>

                </el-table>
                <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }

}));