(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 触发方式
    exports.BatBatchInfoCronConfig = {
        props: ['batchId', 'batchName'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                signUserId: signUserId,
                formData: {
                    "batchId" : "",
                    "batchName" : "",
                    "subsId" : "",
                    "launchType" : "",
                    "batchCronValue" : "",
                    "validDate" : "",
                    "equallyTaskAmount" : "",
                    "isRunAgain" : "",
                    "agentId" : "",
                    "alType" : "",
                    "alDescTemplate" : "",
                    "batchMgrType" : "",
                    "batchGuideUrl" : "",
                    "remark" : "",

                    "pipelineTemplateId": "",
                    "adapterAppTemplatename": "",
                    "adapterAppType1": "",
                    "adapterAppType2": "",
                    "adapterAppTemplateid": "",
                    "adapterCbaCode": "",
                    "adapterCbaName": "",
                },
                loading: false,

            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all ;

                $.restfulPostJson('../../../../api/BatBatchInfoConfig/queryByPk', { batchId: this.batchId}, function(data){
                    self.formData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            saveFromParent() {
                this.submitForm();
            },
            closeForm(){
                ElementDialog.closeDialog();
            },
            submitForm() {
                const self = this;

                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.unref(self.formData);
                        $.restfulPostJson('../../../../api/BatBatchInfoConfig/updateByPk', jsonData, function(data) {
                            ElementPlus.ElMessage({showClose: true, message: '保存成功', type: 'success',})
                            self.loading = false;
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })

            },
            selectOpsTemplate() {
                window.top.opsTemplateSelected = this.opsTemplateSelected
                ElementDialog.createDialog('选择运维模板','/allinapaas/page/template-console/popPaasOpsTemplateList.html?returnFunc=opsTemplateSelected');
            },
            opsTemplateSelected(ops) {
                const self = this;
                self.formData.opsTemplateId = ops.opsTemplateId ;
                self.formData.opsTemplateCode = ops.opsTemplateCode ;
                self.formData.opsTemplateName = ops.opsTemplateName ;
            }
        },
        computed:{
            DIC() {
                return {
                    BAT_LAUNCH_TYPE: [
                        { 'enname': '1', 'cnname': '定时调度' },
                        { 'enname': '2', 'cnname': '手工调度' },
                        { 'enname': '3', 'cnname': '集中调度' },
                    ],
                }
            },
            breadcrumb() {
                return [ `${this.batchName}` ,'批次触发方式']
            },
            rules(){
                return {
                    batchId: [
                        { required: true, message: '批次标识不能为空' },
                    ],
                    batchName: [
                        { required: true, message: '批次名称不能为空' },
                    ],
                    equallyTaskAmount: [
                        { required: true, message: '任务并发数不能为空' },
                    ],
                }
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24" class="dev-card-col">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                             :model="formData"
                             :rules="rules"
                             label-width="120px">
                    <el-row :gutter="1">
                        <el-col :span="12">
                            <el-form-item label="批次标识" prop="batchId">
                                <el-input v-model="formData.batchId" :disabled="true" />
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="批次名称" prop="batchName">
                                <el-input v-model="formData.batchName" :disabled="true"/>
                            </el-form-item>
                        </el-col>
                        
                        <el-col :span="12">
                            <el-form-item label="触发方式" prop="launchType">
                                <combobox v-model="formData.launchType" :disabled="disabled" :op-type="DIC.BAT_LAUNCH_TYPE" ></combobox>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12" v-if="formData.launchType == '1'">
                            <el-form-item label="Cron表达式" prop="batchCronValue">
                                <el-input v-model="formData.batchCronValue" :disabled="disabled"  />
                            </el-form-item>
                        </el-col>
                    </el-row>
                </el-form>
                <div class="esaas-info-buttons" style="position: inherit; background: inherit; border: none;" v-if="false">
                    <div>
                        <el-button type="primary" @click="submitForm" v-loading="loading" icon="Select" size="small">&nbsp;保&nbsp;存&nbsp;</el-button>
                        <slot name="btn"></slot>
                    </div>
                </div>
            </el-col>
        </el-row>
    </el-card>
    
</el-col>
        `
    }

}));