(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 批次阶段列表
    exports.BatBatchInfoConfig = {
        props: ['batchId', 'batchName'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                signUserId: signUserId,
                formData: {
                    "batchId" : "",
                    "batchName" : "",
                    "subsId" : "",
                    "launchType" : "",
                    "batchCronValue" : "",
                    "validDate" : "",
                    "equallyTaskAmount" : "",
                    "isRunAgain" : "",
                    "agentId" : "",
                    "alType" : "",
                    "alDescTemplate" : "",
                    "batchGuideUrl" : "",
                    "remark" : "",

                    "pipelineTemplateId": "",
                    "adapterAppTemplatename": "",
                    "adapterAppType1": "",
                    "adapterAppType2": "",
                    "adapterAppTemplateid": "",
                    "adapterCbaCode": "",
                    "adapterCbaName": "",
                },
                loading: false,

            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all ;

                $.restfulPostJson('../../../../api/BatBatchInfoConfig/queryByPk', { batchId: this.batchId}, function(data){
                    self.formData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            closeForm(){
                ElementDialog.closeDialog();
            },
            saveFromParent() {
                this.submitForm();
            },
            submitForm() {
                const self = this;

                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.unref(self.formData);
                        $.restfulPostJson('../../../../api/BatBatchInfoConfig/updateByPk', jsonData, function(data) {
                            ElementPlus.ElMessage({showClose: true, message: '保存成功', type: 'success',})
                            self.loading = false;
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })

            },
        },
        computed:{
            DIC() {
                return {
                }
            },
            breadcrumb() {
                return [ `${this.batchName}` ,'批次信息']
            },
            rules(){
                return {
                    batchId: [
                        { required: true, message: '批次标识不能为空' },
                    ],
                    batchName: [
                        { required: true, message: '批次名称不能为空' },
                    ],
                    equallyTaskAmount: [
                        { required: true, message: '任务并发数不能为空' },
                    ],
                }
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24" class="dev-card-col">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                             :model="formData"
                             :rules="rules"
                             label-width="120px">
                    <el-row :gutter="1">
                        <el-col :span="12">
                            <el-form-item label="批次标识" prop="batchId">
                                <el-input v-model="formData.batchId" disabled/>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="批次名称" prop="batchName">
                                <el-input v-model="formData.batchName" :disabled="disabled"/>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="执行节点标识" prop="agentId">
                                <el-input v-model="formData.agentId" :disabled="disabled"/>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="生效日期" prop="validDate">
                                <own-date-picker  :disabled="disabled" placeholder="待选择" 
                                        v-model="formData.validDate" 
                                        type="date"
                                        :format="'YYYY-MM-DD'"
                                        :value-format="'YYYY-MM-DD'"
                                ></own-date-picker>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="任务并发数" prop="equallyTaskAmount">
                                <el-input v-model="formData.equallyTaskAmount" :disabled="disabled"/>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="是否允许重跑" prop="isRunAgain">
                                <el-switch v-model="formData.isRunAgain" :disabled="disabled"  active-value="Y" inactive-value="N" ></el-switch>
                            </el-form-item>
                        </el-col>
                        <el-col :span="24">
                            <el-form-item label="备注" prop="remark">
                                <el-input v-model="formData.remark" type="textarea" :autosize="{ minRows: 4, maxRows: 8 }" :disabled="disabled"/>
                            </el-form-item>
                        </el-col>
                    </el-row>
                </el-form>
                
                <div class="esaas-info-buttons" style="position: inherit; background: inherit; border: none;" v-if="false">
                    <div>
                        <el-button type="primary" @click="submitForm" v-loading="loading" icon="Select" size="small">&nbsp;保&nbsp;存&nbsp;</el-button>
                        <slot name="btn"></slot>
                    </div>
                </div>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }

}));