(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 批次校验信息
    exports.BatBatchValidateListStep = {
        inject: ['searchParams', 'windowHeight'],
        props: ['params', 'step', 'total'],
        data(){
            return {
                dgUrl: window.contextPath + 'api/BatBatchValidate/queryList',
                signUserId: signUserId,
                queryParams: {
                    batchId: this.params.batchId
                },
                pageInfo:{
                    page: 1,
                    size: 5,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: {},

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,

                valid: false,
            }
        },
        watch: {
            "params.batchId": function(val) {
                this.queryParams.batchId = batchId
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                self.queryParams.appId = self.searchParams.appId || ''
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total || data.rows.length;
                    self.pageInfo.size = data.total || data.rows.length;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList && !initFlag) {
                    this.queryList()
                }
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                const self = this;
                let valid = true;
                $.restfulPostJson(window.contextPath + 'api/BatBatchValidate/queryList', { batchId: self.queryParams.batchId, validRe: 'F', size: 1, page: 1}, function(data){
                    if (data.total == 0) {
                        // 校验通过
                        self.$emit('next', true)
                    } else {
                        // 校验不通过
                        ElementPlus.ElMessage({showClose: true, message: '批次校验未通过，请检查配置！', type: 'error', grouping: true })
                    }
                }, $.noop, true);

            },
            doView(row) {
                const self = this
                ElementDialog.createDialog('批次校验信息-详情',window.contextPath + 'page/allinbsp/console/conf/BatBatchValidateView.html?' + 'batchId=' + row.batchId + '&taskId=' + row.taskId);
            },
            startValidate() {
                const self = this;
                $.restfulGet(window.contextPath + 'api/BatBatchValidate/exec', { batchId: batchId}, function(data){
                    self.queryList();
                }, function(e){
                    // self.loadStat()
                }, true);
                self.loadStat();
            },
            loadStat() {
                const self = this;
                const { serialNo } = this
                let ruleResult = true;
                $.restfulGet(window.contextPath + 'api/BatBatchValidate/stat', { batchId: batchId}, function(data){
                    ruleResult = data.rows;
                }, function(e){
                    // 初次校验是 数据未初始化
                    ruleResult = true;
                })
                if (!ruleResult) {
                    self.queryList();
                } else {
                    self.queryList();
                    window.setTimeout(self.loadStat, 200);
                }
            },
        },
        provide() {
            return {
                DIC: this.DIC,
            }
        },
        computed:{
            breadcrumb() {
                if (this.tabTitle) {
                    return this.tabTitle.split('-')
                }
                return '批次校验信息列表'
            },

            DIC() {
                return {
                }
            },
            filterConfig() {
                return [
                    { key: 'batchId', name: '批次编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'taskId', name: '任务编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'validRe', name: '校验结果', type: 'select', opType: 'VALID_RE', opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                    { key: 'validMsg', name: '校验信息', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'validTime', name: '校验时间', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                ]
            },
            sortConfig() {
                return [
                    {label: '按任务编号顺序', key: 'taskId', type: 'asc'},
                    {label: '按任务编号倒序', key: 'taskId', type: 'desc'},
                    {label: '按批次编号顺序', key: 'batchId', type: 'asc'},
                    {label: '按批次编号倒序', key: 'batchId', type: 'desc'},
                ]
            },
            dashboardData() {
                const self = this;
                if (!self.dashboardView) return [];
                return APP_TYPE.map(function(el) {
                    const list = self.tableData.filter(function(item){
                        return item.appType == el.enname;
                    }) || []
                    return {
                        key: el.enname,
                        name: el.cnname,
                        count: list.length,
                        list: list
                    }
                })
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.startValidate();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card  pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" breadcrumb="批次校验信息列表" card-header>
                <template #right>
                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             v-model="queryParams.searchKey"
                             :dg-url="dgUrl"
                             :query-params="queryParams"
                             :enable-filter="false"
                             enable-search
                             :all-items="[]"
                             @all-search="allSearch"
                >
                    <template #more>
                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                            <el-row v-if="groupItem">
                                <el-col :span="24">
                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </template>
                </page-search>
                <template v-if="listView">
                    <el-table :data="tableData"
                            v-loading="loading"
                            stripe
                            highlight-current-row
                            @current-change="handlerTableCurrentChange"
                            tooltip-effect="light"
                            :tooltip-options="{placement : 'bottom'}"
                            style="width: 100%" >
                        <el-table-column type="index" width="45" ></el-table-column>
                        <el-table-column prop="taskId" label="任务编号" width="200" show-overflow-tooltip>
                            <template #default="{row, $index}">
                                <el-link type="primary" :underline="false" @click="doView(row)">{{row.taskId}}</el-link>
                            </template>
                        </el-table-column>
                        <el-table-column prop="taskName" label="任务名称" min-width="250" show-overflow-tooltip></el-table-column>
                        <el-table-column prop="validRe" label="校验结果" width="150" show-overflow-tooltip>
                            <template #default="{row, $index}">
                                <el-button v-if="row.validRe == 'S'" type="success" icon="Check" circle size="small" ></el-button>
                                <el-button v-else-if="row.validRe == 'F'" type="danger" icon="Close" circle size="small" ></el-button>
                                <el-button v-else type="primary" icon="error" loading circle size="small" ></el-button>
                            </template>
                        </el-table-column>
                        <el-table-column prop="validMsg" label="校验信息" min-width="250" show-overflow-tooltip></el-table-column>
                        <el-table-column prop="validTime" label="校验时间" width="150" show-overflow-tooltip></el-table-column>
                        <el-table-column prop="createUser" label="操作人" width="150" show-overflow-tooltip></el-table-column>
                    </el-table>
                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                </template>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));