(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 通用公共步骤提示页面
    exports.CommNoteStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                produceId: '',
                loading: false,

                percentage: 0,
                status: '',

                duration:  500
            }
        },
        watch: {
            "params.noteError": function(val) {
                if (this.params.noteError) {
                    this.status = 'exception'
                }
            },
            "params.noteLoading": function(val) {
                if (!this.params.noteLoading) {
                    this.params.noteProgress = 100
                    this.percentage = 100
                } else {
                    this.loopProgress()
                }
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            next() {
                this.$emit('next');
            },
            loopProgress() {
                if (!this.params.noteLoading) {
                    this.percentage = 100;
                    this.params.noteProgress = 100;
                } else {
                    this.percentage = (this.percentage % 100) + 1
                    let progress = this.params.noteProgress + 1
                    if (progress >= 90) {
                        this.duration = 5 * 1000
                    }
                    if (progress >= 99) {
                        progress = 99
                    }
                    this.params.noteProgress = progress
                    window.setTimeout(this.loopProgress, this.duration);
                }
            },
        },
        computed:{
            breadcrumb() {
                return this.params.noteTitle
            },

            DIC() {
                return {
                }
            },
        },
        mounted() {
            const self = this;
            self.loopProgress()
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row justify="center">
            <el-col :span="8" v-loading="loading" :style="{ height: windowHeight.value - 200 , 'text-align': 'center'}">
                 <el-progress type="circle" :percentage="params.noteProgress" :status="status" :indeterminate="true" width="300">
                    <template #default="{ percentage }">
                        <span class="percentage-value" style="display: block;font-size:24px;">{{ params.noteProgress }}%</span>
                        <span class="percentage-label" style="display: block;font-size:24px;">
                            <template v-if="params.noteMessage.length < 10">{{ params.noteMessage }}</template>
                            <el-tooltip :content="params.noteMessage" placement="bottom" effect="light" v-else>
                                <span> {{ params.noteMessage.length > 10 ? params.noteMessage.substring(0, 10) + '...' : params.noteMessage}} </span>
                            </el-tooltip>
                        </span>
                    </template>
                </el-progress>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="next" v-if="step < total && status !== 'exception'" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));