(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 应用paas组件 应用卡片信息
    exports.PaasAppsInfoCard = {
        props: ['subsId', 'cbaCode', 'envId', 'signUserId', 'tabTitle', 'cbaGroup', 'appCategory'],
        inject: [ 'windowHeight' ],
        data(){
            return {
                dgUrl: window.contextPath + 'api/PaasAppsInfo/queryList' ,
                queryParams: {
                    subsId: this.subsId,
                    appCategory: this.appCategory || '',
                    appType: '',
                },
                pageInfo:{
                    page: 1,
                    size: 1000,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
                showGroup: false,

                appTypeList: [],
                // 当前组件信息
                cbaInfo: {
                    cbaName: '调度平台',
                    cbaOverviewInterface: window.contextPath + 'client/bsp/subs/dev/overview/summary'
                },

                spacer : Vue.h(ElementPlus.ElDivider, { direction: 'vertical' }),

                subsInfo: {
                    subsId: this.subsId,
                    subsName: this.subsName,
                    summary: []
                },
                tabPage: 'rect',
                filterCountData: {},

            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    // console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                if (params.appCategory == 'ALL_TYPE') {
                    params.appCategory = ''
                }
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows.map(el=>{
                        return {
                            ...el,
                            summary: []
                        }
                    });
                    self.tableData.forEach(row=>self.loadSummary(row));
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            loadSummary(row) {
                const self = this;
                if (row) {
                    const cbaInfo = this.cbaInfo;
                    if(cbaInfo) {
                        let url = cbaInfo.cbaOverviewInterface ;
                        if (url) {
                            $.restfulPostJson(url, {subsId: this.subsId, envId: this.envId, appId: row.appId }, function(data){
                                row.summary.splice(0, row.summary.length, ...data.rows);
                                if (self.tabPage === 'list') {
                                    // 更新统计项
                                    data.rows.forEach(el=>{
                                        row[el.name] = el.num || row[el.name] || '0'
                                    })
                                }
                            }, function(){}, true)
                        }
                    }
                }
            },
            doView(row) {
                const self = this
                ElementDialog.createDialog('查看应用', window.contextPath + 'page/allinbsp/console/admin/PaasAppsInfoView.html?appId='+row.appId );
            },
            doConfig(row) {
                const self = this
                self.$emit('change', vue.toRaw(row))
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            tabChange(params) {
                const self = this;
                const arr = [
                    { enname: '', cnname: '全部'},
                    ...self.APP_TYPE_MAP[self.queryParams.appCategory]
                ]
                self.appTypeList.splice(0, self.appTypeList.length)
                Array.prototype.push.apply(self.appTypeList, arr)
                console.log(self.appTypeList)

                if (self.appTypeList.length > 0) {
                    self.queryParams.appType = self.appTypeList[0].enname;
                }

                if (self.tabPage === 'rect') {
                    self.showGroup = false;
                    self.pageInfo.size = 1000;
                } else if (self.tabPage === 'list') {
                    self.showGroup = true;
                    self.pageInfo.size = 10
                }
                self.$nextTick(self.queryList)
            },
        },
        provide() {
            return {
                DIC: this.DIC,
            }
        },
        computed:{
            breadcrumb() {
                if (this.tabTitle) {
                    return this.tabTitle.split('-')
                }
                return '应用';
            },
            DIC() {
                return {

                    APP_CATEGORY: [
                        { 'enname': 'BA', 'cnname': '应用' },
                        { 'enname': 'CA', 'cnname': 'SDK' },
                        { 'enname': 'DA', 'cnname': '数据库' },
                        { 'enname': 'MA', 'cnname': '中间件' },
                    ],
                    APP_TYPE: [
                        { appTypeIcon: '#icon--weifuwuzhili', appTypeCategory: 'BA', 'enname': 'A10', 'cnname': '微服务应用' },
                        { appTypeIcon: '#icon-yidongduan', appTypeCategory: 'BA', 'enname': 'A91', 'cnname': 'Mobile应用' },
                        { appTypeIcon: '#icon-gongzhonghao', appTypeCategory: 'BA', 'enname': 'A92', 'cnname': '公众号' },
                        { appTypeIcon: '#icon-weixinxiaochengxu', appTypeCategory: 'BA', 'enname': 'A93', 'cnname': '微信小程序' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'A98', 'cnname': '单体应用' },
                        { appTypeIcon: '#icon-webyingyongfangwenziyuan', appTypeCategory: 'BA', 'enname': 'A99', 'cnname': 'WEB应用' },
                        { appTypeIcon: '#icon-a7-shangpinzujian-zujian', appTypeCategory: 'BA', 'enname': 'C01', 'cnname': '微组件应用' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'X01', 'cnname': '主控器(Master)' },
                        { appTypeIcon: '#icon-agent', appTypeCategory: 'BA', 'enname': 'X02', 'cnname': '代理器(Agent)' },
                        { appTypeIcon: '#icon-zhihangqiguanli', appTypeCategory: 'BA', 'enname': 'X03', 'cnname': '执行器(Executor)' },
                        { appTypeIcon: '#icon-package', appTypeCategory: 'BA', 'enname': 'C02', 'cnname': '公共库' },
                        { appTypeIcon: '#icon-gongnengdingyi', appTypeCategory: 'BA', 'enname': 'C03', 'cnname': '框架' },
                    ]
                }
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            },
            FILTER_MODEL() {
                return [
                    { enname: 'rect', cnname: '卡片模式'},
                    { enname: 'list', cnname: '列表模式'},
                ]
            },
            FILTER_APP_CATEGORY() {
                return [
                    { enname: 'BA,CA', cnname: '全部' },
                    { 'enname': 'BA', 'cnname': '应用' },
                    { 'enname': 'CA', 'cnname': 'SDK' },
                ]
            },
            APP_TYPE_MAP() {
                return {
                    "BA,CA": [
                        { appTypeIcon: '#icon--weifuwuzhili', appTypeCategory: 'BA', 'enname': 'A10', 'cnname': '微服务应用' },
                        { appTypeIcon: '#icon-yidongduan', appTypeCategory: 'BA', 'enname': 'A91', 'cnname': 'Mobile应用' },
                        { appTypeIcon: '#icon-gongzhonghao', appTypeCategory: 'BA', 'enname': 'A92', 'cnname': '公众号' },
                        { appTypeIcon: '#icon-weixinxiaochengxu', appTypeCategory: 'BA', 'enname': 'A93', 'cnname': '微信小程序' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'A98', 'cnname': '单体应用' },
                        { appTypeIcon: '#icon-webyingyongfangwenziyuan', appTypeCategory: 'BA', 'enname': 'A99', 'cnname': 'WEB应用' },
                        { appTypeIcon: '#icon-a7-shangpinzujian-zujian', appTypeCategory: 'BA', 'enname': 'C01', 'cnname': '微组件应用' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'X01', 'cnname': '主控器(Master)' },
                        { appTypeIcon: '#icon-agent', appTypeCategory: 'BA', 'enname': 'X02', 'cnname': '代理器(Agent)' },
                        { appTypeIcon: '#icon-zhihangqiguanli', appTypeCategory: 'BA', 'enname': 'X03', 'cnname': '执行器(Executor)' },
                        { appTypeIcon: '#icon-package', appTypeCategory: 'BA', 'enname': 'C02', 'cnname': '公共库' },
                        { appTypeIcon: '#icon-gongnengdingyi', appTypeCategory: 'BA', 'enname': 'C03', 'cnname': '框架' },
                    ],
                    "BA":  [
                        { appTypeIcon: '#icon--weifuwuzhili', appTypeCategory: 'BA', 'enname': 'A10', 'cnname': '微服务应用' },
                        { appTypeIcon: '#icon-yidongduan', appTypeCategory: 'BA', 'enname': 'A91', 'cnname': 'Mobile应用' },
                        { appTypeIcon: '#icon-gongzhonghao', appTypeCategory: 'BA', 'enname': 'A92', 'cnname': '公众号' },
                        { appTypeIcon: '#icon-weixinxiaochengxu', appTypeCategory: 'BA', 'enname': 'A93', 'cnname': '微信小程序' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'A98', 'cnname': '单体应用' },
                        { appTypeIcon: '#icon-webyingyongfangwenziyuan', appTypeCategory: 'BA', 'enname': 'A99', 'cnname': 'WEB应用' },
                        { appTypeIcon: '#icon-a7-shangpinzujian-zujian', appTypeCategory: 'BA', 'enname': 'C01', 'cnname': '微组件应用' },
                        { appTypeIcon: '#icon-yingyong', appTypeCategory: 'BA', 'enname': 'X01', 'cnname': '主控器(Master)' },
                        { appTypeIcon: '#icon-agent', appTypeCategory: 'BA', 'enname': 'X02', 'cnname': '代理器(Agent)' },
                        { appTypeIcon: '#icon-zhihangqiguanli', appTypeCategory: 'BA', 'enname': 'X03', 'cnname': '执行器(Executor)' },
                    ],
                    "CA": [
                        { appTypeIcon: '#icon-package', appTypeCategory: 'BA', 'enname': 'C02', 'cnname': '公共库' },
                        { appTypeIcon: '#icon-gongnengdingyi', appTypeCategory: 'BA', 'enname': 'C03', 'cnname': '框架' },
                    ]
                }
            },
            filterConfig() {
                return [
                    { key: 'appId', name: '应用编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'appCode', name: '应用简称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'appName', name: '应用名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'subsId', name: '应用系统编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'subsCode', name: '应用系统简称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                ]
            },
            sortConfig() {
                return [
                    {label: '按创建时间最晚', key: 'createTime', type: 'asc'},
                    {label: '按修改时间最晚', key: 'lastUpdateTime', type: 'desc'},
                    {label: '按排序字段顺序', key: 'appOrder', type: 'asc'},
                    {label: '按排序字段倒序', key: 'appOrder', type: 'desc'},
                    {label: '按应用编号顺序', key: 'appId', type: 'asc'},
                    {label: '按应用编号倒序', key: 'appId', type: 'desc'},
                ]
            },
            groupConfig() {
                return [
                    {
                        id: 1,
                        label: '按应用小类',
                        key: 'appType',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        restMethod: 'restfulPostJson',
                        opType: this.appTypeList,
                    },
                ]
            },
        },
        mounted() {
            const self = this;
            self.loading = true;
            if (!self.appCategory) {
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                params.groupBy = 'appCategory'
                const dic = self.FILTER_APP_CATEGORY;
                $.restfulPostJson(self.dgUrl, params, function(data){
                    if (data.rows) {
                        // 重置统计数
                        dic.forEach(el=>{
                            self.filterCountData[el.enname] = 0
                        })
                        data.rows.forEach(el=>{
                            self.filterCountData[el[params.groupBy]] = el.groupNum
                        })
                        if(dic[0].enname == '') {
                            // 统计分项到全部
                            self.filterCountData[dic[0].enname ] = data.rows.reduce((a, b)=> a + b.groupNum, 0)
                        } else {
                            self.filterCountData[dic[0].enname ] = data.rows.filter(el=>['BA', 'CA'].indexOf(el.appCategory)>=0).reduce((a, b)=> a + b.groupNum, 0)
                        }
                    }
                }, $.noop, true);

                self.queryParams.appCategory = self.FILTER_APP_CATEGORY[0].enname;
            }
            self.loadSummary(self.subsInfo);
            self.$nextTick(self.tabChange);

        },
        unmounted() {

        },
        template: `
<el-container class="pageBody-js" v-loading="loading" :style="{ height: windowHeight.value - 70}" >
    <el-header class="page-header" style="width: 91%; margin: 0px auto;">
        <page-header :breadcrumb="breadcrumb">
            <template #left>
                <filter-radio-group style="margin-left: 10px;"
                                    class="table-filter-radio"
                                    v-model="queryParams.appCategory"
                                    @change="tabChange"
                                    :filter-count-data="filterCountData"
                                    :op-type="FILTER_APP_CATEGORY"
                ></filter-radio-group>
            </template>
            <template #right>
                <filter-radio-group style="margin-left: 10px;" 
                                    class="table-filter-radio"
                                    v-model="tabPage"
                                    @change="tabChange"
                                    :filter-no-num="true"
                                    :op-type="FILTER_MODEL"
                ></filter-radio-group>
            </template>
        </page-header>
    </el-header>
    <el-main class="main-js" style="--el-main-padding: 20px;">
        <el-row style="width: 91%; margin: 0px auto;">
            <el-col :span="24" v-if="tabPage ==='rect'">
            <template v-for="(appType, tIdx) in appTypeList.filter(el=>!!el.enname)">
                 <div class="app-container" v-if="tableData.filter(el=>el.appType === appType.enname).length > 0" :key="tIdx">
                     <div class="app-category-title"><i class="iconfont icon-move"></i>{{formatterDic('APP_CATEGORY', queryParams.appCategory || appType.appTypeCategory) || formatterDic('APP_CATEGORY', appType.appTypeCategory)}}->{{ appType.cnname }}</div>
                     <div class="app-category-content">
                        <div class="app-type-item" v-for="( app, appIdx ) in tableData.filter(el=>el.appType === appType.enname)" @click="doConfig(app)" :key="app.appId" style="padding-top:0;">
                            <div class="app-info-short">
                                <div class="app-info-short-icon" style="    position: relative; top: 9px;"><svg class="icon svg-icon" style="padding-right: 5px; font-size: 22px; " aria-hidden="true"><use :xlink:href="appType.appTypeIcon"></use></svg>   </div>
                                <div class="app-info-short-name">
                                    <el-text type="info" line-clamp="1" truncated>{{ app.appName }}</el-text>
                                </div>
                                <div class="app-info-op" @click.stop.prevent="()=>{}">
                                    <el-dropdown @command="handlerCommand" type="primary" v-if="cbaCode === 'paas-design-table'">
                                        <el-button type="default" text class="card-button"> <el-icon ><i class="iconfont icon-gengduo" ></i></el-icon></el-button>
                                        <template #dropdown>
                                            <el-dropdown-menu>
                                                <el-dropdown-item :command="{ command: 'doCheck', row: app}"><el-icon><i class="iconfont icon-shujuxiaoyan" ></i></el-icon>表模型校验</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doGenerateWord', row: app}"><el-icon><Document ></Document></el-icon>生成Word文档</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doGenerateExcel', row: app}"><el-icon><Document ></Document></el-icon>生成Excel文档</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doGenerateScript', row: app}"><el-icon><Document ></Document></el-icon>生成建表脚本</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doGenerateDicScript', row: app}"><el-icon><Document ></Document></el-icon>生成代码项脚本</el-dropdown-item>
                                            </el-dropdown-menu>
                                        </template>
                                    </el-dropdown>
                                    <el-button type="default" text class="card-button" icon="Refresh" @click="loadSummary(app)"></el-button>
                                </div>
                            </div>
                            <div class="app-info-desc">
                                <el-space :spacer="spacer" class="app-summary-space">
                                    <div v-for="(item, i) in app.summary" :key="i" class="app-summary-item">
                                        <div class="app-summary-num-div" :class="{ 'danger':  item.showRed === 'true', 'eq-zero': item.num === 0 }">
                                            <span class="app-summary-num" >{{item.num || '0'}}</span>
                                            <span class="app-summary-unit">{{item.unit||'个'}}</span>
                                        </div>
                                        <div class="app-summary-name" >{{item.cName}}</div>
                                    </div>
                                </el-space>
                            </div>
                        </div>
                        <template v-if="tableData.filter(el=>el.appType === appType.enname).length % 3 > 0" >
                            <div v-for="n in ( 3 -  ( tableData.filter(el=>el.appType === appType.enname).length % 3 )) " :key="n" class="app-type-item hide" style="border: none"></div>
                        </template>
                     </div>
                </div>
            </template>
            <el-empty v-if="tableData.length === 0" description="暂无应用数据" ></el-empty>
            </el-col>
            <el-col :span="24" v-else-if="tabPage ==='list'">
                <el-card class="box-card pure-theme" shadow="never">
                    <template #header>
                        <page-header class="inner-title" breadcrumb="应用列表" card-header>
                            <template #right>
                                <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                                <group-dropdown v-model="groupItem" v-if="showGroup" :group-config="groupConfig" ></group-dropdown>
                                <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                                <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                            </template>
                        </page-header>
                    </template>
                    <el-row>
                        <el-col :span="24">
                            <page-search ref="searchRef"
                                         enable-search
                                         :all-items="[{label: '应用简称', value: 'appCode'},{label: '应用名称', value: 'appName'}]"
                                         @all-search="allSearch"
                            >
                                <template #more>
                                    <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                                        <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                                        <el-row v-if="groupItem">
                                            <el-col :span="24">
                                                <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                            </el-col>
                                        </el-row>
                                    </el-form>
                                </template>
                            </page-search>
                            <el-table :data="tableData"
                                      v-loading="loading"
                                      stripe
                                      highlight-current-row
                                      @current-change="handlerTableCurrentChange" @row-dblclick="doConfig"
                                      tooltip-effect="light"
                                      :tooltip-options="{placement : 'bottom'}"
                                      style="width: 100%" >
                                <el-table-column type="index" width="45" ></el-table-column>
                                <el-table-column prop="appId" label="应用编号" width="120">
                                    <template #default="{row, $index}">
                                        <el-link type="primary" :underline="false" @click="doView(row)">{{row.appId.replace(row.subsId+ '-', '')}}</el-link>
                                    </template>
                                </el-table-column>
                                <el-table-column prop="appCode" label="应用简称" show-overflow-tooltip></el-table-column>
                                <el-table-column prop="appName" label="应用名称" show-overflow-tooltip></el-table-column>
                                <el-table-column prop="appType" label="应用类型"  width="150" show-overflow-tooltip>
                                    <template #default="{row}">{{ formatterDic('APP_TYPE', row.appType) }}</template>
                                </el-table-column>
                                <el-table-column prop="appCreateWay" label="创建方式"  width="150" show-overflow-tooltip :formatter="(row, column, value)=>formatterDic('APP_CREATE_WAY', value)"></el-table-column>
                                <el-table-column prop="appTemplateId" label="应用模板编号" width="150" show-overflow-tooltip></el-table-column>
                                <el-table-column prop="appTemplateName" label="应用模板名称"  width="200" show-overflow-tooltip></el-table-column>
                                <template v-for="(item, i) in subsInfo.summary">
                                <el-table-column :prop="item.name" :label="item.cName" width="100" show-overflow-tooltip></el-table-column>
                                </template>
                                <el-table-column label="操作" width="200" header-align="center">
                                    <template #default="{row, $index}">
                                        <el-button class="button" text type="default" @click="doConfig(row)" icon="Tools">{{cbaInfo.cbaName}}</el-button>
                                    </template>
                                </el-table-column>
                            </el-table>
                            <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                        </el-col>
                    </el-row>
                </el-card>
            </el-col>
            
        </el-row>
    </el-main>
</el-container>
        `
    }

}));