(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 应用系统视图 卡片模式
    exports.SSubsInfoRectView = {
        props: ['tabTitle', 'subsGroupList', 'tableData', 'jumpPageType'],
        inject: ['searchParams', 'windowHeight'],
        emits: ['card-click'],
        data(){
            return {

                loading: false,
                currentRow: undefined,

                spacer : Vue.h(ElementPlus.ElDivider, { direction: 'vertical' }),
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },

            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            doCardClick(project) {
                this.$emit('card-click', project)
            },
            doConfig(row){
                const self = this
                window.top.location.href = (contextPath + 'page/allinbsp/console/conf/SSubsInfoTopIndex.html?subsId=' + row.subsId + '&subsName=' + row.subsName + '&subsCode=' + row.subsCode)
            },
            loadSummary(subs) {
                $.restfulPostJson(window.contextPath + 'client/bsp/subs/overview/summary', { subsId: subs.subsId, size: 1 }, function(data){
                    subs.summary = data.rows
                }, function(e){}, true);
            }

        },
        provide() {
            return {
            }
        },
        computed:{
            breadcrumb() {
                if (this.tabTitle) {
                    return this.tabTitle.split('-')
                }
                return '应用系统群组列表';
            },
            cardModeStyle() {
                return {
                    'width': '91%',
                    'margin': '0px auto',
                    'padding-left': '15px',
                    'padding-right': '15px',
                }
            }

        },
        mounted() {
            const self = this;


        },
        unmounted() {

        },
        template: `
        <el-row :style="cardModeStyle">
            <el-col :span="24">
                <template v-for="(group, tIdx) in subsGroupList">
                     <div class="app-container" v-if="tableData.filter(el=>el.subsGroupId.indexOf(group.enname) >= 0 ).length > 0" :key="tIdx">
                         <div class="app-category-title"><i class="iconfont icon-move"></i>应用系统群->{{ group.cnname }}</div>
                         <div class="app-category-content">
                            <div class="app-type-item" v-for="( app, appIdx ) in tableData.filter(el=>el.subsGroupId.indexOf(group.enname) >= 0)" @click="doCardClick(app)" :key="app.subsId">
                                <div class="app-info-short">
                                    <div class="app-info-short-icon" style="position: relative; top: 9px;"><svg class="icon svg-icon" style="padding-right: 5px; font-size: 22px; " aria-hidden="true"><use xlink:href="#icon-yingyong"></use></svg>   </div>
                                    <div class="app-info-short-name">
                                        <el-text type="info" line-clamp="1" truncated>{{ app.subsName }}</el-text>
                                    </div>
                                    <div class="app-info-op" @click.stop.prevent="()=>{}">
                                        <el-dropdown @command="handlerCommand" type="primary" popper-class="app-info-op-dropdown" placement="bottom-start">
                                            <el-button type="default" text icon="MoreFilled"></el-button>
                                            <template #dropdown>
                                                <el-dropdown-menu>
                                                    <el-dropdown-item :command="{ command: 'doConfig', row: app }"><el-icon><i class="iconfont icon-dashujukeshihuaico-"></i></el-icon>后台管理</el-dropdown-item>
                                                </el-dropdown-menu>
                                            </template>
                                        </el-dropdown>
                                        <el-button type="default" text icon="Refresh" @click="loadSummary(app)"></el-button>
                                    </div>
                                </div>
                                <div class="app-info-desc">
                                    <el-space :spacer="spacer" class="app-summary-space">
                                        <template v-if="app.summary">
                                        <div class="app-summary-item" v-for="(item, index) in app.summary ">
                                            <div class="app-summary-num-div" :class="{ 'danger':  item.showRed === 'true', 'eq-zero': item.num === 0}">
                                                <span class="app-summary-num" >{{item.num || '0'}}</span>
                                                <span class="app-summary-unit">个</span>
                                            </div>
                                            <div class="app-summary-name" >{{ item.cName }}</div>
                                        </div>
                                        </template>    
                                    </el-space>
                                </div>
                            </div>
                            <template v-if="tableData.filter(el=>el.subsGroupId.indexOf(group.enname) >= 0).length % 3 > 0" >
                                <div v-for="n in ( 3 -  ( tableData.filter(el=>el.subsGroupId.indexOf(group.enname) >= 0).length % 3 )) " :key="n" class="app-type-item hide" style="border: none"></div>
                            </template>
                         </div>
                    </div>
                </template>
                <el-empty v-if="tableData.length === 0" description="暂无数据" ></el-empty>
            </el-col>
        </el-row>

        `
    }

}));