(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 代码文件浏览器
    exports.CodeViewStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                produceId: '',
                loading: false,

            }
        },
        watch: {
            "params.produceId": function(val) {
                this.produceId = val;
                this.queryList();
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryList() {
                const self = this;
                self.loading = true;
                setTimeout(function() {
                    self.loading = false;
                }, 50)
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                const self = this;
                this.$emit('next')
            },
            next() {
                this.$emit('next', this.produceId);
            }
        },
        computed:{
            breadcrumb() {
                return '代码文件浏览'
            },

            DIC() {
                return {
                }
            },
            url() {
                return window.contextPath + `page/allinbsp/console/dev/CodeView.html?hideSouth=true&produceId=${this.produceId}`
            }
        },
        mounted() {
            const self = this;
            this.produceId = this.params.produceId
            this.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24" v-loading="loading" element-loading-text="正在生成代码..." :style="{ height: windowHeight.value - 136 }">
                <iframe v-if="!loading" scrolling="auto" frameborder="0" :src="url" style="width:100%;height:100%;"></iframe>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="next" v-if="step < total" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));