(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 删除文件预览
    exports.DeleteJobCodeFileList = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                dgUrl: window.contextPath + 'api/job/base/info/change/belong/deletes' ,
                queryParams: {
                    jobId: this.searchParams.jobId,
                    jobCode: this.searchParams.jobCode,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,

                taskId: '',
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostForm(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.pageInfo.size = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            },
            handlerDblclick(row) {
                this.handlerTableCurrentChange(row);
                this.submitForm()
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                const self = this;
                self.loading = true;
                ElementPlus.ElMessageBox.confirm(
                    '你确定要删除吗?',
                    '提示',
                    {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning',
                    }
                ).then(() => {
                    $.restfulDelete(window.contextPath + 'api/job/base/info/change/belong/deletes/confirm', { jobId: self.params.jobId, jobCode: self.params.jobCode, appId: self.params.srcAppId }, function(data){
                        if (data.success) {
                            self.$emit('next', self.formId)
                        }
                        self.loading = false;
                    }, function(e){
                        self.loading = false;
                        ElementPlus.ElMessage({
                            showClose: true,
                            message: '删除操作异常',
                            type: 'error',
                        })
                    }, true);
                }).catch(()=>{
                    self.loading = false;
                })
            },
            runGen() {
                const self = this;
                $.restfulGet(window.contextPath + 'api/paas/task/info/exec', {taskId: self.taskId}, function(data) {
                    if (data.success) {
                        // 自动刷新规则列表
                        self.loadRule();
                    } else {
                        self.queryList();
                        self.loading = false;
                        ElementPlus.ElMessage({showClose: true, message: data.message, type: 'error',})
                    }
                }, function(e){
                    ElementPlus.ElMessage({showClose: true, message: e.responseJSON.message, type: 'error',})
                });
            },
            loadRule() {
                const self = this;
                let ruleResult = '0';
                $.restfulGet(window.contextPath + 'api/paas/task/info/exec/stat', { taskId: self.taskId }, function(data){
                    ruleResult = data.rows;
                })
                if (ruleResult == '0') {
                    self.queryList();
                    self.loading = false;
                } else {
                    window.setTimeout(self.loadRule, 5 * 1000);
                }
            },
        },
        computed:{
            breadcrumb() {
                return `任务代码文件删除预览列表`
            },

            DIC() {
                return {
                }
            },
        },
        mounted() {
            const self = this;
            self.loading = true;
            $.restfulPostForm(window.contextPath + 'api/paas/task/jobgens', {
                subsId : self.params.oldData.subsId,
                appId: self.params.oldData.appId,
                comId: self.params.oldData.comId,
                jobId: self.params.oldData.jobId,
                taskType: self.searchParams.taskType
            } , function(data){
                if (data.rows && data.rows.length > 0) {
                    self.taskId = data.rows[0].taskId;
                    self.runGen();
                } else {
                    $.restfulPostJson(window.contextPath + '/paas/task/jobgen', {
                        ...self.params.oldData,
                        taskType: self.searchParams.taskType,
                        taskName : self.params.oldData.appName  + '任务代码生成任务'
                    }, function(data) {
                        self.taskId = data.rows
                        self.runGen();
                    }, function(e){
                        self.loading = false;
                    }, true);
                }
            }, $.noop, false);
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never" v-loading="loading">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <el-table :data="tableData"
                          stripe
                          highlight-current-row
                          @current-change="handlerTableCurrentChange" 
                          tooltip-effect="light"
                          :tooltip-options="{placement : 'bottom'}"
                          style="width: 100%" >
                    <el-table-column type="index" width="45" ></el-table-column>
                    
                    <el-table-column prop="filePath" label="文件" min-width="200" show-overflow-tooltip></el-table-column>
                </el-table>
                <page-table-pagination :page-info="pageInfo" : :page-sizes="[pageInfo.total]" :load-method="queryList"></page-table-pagination>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));