(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 任务信息
    exports.JobBaseInfoChangeStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                formData: {
                    "jobId" : "",
                    "subsId" : "",
                    "appId" : "",
                    "appCode" : "",
                    "appName" : "",
                    "comId" : "",
                    "comName" : "",
                    "jobCode" : "",
                    "jobName" : "",
                    "jobCategory" : "",
                    "jobType" : "",
                    "jobDesc" : "",
                    "createUser" : "",
                    "createTime" : "",
                    "updateUser" : "",
                    "updateTime" : ""
                },

                loading: false,
                disabled: true,
                // 是否有多个应用关联该表模型对应的数据库应用
                moreAppFlag: false

                
            }
        },
        watch: {
            "params.rptModelId": function(val) {
                this.queryData();
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryData() {
                const self = this;
                self.loading = true;
                $.restfulGet(window.contextPath + 'api/job/base/info/' + self.searchParams.jobId,null,function(data){
                    self.formData = data.rows;
                    self.params.oldData = JSON.parse(JSON.stringify(data.rows));
                    self.params.srcAppId = self.formData.appId
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            handleCatalogChange() {
                this.formData.taskType = ''
            },
            submitForm() {
                const self = this;
                self.loading = true;
                self.$emit('next', vue.toRaw(self.formData));
            },
            selectApp() {
                ElementDialog.createDialog(`选择应用`,`${window.contextPath}page/allinbsp/console/admin/popPaasAppsInfoList.html?subsId=${this.formData.subsId}&appCategory=BA,CA`)
                    .then(app=>{
                        this.formData.appId = app.appId
                        this.formData.appCode = app.appCode
                        this.formData.appName = app.appName
                    });
            },
            selectModule() {
                const self = this;
                const { subsId, appId, comId, projectId} = self.formData;
                ElementDialog.createDialog('模块列表', `${window.contextPath}page/allintpaas/sdk/bi/popRdmModuleInfoTree.html?subsId=${subsId}&programFlag=Y`)
                    .then(module=>{
                        self.formData.moduleId = module.moduleId
                        self.formData.moduleName = module.moduleName
                    });
            },
        },
        computed:{
            breadcrumb() {
                return `任务信息`
            },

            rules(){
                return {
                    "jobCode": [
                        { required: true, message: '任务编号不能为空' },
                    ],
                    "jobName": [
                        { required: true, message: '任务名称不能为空' },
                    ],
                    "jobCategory": [
                        { required: true, message: '任务类别不能为空' },
                    ],
                    "jobType": [
                        { required: true, message: '任务类型不能为空' },
                    ],
                    "moduleName": [
                        { required: true, message: '所属模块不能为空'},
                    ],
                }
            },
            DIC() {
                return {

                }
            },
        },
        mounted() {
            const self = this;
            self.queryData();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                     :model="formData"
                     :rules="rules"
                     label-width="120px">
                    <el-row :gutter="1">
                        <el-col :span="12">
                                <el-form-item label="任务编号" prop="jobCode">
                                    <el-input v-model="formData.jobCode" :disabled="true" ></el-input>
                                </el-form-item>
                            </el-col>
                            <el-col :span="12">
                                <el-form-item label="任务名称" prop="jobName">
                                    <el-input v-model="formData.jobName" :disabled="disabled" />
                                </el-form-item>
                            </el-col>
                            <el-col :span="12">
                                <el-form-item label="任务类别" prop="jobCategory">
                                    <combobox v-model="formData.jobCategory" :disabled="true" op-type="JOB_CATEGORY" />
                                </el-form-item>
                            </el-col>
                            <el-col :span="12">
                                <el-form-item label="任务类型" prop="jobType">
                                    <combobox v-model="formData.jobType" :disabled="disabled" op-type="JOB_TYPE" />
                                </el-form-item>
                            </el-col>
                            <el-col :span="12">
                                <el-form-item label="所属应用" prop="appName">
                                    <el-input v-model="formData.appName" :disabled="true" >
                                        <template #append >
                                            <el-button @click="selectApp">选择</el-button>
                                        </template>
                                    </el-input>
                                </el-form-item>
                            </el-col>
                            <el-col :span="12">
                                <el-form-item label="所属模块" prop="moduleName">
                                    <el-input v-model="formData.moduleName" :disabled="true" >
                                        <template #append v-if="!disabled">
                                            <el-button @click="selectModule">选择</el-button>
                                        </template>
                                    </el-input>
                                </el-form-item>
                            </el-col>
                            <el-col :span="24">
                                <el-form-item label="任务描述" prop="jobDesc">
                                    <el-input v-model="formData.jobDesc" :disabled="disabled" type="textarea"  :autosize="{ minRows: 4, maxRows: 8 }" />
                                </el-form-item>
                            </el-col>
                    </el-row>
                </el-form>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons" :style="{ bottom: 'inherit', top: windowHeight.value - 40 } ">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));