(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 任务代码生成信息配置
    exports.PaasTaskJobGenStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                formData: {

                    "taskId": "",
                    "comId": "",
                    "comCode": "",
                    "comName": "",
                    "jobId": "",
                    "jobName": "",
                    "regenRepo": "N",
                    "moduleId": "",
                    "moduleName": "",

                    "taskName": "",
                    "taskType": "",
                    "taskState": "",
                    "taskErrorMsg": "",
                    "subsId": "",
                    "subsName": "",
                    "appId": "",
                    "appCode": "",
                    "appName": "",
                    "startTime": "",
                    "endTime": "",
                    "costTime": "",
                    "createUser": "",
                    "createTime": "",
                    "lastUpdateUser": "",
                    "lastUpdateTime": "",
                },

                loading: false,
                disabled: false,

                
            }
        },
        watch: {
            "params.taskId": function(val) {
                this.queryData();
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryData() {
                const self = this;
                self.formData.subsId = self.params.subsId ;
                self.formData.appName = self.params.appName ;
                self.formData.appCode = self.params.appCode ;
                self.formData.appId = self.params.appId ;
                self.formData.moduleId = self.params.moduleId ;
                self.formData.moduleName = self.params.moduleName ;
                if (self.params.taskId) {
                    $.restfulGet(window.contextPath + 'api/paas/task/jobgen/' + self.params.taskId, null, function(data){
                        self.formData = data.rows;
                        self.formData.taskType = self.params.taskType || self.formData.taskType ;
                        self.params.jobId = self.formData.jobId ;
                        self.params.jobName = self.formData.jobName ;
                        self.params.comId = self.formData.comId ;
                        self.params.comCode = self.formData.comCode ;
                        self.params.comName = self.formData.comName ;
                        self.params.appId = self.formData.appId ;
                        self.formData.moduleId = self.params.moduleId ;
                        self.formData.moduleName = self.params.moduleName ;
                        self.params.taskType = self.params.taskType || self.formData.taskType ;
                    })
                } else {
                    self.formData.jobId = self.params.jobId ;
                    self.formData.jobName = self.params.jobName ;
                    if (self.params.comId && self.params.comId.indexOf(',') >= 0) {
                        self.formData.taskName = self.params.appName  + '应用任务代码生成任务'
                    } else if(self.params.comName) {
                        let comName = self.params.comName
                        if (comName.indexOf(',') >= 0 ) {
                            let arr = comName.split(',')
                            comName = arr[0]
                        }
                        self.formData.taskName = comName  + '等任务代码生成任务'
                    } else {
                        self.formData.taskName = self.params.appName  + '任务代码生成任务'
                    }
                    self.formData.comId = self.params.comId ;
                    self.formData.comCode = self.params.comCode ;
                    self.formData.comName = self.params.comName ;
                    self.formData.appId = self.params.appId ;
                    self.formData.taskType = self.params.taskType ;
                }

            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            handleCatalogChange() {
                this.formData.taskType = ''
            },
            submitForm() {
                const self = this;
                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.unref(self.formData);
                        let method = 'restfulPostJson'
                        if (self.formData.taskId) {
                            method = 'restfulPut'
                        }
                        $[method](window.contextPath + 'api/paas/task/jobgen', jsonData, function(data) {
                            self.loading = false;
                            self.params.taskName = self.formData.taskName
                            self.params.taskId = data.rows
                            self.$emit('next', data.rows)
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })
            },
            selectApp() {
                ElementDialog.createDialog('选择应用',`${window.contextPath}page/allinbsp/console/admin/popPaasAppsInfoList.html?subsId=${this.formData.subsId}&appCategory=BA,CA`)
                    .then(app=>{
                        this.formData.appId = app.appId
                        this.formData.appCode = app.appCode
                        this.formData.appName = app.appName
                    });
            },

        },
        computed:{
            breadcrumb() {
                return `任务信息`
            },

            rules(){
                return {
                    "taskName": [
                        { required: true, message: '任务名称不能为空'},
                    ],
                    "taskType": [
                        { required: true, message: '任务类型不能为空'},
                    ],
                    "jobName": [
                        { required: true, message: '任务不能为空'},
                    ],
                    "appName": [
                        { required: true, message: '应用名称不能为空'},
                    ],
                    "genPath": [
                        { required: true, message: '页面生成路径不能为空'},
                    ],
                }
            },
            DIC() {
                return {

                }
            },
        },
        mounted() {
            const self = this;
            self.queryData();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <el-form class="card-form" v-loading="loading" ref="formRef"  :show-message="true"
                         :model="formData"
                         :rules="rules"
                         label-width="120px">
                    <el-row :gutter="1">
                        <el-col :span="24">
                            <el-form-item label="任务名称" prop="taskName">
                                <el-input v-model="formData.taskName" :disabled="disabled" ></el-input>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12" >
                            <el-form-item label="模块名称" prop="moduleName">
                                <el-input v-model="formData.moduleName" :disabled="true" ></el-input>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="应用名称" prop="appName">
                                <el-input v-model="formData.appName" :disabled="true" >
                                    <template #append>
                                        <el-button @click="selectApp">选择</el-button>
                                    </template>
                                </el-input>
                            </el-form-item>
                        </el-col>
                        <el-col :span="12">
                            <el-form-item label="是否重新初始化仓库" prop="regenRepo">
                                <el-switch v-model="formData.regenRepo" :disabled="disabled"  active-value="Y" inactive-value="N" ></el-switch>
                            </el-form-item>
                        </el-col>
                    </el-row>
                </el-form>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons" :style="{ bottom: 'inherit', top: windowHeight.value - 40 } ">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));