(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 批次阶段列表
    exports.BatBatchStageConfigList = {
        props: ['batchId', 'batchName'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {

                dgUrl: '../../../../api/BatBatchStageConfig/queryList' ,
                signUserId: signUserId,
                queryParams: {
                    batchId: this.batchId,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: {},

            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            formatterFixNull(value, row, index) {
                if (value) {
                    return value;
                } else {
                    return '无'
                }
            },
            handlerTableCurrentChange(row) {
                // this.currentRow = row;
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all ;

                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            reloadList() {
                this.queryList();
                
            },
            doAdd() {
                const self = this
                window.top.reloadList = self.reloadList
                window._alreadyBind = true
                ElementDialog.createDialog('新增批次阶段', '../../../../page/allinbsp/console/conf/BatBatchStageConfigAdd.html?batchId=' + this.batchId);
            },
            doUpdate(row) {
                const self = this
                window.top.reloadList = self.reloadList
                window._alreadyBind = true
                ElementDialog.createDialog('修改批次阶段', '../../../../page/allinbsp/console/conf/BatBatchStageConfigUpdate.html?' + 'stageId=' + row.stageId + '&batchId=' + row.batchId);
            },
            doDelete(row) {
                const self = this
                if (row) {
                    const param = Vue.unref(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        '你确定要删除这条记录?',
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        $.restfulPostJson('../../../../api/BatBatchStageConfig/deleteByPk', row, function(data) {
                            if (data.success) {
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '删除成功',
                                    type: 'success',
                                })
                                self.queryList();
                            }
                        });
                    })
                }
            },
            doView(row) {
                const self = this
                ElementDialog.createDialog('查看批次阶段','../../../../page/allinbsp/console/conf/BatBatchStageConfigView.html?' + '&stageId=' + row.stageId + '&batchId=' + row.batchId);
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
        },
        computed:{
            DIC() {
                return {
                    SOLUTION_TYPE: window.SOLUTION_TYPE || [],

                }
            },
            breadcrumb() {
                return [ `${this.batchName}` ,'批次阶段']
            },
            filterConfig() {
                return [
                    { key: 'stageId', name: '阶段编号', type: 'input', opType: ''},
                    { key: 'stageName', name: '阶段名称', type: 'input', opType: ''},
                    { key: 'remark', name: '备注', type: 'input', opType: ''},
                ]
            },
            sortConfig() {
                return [
                    {label: '按阶段排序顺序', key: 'stageOrder', type: 'asc'},
                    {label: '按阶段排序倒序', key: 'stageOrder', type: 'desc'},
                ]
            },
            dashboardData() {
                const self = this;
                if (!self.dashboardView) return [];
                return ECS_REGION.map(function(el) {
                    const list = self.tableData.filter(function(item){
                        return item.ecsRegion == el.enname;
                    }) || []
                    return {
                        key: el.enname,
                        name: el.cnname,
                        count: list.length,
                        list: list
                    }
                })
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             v-model="queryParams.searchKey"
                             :dg-url="dgUrl"
                             :query-params="queryParams"
                             :enable-filter="false"
                             enable-search
                             :all-items="[{label: '阶段编号', value: 'stageId'},{label: '阶段名称', value: 'stageName'}]"
                             @all-search="allSearch"
                >
                    <template #tool>
                        <el-button text icon="Plus" @click="doAdd">新增</el-button>
                    </template>
                </page-search>
                <el-table :data="tableData"
                          v-loading="loading"
                          stripe
                          highlight-current-row
                          @current-change="handlerTableCurrentChange"
                          style="width: 100%" >
                    <el-table-column type="index" width="45" ></el-table-column>
                    <el-table-column prop="stageId" label="阶段编号" width="250" show-overflow-tooltip>
                        <template #default="{row, $index}">
                            <el-link type="primary" :underline="false" @click="doView(row)">{{row.stageId}}</el-link>
                        </template>
                    </el-table-column>
                    <el-table-column prop="stageName" label="阶段名称" ></el-table-column>
                    <el-table-column prop="batchId" label="批次标识" ></el-table-column>
                    <el-table-column prop="remark" label="备注" width="200"></el-table-column>
                    <el-table-column prop="stageOrder" label=" 排序" width="150"></el-table-column>
                    <el-table-column label="操作" width="250" header-align="center">
                        <template #default="{row, $index}">
                            <el-button class="button" text type="default" @click="doUpdate(row)"><el-icon><Edit ></Edit></el-icon>修改</el-button>
                            <el-button class="button" text type="default" @click="doDelete(row)"><el-icon><Delete ></Delete></el-icon>删除</el-button>
                        </template>
                    </el-table-column>

                </el-table>
                <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }

}));