(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 执行批次日志
    exports.BatInstBatchTableLog = {
        props: ['batchId', 'batchName', 'batchSerialNo'],
        inject: ['searchParams', 'windowHeight', 'historyFlag'],
        data(){
            return {
                loading: false,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryList() {
                const self = this;
                self.loading = true;
                setTimeout(function() {
                    self.loading = false;
                }, 50)
            },
            closeForm() {
                this.$emit('close')
            },
        },
        watch: {
            "batchSerialNo": function(val) {
                this.queryList()
            }
        },
        computed:{
            breadcrumb() {
                return '批次日志'
            },

            DIC() {
                return {
                }
            },
            url() {
                return `${window.contextPath}page/allinbsp/console/manual/BatchMonitorTwo.html?batchSerialNo=${this.batchSerialNo}&batchId=${this.batchId}&historyFlag=${this.historyFlag}`
            }
        },
        mounted() {
            const self = this;

            self.queryList()
        },
        unmounted() {

        },
        template: `

            <el-col :span="24" v-loading="loading" element-loading-text="正在执行批次..." :style="{ height: windowHeight.value }">
                <iframe v-if="!loading" scrolling="auto" frameborder="0" :src="url" style="width:100%;height:100%;"></iframe>
            </el-col>
        `
    }

}));