(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 应用系统视图 卡片模式
    exports.SSubsInfoRectView = {
        props: ['tabTitle', 'tableData'],
        inject: ['searchParams', 'windowHeight'],
        emits: ['card-click'],
        data(){
            return {

                loading: false,
                currentRow: undefined,

            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },

            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            doCardClick(project) {
                this.$emit('card-click', project)
            }

        },
        provide() {
            return {
            }
        },
        computed:{
            breadcrumb() {
                if (this.tabTitle) {
                    return this.tabTitle.split('-')
                }
                return '应用系统列表';
            },

        },
        mounted() {
            const self = this;


        },
        unmounted() {

        },
        template: `
        <el-row>
            <el-col :span="24">
                 <div class="app-container" >
                     <div class="app-category-title" v-if="false"><i class="iconfont icon-move"></i>{{ tabTitle }}</div>
                     <div class="app-category-content" style="margin-top: 15px;">
                        <div class="app-type-item" v-for="( app, appIdx ) in tableData" @click="doCardClick(app)" :key="app.subsId">
                            <div class="app-info-short">
                                <div class="app-info-short-icon"><svg class="icon svg-icon" style="padding-right: 5px; font-size: 40px; " aria-hidden="true"><use xlink:href="#icon-xiangmuxiezuo"></use></svg>   </div>
                                <div class="app-info-short-name"><el-text type="info" line-clamp="1" truncated>{{ app.subsName }}</el-text></div>
                                <div class="app-info-op" @click.stop.prevent="()=>{}" v-if="false">
                                    <el-dropdown @command="handlerCommand" type="primary" popper-class="app-info-op-dropdown" placement="bottom-start">
                                        <el-button type="default" text icon="MoreFilled"></el-button>
                                        <template #dropdown>
                                            <el-dropdown-menu>
                                                <el-dropdown-item :command="{ command: 'doUpdate', row: app }"><el-icon><Edit ></Edit></el-icon>修改</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doDelete', row: app }"><el-icon><Delete ></Delete></el-icon>删除</el-dropdown-item>
                                            </el-dropdown-menu>
                                        </template>
                                    </el-dropdown>
                                </div>
                            </div>
                            <div class="app-info-desc"><el-text type="info" line-clamp="2">{{app.subsIntro}}</el-text></div>
                        </div>
                        <template v-if="tableData.length % 5 > 0" >
                            <div v-for="n in ( 5 -  ( tableData.length % 5 )) " :key="n" class="app-type-item hide" style="border: none"></div>
                        </template>
                     </div>
                     <el-empty v-if="tableData.length === 0" description="暂无数据"></el-empty>
                </div>
            </el-col>
        </el-row>

        `
    }

}));