/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.assembly.imdbcp;

import com.irdstudio.allinbsp.executor.engine.executor.core.assembly.imdbcp.datasource.DataSourceParm;
import com.irdstudio.allinbsp.executor.engine.executor.core.assembly.imdbcp.datasource.DriverDataSource;
import com.irdstudio.allinbsp.executor.engine.executor.core.assembly.imdbcp.datasource.JndiDataSource;
import com.irdstudio.allinbsp.executor.engine.executor.core.assembly.imdbcp.datasource.PoolDataSource;
import com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements IConnPool {
    private static final Logger logger = LoggerFactory.getLogger(DBManager.class);
    private static DBManager instance = null;
    private static Properties configs = null;
    private DataSourceParm[] connParms = null;
    private DataSource[] dataSources = null;

    private DBManager() {
    }

    public static synchronized DBManager getInstance() {
        if (instance == null) {
            instance = new DBManager();
            try {
                instance.init();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return instance;
    }

    public void init() throws Exception {
        this.connParms = DataSourceParm.getDataSourceParm(configs);
        this.dataSources = new DataSource[this.connParms.length];
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(1);
    }

    public Connection getConnection(int dataSource) throws SQLException {
        return this.getDataSource(dataSource).getConnection();
    }

    private synchronized DataSource getDataSource(int dataSource) throws SQLException {
        if (this.dataSources[dataSource - 1] == null) {
            this.dataSources[dataSource - 1] = this.initDataSource(this.connParms[dataSource - 1]);
        }
        return this.dataSources[dataSource - 1];
    }

    public int getFreeConnectionCount(int dataSource) {
        if (this.dataSources[dataSource - 1] == null) {
            return -1;
        }
        if (this.dataSources[dataSource - 1] instanceof PoolDataSource) {
            PoolDataSource pds = (PoolDataSource)this.dataSources[dataSource - 1];
            return pds.getFreeCount();
        }
        return 0;
    }

    public int getConnectionCount(int dataSource) {
        if (this.dataSources[dataSource - 1] == null) {
            return -1;
        }
        if (this.dataSources[dataSource - 1] instanceof PoolDataSource) {
            PoolDataSource pds = (PoolDataSource)this.dataSources[dataSource - 1];
            return pds.getConnectionCount();
        }
        return 0;
    }

    private DataSource initDataSource(DataSourceParm connParm) throws SQLException {
        if (connParm.getConnectionType() == 1) {
            try {
                return new JndiDataSource(connParm);
            }
            catch (Exception e) {
                throw new SQLException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff01");
            }
        }
        if (connParm.getConnectionType() == 2) {
            return new PoolDataSource(connParm);
        }
        return new DriverDataSource(connParm);
    }

    public void reInit() throws SQLException {
        this.close();
    }

    public void close() {
        for (int i = 0; i < this.dataSources.length; ++i) {
            this.close(i + 1);
            this.dataSources[i] = null;
        }
    }

    public void close(int dataSource) {
        if (dataSource > 0 && this.dataSources.length > dataSource - 1 && this.dataSources[dataSource - 1] != null) {
            if (this.dataSources[dataSource - 1] instanceof PoolDataSource) {
                try {
                    ((PoolDataSource)this.dataSources[dataSource - 1]).close();
                }
                catch (Exception e) {
                    System.err.print("\u672c\u5730\u8fde\u63a5\u6c60\u6570\u636e\u6e90\u5173\u95ed\u5f02\u5e38\uff01");
                    e.printStackTrace(System.err);
                }
            } else if (this.dataSources[dataSource - 1] instanceof DriverDataSource) {
                try {
                    ((DriverDataSource)this.dataSources[dataSource - 1]).close();
                }
                catch (Exception e) {
                    System.err.print("\u76f4\u63a5\u8fde\u63a5\u6570\u636e\u6e90\u5173\u95ed\u5f02\u5e38\uff01");
                    e.printStackTrace(System.err);
                }
            } else if (this.dataSources[dataSource - 1] instanceof JndiDataSource) {
                try {
                    ((JndiDataSource)this.dataSources[dataSource - 1]).close();
                }
                catch (Exception e) {
                    System.err.print("Jndi\u6570\u636e\u6e90\u5173\u95ed\u5f02\u5e38\uff01");
                    e.printStackTrace(System.err);
                }
            }
            this.dataSources[dataSource - 1] = null;
            System.out.println("\u672c\u5730\u6570\u636e\u6e90\u8fde\u63a5\u6c60\u6210\u529f\u5173\u95ed!");
        }
    }

    public static Properties getConfigs() {
        return configs;
    }

    public static void setConfigs(Properties configs) {
        DBManager.configs = configs;
    }

    @Override
    public void releaseConnection(Connection conn) {
        if (conn != null) {
            try {
                if (!conn.isClosed()) {
                    conn.clearWarnings();
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u91ca\u653e\u8fde\u63a5\u51fa\u9519", (Object)conn.toString(), (Object)e);
            }
        }
    }

    @Override
    public int getConnectionCount() {
        return this.getConnectionCount(1);
    }

    @Override
    public void clearAndFree() {
    }
}

