/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.BatBatchStageConfigDao;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.domain.BatBatchStageConfig;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinbsp.executor.engine.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinbsp.executor.engine.executor.core.util.date.DateCalculate;
import com.irdstudio.allinbsp.executor.engine.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatInstBatchDao {
    Connection conn = null;

    public BatInstBatchDao(Connection conn) {
        this.conn = conn;
    }

    public BatInstBatch queryWithKeys(String batchId) throws SQLException {
        BatInstBatch dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch WHERE batch_id=?");
            ps.setString(1, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatInstBatch)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatch.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public BatInstBatch queryByBatchSerialNo(String batchSerialNo) throws SQLException {
        BatInstBatch dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatInstBatch)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatch.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatInstBatch> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatInstBatch> dcList = new ArrayList<BatInstBatch>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstBatch dc = (BatInstBatch)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatch.class));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateStage(BatInstBatch batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            BatBatchStageConfigDao stageDao = new BatBatchStageConfigDao(this.conn);
            BatBatchStageConfig stageInfo = stageDao.queryWithKeys(batchInst.getStageId(), batchInst.getBatchId());
            ps = this.conn.prepareStatement("update bat_inst_batch set batch_state=?,stage_id=?,stage_name=? where batch_serial_no=?");
            ps.setString(1, String.valueOf(3));
            ps.setString(2, batchInst.getStageId());
            ps.setString(3, stageInfo.getStageName());
            ps.setString(4, batchInst.getBatchSerialNo());
            ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
    }

    public void updateBatchToEnd(BatInstBatch batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update bat_inst_batch set batch_state=?,end_time=?,cost_time=?,remark=? where batch_serial_no=?");
            String endTime = CurrentDateUtil.getTodayDateEx2();
            ps.setString(1, batchInst.getBatchState());
            ps.setString(2, endTime);
            ps.setBigDecimal(3, DateCalculate.computeIntervalMills(batchInst.getStartTime(), endTime));
            ps.setString(4, batchInst.getRemark());
            ps.setString(5, batchInst.getBatchSerialNo());
            ps.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO bat_inst_batch_h SELECT * FROM bat_inst_batch WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM bat_inst_batch WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public BatInstBatch queryWithBatchSerialNo(String batchSerialNo) throws SQLException {
        BatInstBatch dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatInstBatch)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatch.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public Map<String, Object> getExtParam(BatInstBatch batInstBatch) {
        Map<String, Object> extParamMap = null;
        try {
            String extParam = batInstBatch.getExtParam();
            extParamMap = (Map)JSON.parseObject((String)extParam, Map.class);
            if (extParamMap == null) {
                extParamMap = new HashMap();
            }
        }
        catch (Exception e) {
            extParamMap = new HashMap<String, Object>();
        }
        return extParamMap;
    }

    public boolean updateByPk(final BatInstBatch paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("bat_inst_batch");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("batch_serial_no")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("batch_serial_no = ? ");
                param.add(paramVO.getBatchSerialNo());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return rs == 1;
    }

    public List<BatInstBatch> queryList(final BatInstBatch paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("bat_inst_batch");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("end_time desc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<BatInstBatch> list = new ArrayList<BatInstBatch>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstBatch bean = (BatInstBatch)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatch.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryList is wrong", e);
        }
        return list;
    }
}

