/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.plugin.common;

import com.irdstudio.allinbsp.executor.engine.executor.core.plugin.common.SParamInfo;
import com.irdstudio.allinbsp.executor.engine.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SParamInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(SParamInfoDao.class);
    Connection conn = null;

    public SParamInfoDao(Connection conn) {
        this.conn = conn;
    }

    public SParamInfo querySParamInfoWithKeys(String paramCode) throws SQLException {
        SParamInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_param_info WHERE param_code=?");
            ps.setString(1, paramCode);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new SParamInfo();
                dc.setParamCode(rs.getString("param_code"));
                dc.setParamName(rs.getString("param_name"));
                dc.setParamValue(rs.getString("param_value"));
                dc.setParamScope(rs.getString("param_scope"));
                dc.setSubsId(rs.getString("subs_id"));
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySParamInfoWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<SParamInfo> queryAll() throws SQLException {
        ArrayList<SParamInfo> dcList = new ArrayList<SParamInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_param_info");
            rs = ps.executeQuery();
            while (rs.next()) {
                SParamInfo dc = new SParamInfo();
                dc.setParamCode(rs.getString("param_code"));
                dc.setParamName(rs.getString("param_name"));
                dc.setParamValue(rs.getString("param_value"));
                dc.setParamScope(rs.getString("param_scope"));
                dc.setSubsId(rs.getString("subs_id"));
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySParamInfoWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public List<SParamInfo> queryTaskParamList(final SParamInfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("s_param_info");
                List vals = POJOUtils.getPOJOValues((Object)paramVO);
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SParamInfo> list = new ArrayList<SParamInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SParamInfo bean = (SParamInfo)POJOUtils.generatePOJO((ResultSet)rs, SParamInfo.class);
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryTaskParamList is wrong", e);
        }
        return list;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

