/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.plugin.common;

import com.irdstudio.allinbsp.executor.engine.executor.core.plugin.common.SSubsDatasource;
import com.irdstudio.allinbsp.executor.engine.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSubsDatasourceDao {
    private static final Logger logger = LoggerFactory.getLogger(SSubsDatasourceDao.class);
    Connection conn = null;

    public SSubsDatasourceDao(Connection conn) {
        this.conn = conn;
    }

    public SSubsDatasource queryByPk(final String subsId, final String subsDsCode) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_subs_datasource");
                this.WHERE("subs_id = ?");
                param.add(subsId);
                this.WHERE("subs_ds_code = ?");
                param.add(subsDsCode);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SSubsDatasource> list = new ArrayList<SSubsDatasource>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsDatasource bean = (SSubsDatasource)POJOUtils.generatePOJO((ResultSet)rs, SSubsDatasource.class);
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryByPk is wrong", e);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return list.isEmpty() ? null : (SSubsDatasource)list.get(0);
    }

    public List<SSubsDatasource> queryList(final SSubsDatasource paramVO) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_subs_datasource");
                List vals = POJOUtils.getPOJOValues((Object)paramVO);
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SSubsDatasource> list = new ArrayList<SSubsDatasource>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsDatasource bean = (SSubsDatasource)POJOUtils.generatePOJO((ResultSet)rs, SSubsDatasource.class);
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryList is wrong", e);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return list;
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.s_subs_datasource");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            int re;
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int n = re = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int deleteMetaTaskByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.s_subs_metatask");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            int re;
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int n = re = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

