/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.plugin.dataload;

import com.irdstudio.allinbsp.executor.engine.executor.core.plugin.dataload.PluginLoadConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoadConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginLoadConfDao.class);
    Connection conn = null;

    public PluginLoadConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginLoadConf queryWithKeys(String pluginConfId, String tableName) throws SQLException {
        PluginLoadConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_load_conf WHERE plugin_conf_id=? and table_name=?");
            ps.setString(1, pluginConfId);
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginLoadConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setTableName(rs.getString("table_name"));
                dc.setTableCnname(rs.getString("table_cnname"));
                dc.setTableType(rs.getString("table_type"));
                dc.setUpSysname(rs.getString("up_sysname"));
                dc.setTableLoadMode(rs.getString("table_load_mode"));
                dc.setLoadFromFile(rs.getString("load_from_file"));
                dc.setFileCharset(rs.getString("file_charset"));
                dc.setLoadBufferSize(rs.getInt("load_buffer_size"));
                dc.setLoadSeparator(rs.getString("load_separator"));
                dc.setLoadFields(rs.getString("load_fields"));
                dc.setCreateTableDdl(rs.getString("create_table_ddl"));
                dc.setBeforeLoadSql(rs.getString("before_load_sql"));
                dc.setAfterLoadSql(rs.getString("after_load_sql"));
                dc.setFileRowFlag(rs.getString("file_row_flag"));
                dc.setLoadWarnFlag(rs.getString("load_warn_flag"));
                dc.setDiffCompMethod(rs.getString("diff_comp_method"));
                dc.setLimitPercent(rs.getInt("limit_percent"));
                dc.setDiffDealMethod(rs.getString("diff_deal_method"));
                dc.setLoadFaildDeal(rs.getString("load_faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dc.setIsDealEmptyStr(rs.getString("is_deal_empty_str"));
                dc.setDealEmptyStr(rs.getString("deal_empty_str"));
                dc.setIsFirstline(rs.getString("is_first_line"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginLoadConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginLoadConf> queryWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginLoadConf> dcList = new ArrayList<PluginLoadConf>();
        PluginLoadConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_load_conf WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginLoadConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setTableName(rs.getString("table_name"));
                dc.setTableCnname(rs.getString("table_cnname"));
                dc.setTableType(rs.getString("table_type"));
                dc.setUpSysname(rs.getString("up_sysname"));
                dc.setTableLoadMode(rs.getString("table_load_mode"));
                dc.setLoadFromFile(rs.getString("load_from_file"));
                dc.setFileCharset(rs.getString("file_charset"));
                dc.setLoadBufferSize(rs.getInt("load_buffer_size"));
                dc.setLoadSeparator(rs.getString("load_separator"));
                dc.setLoadFields(rs.getString("load_fields"));
                dc.setCreateTableDdl(rs.getString("create_table_ddl"));
                dc.setBeforeLoadSql(rs.getString("before_load_sql"));
                dc.setAfterLoadSql(rs.getString("after_load_sql"));
                dc.setFileRowFlag(rs.getString("file_row_flag"));
                dc.setLoadWarnFlag(rs.getString("load_warn_flag"));
                dc.setDiffCompMethod(rs.getString("diff_comp_method"));
                dc.setLimitPercent(rs.getInt("limit_percent"));
                dc.setDiffDealMethod(rs.getString("diff_deal_method"));
                dc.setLoadFaildDeal(rs.getString("load_faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dc.setIsDealEmptyStr(rs.getString("is_deal_empty_str"));
                dc.setDealEmptyStr(rs.getString("deal_empty_str"));
                dc.setIsFirstline(rs.getString("is_first_line"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginLoadConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

