/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.plugin.invoke;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinbsp.executor.engine.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinbsp.executor.engine.facade.operation.PluginServiceConfService;
import com.irdstudio.allinbsp.executor.engine.facade.operation.PluginServiceParamService;
import com.irdstudio.allinbsp.executor.engine.facade.operation.dto.PluginServiceConfDTO;
import com.irdstudio.allinbsp.executor.engine.facade.operation.dto.PluginServiceParamDTO;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mortbay.util.ajax.JSON;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class FeignClientInvokePlugin
extends AbstractPlugin {
    private BatInstBatch batInst;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    @Override
    public boolean execute() {
        NacosDiscoveryClient nacosClient = (NacosDiscoveryClient)SpringContextUtils.getBean(NacosDiscoveryClient.class);
        Decoder decoder = (Decoder)SpringContextUtils.getBean(Decoder.class);
        Encoder encoder = (Encoder)SpringContextUtils.getBean(Encoder.class);
        Client client = (Client)SpringContextUtils.getBean(Client.class);
        Contract contract = (Contract)SpringContextUtils.getBean(Contract.class);
        PluginServiceConfService pluginServiceConfService = (PluginServiceConfService)SpringContextUtils.getBean(PluginServiceConfService.class);
        PluginServiceParamService pluginServiceParamService = (PluginServiceParamService)SpringContextUtils.getBean(PluginServiceParamService.class);
        PluginServiceConfDTO serviceConfig = new PluginServiceConfDTO();
        serviceConfig.setPluginConfId(this.context.getSzTaskId());
        serviceConfig.setConfSort(Integer.valueOf(1));
        serviceConfig = pluginServiceConfService.queryByPk(serviceConfig);
        String serviceId = serviceConfig.getServiceId();
        List nacosServiceList = nacosClient.getInstances(serviceId);
        if (CollectionUtils.isEmpty((Collection)nacosServiceList)) {
            this.logger.error("\u672a\u627e\u5230\u6307\u5b9a\u670d\u52a1\u5b9e\u4f8b " + serviceId);
            return false;
        }
        ServiceInstance serviceInstance = (ServiceInstance)nacosServiceList.get(0);
        String appPath = (String)serviceInstance.getMetadata().get("appPath");
        try {
            JobInvokeService service = (JobInvokeService)Feign.builder().client(client).encoder(encoder).decoder(decoder).contract(contract).options(new Request.Options(300000, 300000)).retryer(Retryer.NEVER_RETRY).target(JobInvokeService.class, String.format("http://%s/%s", serviceInstance.getServiceId(), appPath));
            HashMap<String, String> extParam = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)serviceConfig.getParamGroupId())) {
                PluginServiceParamDTO param = new PluginServiceParamDTO();
                param.setParamGroupId(serviceConfig.getParamGroupId());
                param.setSize(Integer.valueOf(Integer.MAX_VALUE));
                List paramList = pluginServiceParamService.queryList(param);
                if (CollectionUtils.isNotEmpty((Collection)paramList)) {
                    for (PluginServiceParamDTO serviceParam : paramList) {
                        extParam.put(serviceParam.getServiceParamName(), serviceParam.getServiceParamValue());
                    }
                }
            }
            this.batInst.setExtParam(JSON.toString(extParam));
            int output = service.execute(serviceConfig.getServiceMethod(), this.batInst);
            this.logger.info(serviceConfig.getServiceMethod() + "\u670d\u52a1\u6267\u884c\u7ed3\u679c\uff1a" + output);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u5f02\u5e38 " + e.getMessage(), e);
            return false;
        }
    }

    @FeignClient(value="JobInvokeService")
    public static interface JobInvokeService {
        @RequestMapping(value={"/client/JobService/execute"}, method={RequestMethod.POST})
        @ResponseBody
        public int execute(@RequestParam(value="jobId") String var1, @RequestBody BatInstBatch var2);
    }
}

