/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.jdbc.meta;

import com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.log.TLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class MetaTable {
    private boolean isExist = false;
    public int fieldCount = 0;
    public String[] fields = null;
    public int[] fieldLengths = null;
    public int[] fieldTypes = null;
    public String[] signs = null;

    public static MetaTable getInstWithTable(Connection conn, String tableName) {
        String sql = "select * from " + tableName + " where 1=2";
        return new MetaTable(conn, sql);
    }

    public static MetaTable getInstWithQuery(Connection conn, String sql) {
        return new MetaTable(conn, "select * from (" + sql + ") a where 1=2");
    }

    private MetaTable(Connection conn, String sql) {
        try (Statement st = conn.createStatement();
             ResultSet set = st.executeQuery(sql);){
            ResultSetMetaData meta = set.getMetaData();
            this.fieldCount = meta.getColumnCount();
            if (this.fieldCount > 0) {
                this.isExist = true;
            }
            this.fields = new String[this.fieldCount];
            this.fieldLengths = new int[this.fieldCount];
            this.fieldTypes = new int[this.fieldCount];
            this.signs = new String[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                this.fields[i] = meta.getColumnName(i + 1);
                this.fieldLengths[i] = meta.getColumnDisplaySize(i + 1);
                this.fieldTypes[i] = meta.getColumnType(i + 1);
                this.signs[i] = this.getSign(this.fieldTypes[i]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            TLogger.getLogger("JDBC.META:").error("\u83b7\u53d6\u5143\u6570\u636e\u65f6,\u53d1\u751f\u9519\u8bef!\n" + sql);
        }
    }

    public String getSign(int dataType) {
        String tmp = "";
        switch (dataType) {
            case -6: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                tmp = "'";
            }
        }
        return tmp;
    }

    public boolean isTableExist() {
        return this.isExist;
    }
}

