/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.log;

import com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinbsp.executor.engine.executor.core.tinycore.log.TLogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileLogger
implements ILogger {
    private static final Logger console = LoggerFactory.getLogger(TextFileLogger.class);
    private String categoryName = "";
    private OutputStreamWriter logFile = null;
    private boolean isStillOnConsole = false;

    public TextFileLogger(String fullLogFileName, boolean isStillOnConsole) {
        this.isStillOnConsole = isStillOnConsole;
        try {
            this.logFile = new OutputStreamWriter((OutputStream)new FileOutputStream(fullLogFileName), "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("\u521d\u59cb\u5316\u81ea\u5b9a\u4e49\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25!");
        }
    }

    public TextFileLogger(String fullLogFileName) {
        new TextFileLogger(fullLogFileName, false);
    }

    private void writeToLogFile(int type, Object message, Throwable te) {
        StringBuffer msg = new StringBuffer("[");
        msg.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
        msg.append("][").append(this.categoryName);
        msg.append("][").append(TLogger.typeInfo[type]).append("]:");
        msg.append(message).append("\r\n");
        if (this.isStillOnConsole) {
            console.warn(msg.toString(), te);
        }
        if (te != null) {
            StringWriter sw = new StringWriter();
            te.printStackTrace(new PrintWriter(sw));
            msg.append(sw.getBuffer());
        }
        try {
            this.logFile.write(msg.toString());
            this.logFile.flush();
        }
        catch (IOException e) {
            System.err.println("\u8bb0\u5f55\u65e5\u5fd7\u5230\u6587\u4ef6\u6587\u4ef6\u53d1\u751f\u9519\u8bef!");
            e.printStackTrace();
        }
    }

    private void writeToLogFile(int type, Object message) {
        this.writeToLogFile(type, message, null);
    }

    @Override
    public void debug(Object message) {
        this.writeToLogFile(0, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.writeToLogFile(0, message, t);
    }

    @Override
    public void error(Object message) {
        this.writeToLogFile(4, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.writeToLogFile(4, message, t);
    }

    @Override
    public void fatal(Object message) {
        this.writeToLogFile(4, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.writeToLogFile(4, message, t);
    }

    @Override
    public void info(Object message) {
        this.writeToLogFile(2, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.writeToLogFile(2, message, t);
    }

    @Override
    public void setName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public void warn(Object message) {
        this.writeToLogFile(3, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.writeToLogFile(3, message, t);
    }

    public void closeLogFile() {
        try {
            this.logFile.flush();
            this.logFile.close();
        }
        catch (IOException e) {
            System.err.println("\u5173\u95ed\u81ea\u5b9a\u4e49\u65e5\u5fd7\u6587\u4ef6\u65f6\u5931\u8d25!");
            e.printStackTrace();
        }
    }

    public void finalize() {
        this.closeLogFile();
    }

    @Override
    public ILogger makeSubLogger(String subCategoryName) {
        ILogger subLogger = null;
        try {
            subLogger = (ILogger)this.clone();
            subLogger.setName(this.categoryName + "-" + subCategoryName);
            return subLogger;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return subLogger;
        }
    }
}

