/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.core.util.date;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
    public static List<?> getBetweenDate(String beginDate, String endDate) {
        List<Object> dates = new ArrayList();
        if (beginDate.length() != endDate.length()) {
            return null;
        }
        switch (beginDate.length()) {
            case 4: {
                dates = DateUtil.getBetweenDate4(beginDate, endDate);
                break;
            }
            case 6: {
                dates = DateUtil.getBetweenDate6(beginDate, endDate);
                break;
            }
            case 8: {
                dates = DateUtil.getBetweenDate8(beginDate, endDate);
                break;
            }
            default: {
                return null;
            }
        }
        return dates;
    }

    public static List<Integer> getBetweenDate4(String beginDate, String endDate) {
        ArrayList<Integer> betweendays = new ArrayList<Integer>();
        int beginrq = Integer.parseInt(beginDate);
        int endrq = Integer.parseInt(endDate);
        int between = 0;
        for (int i = 0; i <= endrq - beginrq; ++i) {
            between = beginrq + i;
            betweendays.add(new Integer(between));
        }
        return betweendays;
    }

    public static List<Integer> getBetweenDate6(String beginDate, String endDate) {
        ArrayList<Integer> betweendays = new ArrayList<Integer>();
        int beginrq = Integer.parseInt(beginDate);
        int endrq = Integer.parseInt(endDate);
        int between = 0;
        int yf1 = beginrq % 100;
        int nf1 = beginrq / 100;
        int yf2 = endrq % 100;
        int nf2 = endrq / 100;
        for (int i = 0; i <= (nf2 - nf1) * 12 - (yf2 - yf1); ++i) {
            between = (nf1 + (yf1 + i) / 12) * 100;
            between = (yf1 + i) % 12 == 0 ? (between += 12) : (between += yf1 + (yf1 + i) % 12);
            betweendays.add(new Integer(between));
        }
        return betweendays;
    }

    public static List<Integer> getBetweenDate8(String beginDate, String endDate) {
        ArrayList<Integer> betweendays = new ArrayList<Integer>();
        int beginrq = Integer.parseInt(beginDate);
        int endrq = Integer.parseInt(endDate);
        int between = 0;
        int yf1 = beginrq / 100 % 100;
        int nf1 = beginrq / 10000;
        int rq1 = beginrq % 100;
        int yf2 = endrq / 100 % 100;
        int nf2 = endrq / 10000;
        int rq2 = endrq % 100;
        for (int i = 0; i <= ((nf2 - nf1) * 12 - (yf2 - yf1)) * 31 + (rq2 - rq1); ++i) {
            between = DateUtil.getDate(nf1, yf1, rq1, i);
            betweendays.add(new Integer(between));
        }
        return betweendays;
    }

    public static int getDate(int nf, int yf, int rq, int relaValue) {
        boolean rn = false;
        boolean flag = true;
        boolean bz = true;
        int date = 0;
        int days = 0;
        if (nf % 4 == 0 && (nf % 400 == 0 || nf % 100 != 0) && yf == 2 && rq == 29) {
            rn = true;
        }
        rq += relaValue;
        while (flag) {
            if (yf > 12) {
                yf -= 12;
                ++nf;
                continue;
            }
            if (yf < 1) {
                yf += 12;
                --nf;
                continue;
            }
            switch (yf) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    days = 31;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    days = 30;
                    break;
                }
                case 2: {
                    days = nf % 4 == 0 && (nf % 400 == 0 || nf % 100 != 0) ? 29 : 28;
                }
            }
            if (rq > days) {
                rq -= days;
                ++yf;
                if (!rn) continue;
                --rq;
                continue;
            }
            if (rq < 1) {
                if (bz) {
                    rq += days;
                    bz = false;
                    continue;
                }
                --yf;
                bz = true;
                continue;
            }
            if (!bz) {
                --yf;
                bz = true;
                continue;
            }
            flag = false;
        }
        if (nf < 1900) {
            System.out.println("\u5e74\u4efd\u6570\u503c\u592a\u5c0f: " + nf);
            return 0;
        }
        if (nf > 9999) {
            System.out.println("\u5e74\u4efd\u6570\u503c\u592a\u5927: " + nf);
            return 0;
        }
        date = nf * 10000 + yf * 100 + rq;
        return date;
    }

    public static int getDaysBetween(String start, String end, boolean isShort) {
        String startDate = DateUtil.formatDate(start, isShort);
        String endDate = DateUtil.formatDate(end, isShort);
        GregorianCalendar calStart = null;
        GregorianCalendar calEnd = null;
        if (startDate != null && endDate != null) {
            long lngEnd;
            calStart = new GregorianCalendar(DateUtil.getYear(startDate, false), DateUtil.getMonth(startDate, false) - 1, DateUtil.getDay(startDate, false));
            calEnd = new GregorianCalendar(DateUtil.getYear(endDate, false), DateUtil.getMonth(endDate, false) - 1, DateUtil.getDay(endDate, false));
            long lngStart = calStart.getTimeInMillis();
            if (lngStart > (lngEnd = calEnd.getTimeInMillis())) {
                return -1;
            }
            int nDay = (int)((lngEnd - lngStart) / 86400000L);
            return nDay;
        }
        return -1;
    }

    public static String formatDate(String date, boolean isShort) {
        if (!(isShort || date != null && date.length() == 8)) {
            return null;
        }
        if (isShort && (date == null || date.length() != 6)) {
            return null;
        }
        String res = null;
        GregorianCalendar calendar = null;
        int nYear = 0;
        int nMonth = 0;
        int nDay = 0;
        if (!isShort) {
            nYear = Integer.parseInt(date.substring(0, 4));
            nMonth = Integer.parseInt(date.substring(4, 6));
            nDay = Integer.parseInt(date.substring(6, date.length()));
            calendar = nMonth == 0 ? new GregorianCalendar(nYear, nMonth, nDay) : new GregorianCalendar(nYear, nMonth - 1, nDay);
        } else {
            nYear = Integer.parseInt(date.substring(0, 2));
            nMonth = Integer.parseInt(date.substring(2, 4));
            nDay = Integer.parseInt(date.substring(4, date.length()));
            calendar = nMonth == 0 ? new GregorianCalendar(nYear + 1900, nMonth, nDay) : new GregorianCalendar(nYear + 1900, nMonth - 1, nDay);
        }
        res = new Integer(calendar.get(1)).toString();
        nMonth = calendar.get(2) + 1;
        res = nMonth < 10 ? res + "0" + new Integer(calendar.get(2) + 1).toString() : res + new Integer(calendar.get(2) + 1).toString();
        nDay = calendar.get(5);
        res = nDay < 10 ? res + "0" + new Integer(calendar.get(5)).toString() : res + new Integer(calendar.get(5)).toString();
        return res;
    }

    public static String timeMillis2Format(String formatStr) {
        String reg = "^((yyyy\u5e74MM\u6708dd\u65e5)|(yyyy\\-MM\\-dd)|(yyyy/MM/dd)|(MM/dd/yyyy)|(MM/dd,yyyy)|(yyyyMMdd)){1}(\\s{1}HH:mm:ss){0,1}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(formatStr);
        String res = "0000-00-00 00:00:00";
        long timeMillis = System.currentTimeMillis();
        if (formatStr == null || "".equals(formatStr) || !matcher.matches()) {
            formatStr = "yyyy-MM-dd HH:mm:ss";
        }
        Date date = new Date(timeMillis);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        res = dateFormat.format(date);
        return res;
    }

    public static int getYear(String date, boolean isShort) {
        date = Objects.requireNonNull(DateUtil.formatDate(date, isShort));
        int nYear = Integer.parseInt(date.substring(0, 4));
        return nYear;
    }

    public static int getMonth(String date, boolean isShort) {
        date = Objects.requireNonNull(DateUtil.formatDate(date, isShort));
        int nMonth = Integer.parseInt(date.substring(4, 6));
        return nMonth;
    }

    public static int getDay(String date, boolean isShort) {
        date = Objects.requireNonNull(DateUtil.formatDate(date, isShort));
        int nDay = Integer.parseInt(date.substring(6, date.length()));
        return nDay;
    }

    public static String convertToShort(String date) {
        return date.replaceAll("-", "");
    }

    public static final Date string2UtilDateYMD(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        dateFormat.setLenient(false);
        Date timeDate = dateFormat.parse(dateString);
        return timeDate;
    }

    public static final String calculateEndDate(String startDate_str, BigDecimal term, String type) throws Exception {
        if (startDate_str == null || term == null || type == null || startDate_str.equals("") || type.equals("")) {
            return "\u65f6\u95f4\u8ba1\u7b97\u6240\u9700\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5";
        }
        String endDate_str = "";
        Date startDate = DateUtil.string2UtilDateYMD(startDate_str);
        Calendar startDate_cal = Calendar.getInstance();
        startDate_cal.setTime(startDate);
        int term_int = term.intValue();
        if (type.equals("D")) {
            startDate_cal.add(5, term_int);
        } else if (type.equals("M")) {
            startDate_cal.add(2, term_int);
        } else if (type.equals("Y")) {
            startDate_cal.add(1, term_int);
        }
        Date endDate = startDate_cal.getTime();
        endDate_str = DateUtil.formatDate2Str(endDate, "yyyy-MM-dd");
        return endDate_str;
    }

    public static final String formatDate2Str(Date inDate) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(inDate);
    }

    public static final String formatDate2Str(Date inDate, String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(inDate);
    }

    public static void main(String[] args) {
        String str = DateUtil.timeMillis2Format("yyyyMMdd");
        System.err.println(str);
        int i = DateUtil.getDaysBetween("20080714", "20080713", false);
        System.err.println(i);
    }
}

