/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.executor.rest.job;

import com.irdstudio.allinbsp.executor.engine.executor.core.batch.BatchRunEngine;
import com.irdstudio.allinbsp.executor.engine.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.allinbsp.executor.engine.executor.rest.job.ScheduleJob;
import com.irdstudio.allinbsp.executor.engine.facade.operation.dto.ResponseVO;
import com.irdstudio.framework.beans.core.util.TimeUtil;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStarter
implements ScheduleJob {
    private static final Logger logger = LoggerFactory.getLogger(BatchStarter.class);

    @Override
    public void doExecute(Connection conn, SSrvsCronConf conf) {
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        ResponseVO vo = new ResponseVO();
        try {
            if (conf != null && StringUtils.isNotEmpty((CharSequence)conf.getJobCode())) {
                String defaultAction = "run";
                String batchId = conf.getJobCode();
                logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u5f00\u59cb, \u6279\u6b21ID\uff1a" + batchId + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + defaultAction);
                String batchSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                BatchRunEngine batchEngine = new BatchRunEngine(batchSerialNo, defaultAction, batchId);
                batchEngine.start();
                vo.setFlag("success");
                vo.setMsg("\u6210\u529f\u53d1\u8d77\u6279\u6b21");
            } else {
                logger.error("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u51fa\u9519, \u6ca1\u6709\u6307\u5b9a\u5b9a\u65f6\u6279\u6b21\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u7ed3\u675f");
    }
}

