/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinbsp.executor.engine.web.operation;

import com.irdstudio.allinbsp.executor.engine.executor.core.batch.BatchRunEngine;
import com.irdstudio.allinbsp.executor.engine.executor.rest.init.ExecutorResourceLoader;
import com.irdstudio.allinbsp.executor.engine.executor.rest.job.BatchStarter;
import com.irdstudio.allinbsp.executor.engine.facade.operation.dto.ResponseVO;
import com.irdstudio.framework.beans.core.util.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/executor"})
public class BatchController
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BatchStarter.class);
    @Value(value="${agent.batch.log.path}")
    private String logPath;

    @RequestMapping(value={"/batch/start"}, method={RequestMethod.GET})
    public ResponseVO startBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction, @RequestParam(value="envId", required=false) String envId) {
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        ResponseVO vo = new ResponseVO();
        try {
            logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u5f00\u59cb, \u6279\u6b21ID\uff1a" + batchId + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + batchAction);
            if (StringUtils.isNotBlank((CharSequence)batchSerialNo)) {
                BatchRunEngine batchEngine = new BatchRunEngine(batchSerialNo, batchAction, batchId, envId, null);
                batchEngine.start();
            } else {
                BatchRunEngine batchEngine = new BatchRunEngine(null, batchAction, batchId, envId, null);
                batchEngine.start();
            }
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u6279\u6b21");
        }
        catch (Exception e) {
            logger.error("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }

    @RequestMapping(value={"/batch/start"}, method={RequestMethod.POST})
    public ResponseVO startWithParamBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction, @RequestParam(value="envId", required=false) String envId, @RequestBody Map<String, Object> param) {
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        ResponseVO vo = new ResponseVO();
        try {
            logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u5f00\u59cb, \u6279\u6b21ID\uff1a" + batchId + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + batchAction);
            if (StringUtils.isNotBlank((CharSequence)batchSerialNo)) {
                BatchRunEngine batchEngine = new BatchRunEngine(batchSerialNo, batchAction, batchId, envId, param);
                batchEngine.start();
            } else {
                BatchRunEngine batchEngine = new BatchRunEngine(null, batchAction, batchId, envId, param);
                batchEngine.start();
            }
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u6279\u6b21");
        }
        catch (Exception e) {
            logger.error("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u65e5\u7ec8\u670d\u52a1\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }

    @RequestMapping(value={"/batch/log"}, method={RequestMethod.GET})
    public ResponseVO getBatchRunLogs(@RequestParam(value="batchId", required=false) String batchId, @RequestParam(value="batchSerialNo", required=false) String batchSerialNo) {
        ResponseVO responseVO;
        block4: {
            logger.info("\u83b7\u53d6\u6279\u6b21\u65e5\u5fd7\u4fe1\u606f\u5f00\u59cb\uff0c\u6279\u6b21\u53f7:" + batchId);
            responseVO = new ResponseVO();
            try {
                File file = new File(this.logPath);
                if (file.exists() && Objects.nonNull(file.listFiles())) {
                    File[] files;
                    for (File f : files = file.listFiles()) {
                        if (!f.isFile() || !f.getName().contains(batchSerialNo)) continue;
                        String output = FileUtil.readFileByLines((String)f.getAbsolutePath());
                        responseVO.setFlag("success");
                        responseVO.setMsg(output);
                    }
                    break block4;
                }
                throw new Exception("\u8def\u5f84:" + this.logPath + "\uff0c\u4e0d\u5b58\u5728\u6587\u4ef6");
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6279\u6b21\u65e5\u5fd7\u4fe1\u606f\u51fa\u9519\uff0c\u6279\u6b21\u53f7:" + batchId);
                e.printStackTrace();
                responseVO.setFlag("fail");
                responseVO.setMsg(e.getMessage());
            }
        }
        return responseVO;
    }

    public void afterPropertiesSet() throws Exception {
        ExecutorResourceLoader.me().start();
    }
}

