/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allincloud.portal.web.controller.api;

import com.irdstudio.allincloud.portal.facade.SDynamicLogService;
import com.irdstudio.allincloud.portal.facade.dto.SDynamicLogDTO;
import com.irdstudio.allinpaas.portal.facade.PaasAppsInfoService;
import com.irdstudio.allinpaas.portal.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.sdk.admin.service.facade.SUserService;
import com.irdstudio.sdk.admin.service.vo.SUserVO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class GitlabEventHookController {
    private static final Logger logger = LoggerFactory.getLogger(GitlabEventHookController.class);
    @Autowired
    private SDynamicLogService sDynamicLogService;
    @Autowired
    @Qualifier(value="sUserServiceImpl")
    private SUserService sUserService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;

    @RequestMapping(value={"/client/gitlab/push/event"}, method={RequestMethod.POST})
    public void getUserInfo(@RequestBody PushEventBody params, HttpServletRequest request) {
        try {
            String appInfo = params.getRepository().getDescription();
            String userId = params.getUser_name();
            SUserVO userInfo = new SUserVO();
            userInfo.setActorno(userId);
            userInfo = this.sUserService.queryByPk(userInfo);
            if (userInfo == null) {
                userInfo = new SUserVO();
                userInfo.setActorno(userId);
                userInfo.setActorname(userId);
            }
            PaasAppsInfoDTO appInfoDTO = this.queryAppInfo(params.getProject());
            appInfo = this.genAppInfoDesc(appInfoDTO, params.getRepository().getDescription());
            if (CollectionUtils.isNotEmpty(params.getCommits())) {
                ArrayList<SDynamicLogDTO> logList = new ArrayList<SDynamicLogDTO>();
                for (Commit commit : params.getCommits()) {
                    SDynamicLogDTO log = new SDynamicLogDTO();
                    log.setDlType1("gitlab");
                    log.setUserId(userInfo.getActorno());
                    log.setUserName(userInfo.getActorname());
                    log.setDlBizkey(StringUtils.substring((String)commit.getId(), (int)-8));
                    log.setDlLogId(UUIDUtil.getUUID());
                    Date date = DateUtils.parseDate((String)commit.getTimestamp(), (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ssZZ"});
                    String dateStr = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
                    String timeStr = DateFormatUtils.format((Date)date, (String)"HH:mm:ss");
                    log.setDlDate(dateStr);
                    log.setDlTime(timeStr);
                    log.setDlText(String.format("%s <span class=\"timeline-href\" href=\"%s\">#%s</span> %s", appInfo, commit.getUrl(), log.getDlBizkey(), commit.getMessage()));
                    logList.add(log);
                }
                if (CollectionUtils.isNotEmpty(logList)) {
                    this.sDynamicLogService.batchInsert(logList);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536gitlab \u63d0\u4ea4\u4e8b\u4ef6\u5904\u7406\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String genAppInfoDesc(PaasAppsInfoDTO appInfo, String defaultVal) {
        if (appInfo != null) {
            return String.format("<span class=\"timeline-href\" subs=\"%s\">#%s</span>%s <span class=\"timeline-href\" app=\"%s\">#%s</span>%s", appInfo.getSubsId(), appInfo.getSubsId(), appInfo.getSubsName(), appInfo.getAppId(), appInfo.getAppId(), appInfo.getAppName());
        }
        return defaultVal;
    }

    private PaasAppsInfoDTO queryAppInfo(Project project) {
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setAppCode(project.getName());
        String url = project.getWeb_url();
        String subsCode = StringUtils.replace((String)url, (String)("/" + project.getName()), (String)"");
        subsCode = StringUtils.substring((String)subsCode, (int)(StringUtils.lastIndexOf((CharSequence)subsCode, (CharSequence)"/") + 1));
        appParam.setSubsCode(subsCode);
        List appList = this.paasAppsInfoService.queryListByPage((Object)appParam);
        if (CollectionUtils.isNotEmpty((Collection)appList)) {
            return (PaasAppsInfoDTO)appList.get(0);
        }
        return null;
    }

    public static class Author {
        private String name;
        private String email;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    public static class Commit {
        private String id;
        private String message;
        private String timestamp;
        private String url;
        private Author author;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Author getAuthor() {
            return this.author;
        }

        public void setAuthor(Author author) {
            this.author = author;
        }
    }

    public static class Repository {
        private String name;
        private String url;
        private String description;
        private String homepage;
        private String git_http_url;
        private String git_ssh_url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String homepage) {
            this.homepage = homepage;
        }

        public String getGit_http_url() {
            return this.git_http_url;
        }

        public void setGit_http_url(String git_http_url) {
            this.git_http_url = git_http_url;
        }

        public String getGit_ssh_url() {
            return this.git_ssh_url;
        }

        public void setGit_ssh_url(String git_ssh_url) {
            this.git_ssh_url = git_ssh_url;
        }
    }

    public static class Project {
        private String name;
        private String git_ssh_url;
        private String git_http_url;
        private String namespace;
        private String url;
        private String web_url;
        private String ssh_url;
        private String http_url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGit_ssh_url() {
            return this.git_ssh_url;
        }

        public void setGit_ssh_url(String git_ssh_url) {
            this.git_ssh_url = git_ssh_url;
        }

        public String getGit_http_url() {
            return this.git_http_url;
        }

        public void setGit_http_url(String git_http_url) {
            this.git_http_url = git_http_url;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSsh_url() {
            return this.ssh_url;
        }

        public void setSsh_url(String ssh_url) {
            this.ssh_url = ssh_url;
        }

        public String getHttp_url() {
            return this.http_url;
        }

        public void setHttp_url(String http_url) {
            this.http_url = http_url;
        }

        public String getWeb_url() {
            return this.web_url;
        }

        public void setWeb_url(String web_url) {
            this.web_url = web_url;
        }
    }

    public static class PushEventBody {
        private String event_name;
        private String user_id;
        private String user_name;
        private String user_email;
        private String project_id;
        private Project project;
        private Repository repository;
        private List<Commit> commits;

        public String getEvent_name() {
            return this.event_name;
        }

        public void setEvent_name(String event_name) {
            this.event_name = event_name;
        }

        public String getUser_id() {
            return this.user_id;
        }

        public void setUser_id(String user_id) {
            this.user_id = user_id;
        }

        public String getUser_name() {
            return this.user_name;
        }

        public void setUser_name(String user_name) {
            this.user_name = user_name;
        }

        public String getUser_email() {
            return this.user_email;
        }

        public void setUser_email(String user_email) {
            this.user_email = user_email;
        }

        public String getProject_id() {
            return this.project_id;
        }

        public void setProject_id(String project_id) {
            this.project_id = project_id;
        }

        public Project getProject() {
            return this.project;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public void setRepository(Repository repository) {
            this.repository = repository;
        }

        public List<Commit> getCommits() {
            return this.commits;
        }

        public void setCommits(List<Commit> commits) {
            this.commits = commits;
        }
    }
}

