/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.cpn.application.operation;

import com.irdstudio.allinflow.cpn.acl.repository.CpnConfMasterFormRepository;
import com.irdstudio.allinflow.cpn.domain.entity.CpnConfMasterFormDO;
import com.irdstudio.allinflow.cpn.facade.operation.CpnConfMasterFormService;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfMasterFormDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.DateDataVO;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service(value="CpnConfMasterFormServiceImpl")
public class CpnConfMasterFormServiceImpl
extends BaseServiceImpl<CpnConfMasterFormDTO, CpnConfMasterFormDO, CpnConfMasterFormRepository>
implements CpnConfMasterFormService {
    public int insertSingle(CpnConfMasterFormDTO input) {
        if (Strings.isBlank((String)input.getCpnId())) {
            String randomString = CpnConfMasterFormServiceImpl.generateRandomString(10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
            input.setCpnId(randomString);
        }
        if (Strings.isBlank((String)input.getCpnCategory())) {
            input.setCpnCategory("B");
        }
        if (Strings.isBlank((String)input.getCpnVersion())) {
            input.setCpnVersion("1.0");
        }
        if (Strings.isBlank((String)input.getCpnState())) {
            input.setCpnState("1");
        }
        input.setCreateUser(input.getLoginUserId());
        input.setCreateTime(DateDataVO.getCurrentTime());
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(CpnConfMasterFormDTO input) {
        CpnConfMasterFormDTO history = (CpnConfMasterFormDTO)super.queryByPk((BaseInfo)input);
        String version = this.generateNextVersion(history.getCpnVersion());
        history.setCpnState("3");
        history.setUpdateUser(input.getLoginUserId());
        history.setUpdateTime(DateDataVO.getCurrentTime());
        history.setCpnId("");
        int output = this.insertSingle(history);
        input.setCpnVersion(version);
        input.setUpdateUser(input.getLoginUserId());
        input.setUpdateTime(DateDataVO.getCurrentTime());
        output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public CpnConfMasterFormDTO queryByPk(CpnConfMasterFormDTO input) {
        CpnConfMasterFormDTO output = (CpnConfMasterFormDTO)super.queryByPk((BaseInfo)input);
        return output;
    }

    public int deleteByPk(CpnConfMasterFormDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    public List<CpnConfMasterFormDTO> queryList(CpnConfMasterFormDTO input) {
        List output = super.queryListByPage((BaseInfo)input);
        return output;
    }

    public List<CpnConfMasterFormDTO> queryListNotPage(CpnConfMasterFormDTO input) {
        List output = super.queryList((BaseInfo)input);
        return output;
    }

    public int excelImport(String excelUploadType, CpnConfMasterFormDTO uploadParams, List<CpnConfMasterFormDTO> list) {
        List deleteList;
        if (StringUtils.equals((CharSequence)excelUploadType, (CharSequence)"insert") && CollectionUtils.isNotEmpty((Collection)(deleteList = ((CpnConfMasterFormRepository)this.getRepository()).queryList(this.beanCopy(uploadParams, CpnConfMasterFormDO.class))))) {
            deleteList.forEach(del -> ((CpnConfMasterFormRepository)this.getRepository()).deleteByPk(del));
        }
        return this.batchInsert(list);
    }

    public static String generateRandomString(int length, String allowedChars) {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(allowedChars.charAt(secureRandom.nextInt(allowedChars.length())));
        }
        return sb.toString();
    }

    public void exportToExcel(String cpnId, HttpServletResponse response) throws Exception {
        CpnConfMasterFormDTO dto = new CpnConfMasterFormDTO();
        dto.setCpnId(cpnId);
        dto = this.queryByPk(dto);
        if (Strings.isBlank((String)dto.getCpnId())) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u4ef6ID: " + cpnId);
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String fileName = URLEncoder.encode(dto.getCpnName() + "_\u7ec4\u4ef6\u914d\u7f6e\u4fe1\u606f.xlsx", "UTF-8");
        fileName = fileName.replaceAll("\\+", "%20");
        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(dto.getCpnName() + "\u914d\u7f6e\u8be6\u60c5");
        Row headerRow = sheet.createRow(0);
        String[] headers = new String[]{"\u7ec4\u4ef6\u6807\u8bc6", "\u7ec4\u4ef6\u7f16\u53f7", "\u7ec4\u4ef6\u540d\u79f0", "\u7ec4\u4ef6\u7c7b\u522b", "\u7ec4\u4ef6\u7c7b\u578b", "\u7ec4\u4ef6\u7248\u672c", "\u7ec4\u4ef6\u5b9e\u73b0\u7c7b", "\u7ec4\u4ef6\u914d\u7f6e\u5730\u5740", "\u6240\u5c5e\u4e1a\u52a1\u7ebf", "\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b", "\u6240\u5c5e\u4e1a\u52a1\u4ea7\u54c1", "\u6240\u5c5e\u80fd\u529b\u4e2d\u5fc3", "\u7ec4\u4ef6\u72b6\u6001", "\u521b\u5efa\u4eba", "\u66f4\u65b0\u65f6\u95f4", "\u521b\u5efa\u65f6\u95f4", "\u66f4\u65b0\u4eba", "\u7ec4\u4ef6\u63cf\u8ff0"};
        CellStyle headerStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(headerStyle);
            sheet.setColumnWidth(i, 5120);
        }
        Row dataRow = sheet.createRow(1);
        dataRow.createCell(0).setCellValue(dto.getCpnId());
        dataRow.createCell(1).setCellValue(dto.getCpnCode());
        dataRow.createCell(2).setCellValue(dto.getCpnName());
        dataRow.createCell(3).setCellValue(dto.getCpnCategory());
        dataRow.createCell(4).setCellValue(dto.getCpnType());
        dataRow.createCell(5).setCellValue(dto.getCpnVersion());
        dataRow.createCell(6).setCellValue(dto.getCpnClass());
        dataRow.createCell(7).setCellValue(dto.getCpnConfigUrl());
        dataRow.createCell(8).setCellValue(dto.getOwnerBizLine());
        dataRow.createCell(9).setCellValue(dto.getOwnerBizType());
        dataRow.createCell(10).setCellValue(dto.getOwnerBizProduct());
        dataRow.createCell(11).setCellValue(dto.getOwnerAbilityCenter());
        dataRow.createCell(12).setCellValue(dto.getCpnState());
        dataRow.createCell(13).setCellValue(dto.getCreateUser());
        dataRow.createCell(14).setCellValue(dto.getUpdateTime());
        dataRow.createCell(15).setCellValue(dto.getCreateTime());
        dataRow.createCell(16).setCellValue(dto.getUpdateUser());
        dataRow.createCell(17).setCellValue(dto.getCpnRemarks());
        workbook.write((OutputStream)response.getOutputStream());
        workbook.close();
        response.getOutputStream().flush();
    }

    public int openUpdateByPk(CpnConfMasterFormDTO input) {
        return super.updateByPk((BaseInfo)input);
    }

    public CpnConfMasterFormDTO openQueryByPk(CpnConfMasterFormDTO input) {
        return (CpnConfMasterFormDTO)super.queryByPk((BaseInfo)input);
    }

    private String generateNextVersion(String currentVersion) {
        try {
            BigDecimal version = new BigDecimal(currentVersion);
            BigDecimal nextVersion = version.add(new BigDecimal("0.1")).setScale(1, RoundingMode.HALF_UP);
            return nextVersion.toPlainString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "1.0";
        }
    }
}

