/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.cpn.application.operation;

import com.irdstudio.allinflow.cpn.acl.repository.CpnConfMasterProductFormRepository;
import com.irdstudio.allinflow.cpn.domain.entity.CpnConfMasterProductFormDO;
import com.irdstudio.allinflow.cpn.facade.operation.CpnConfMasterProductFormService;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfMasterProductFormDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.DateDataVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;

@Service(value="CpnConfMasterProductFormServiceImpl")
public class CpnConfMasterProductFormServiceImpl
extends BaseServiceImpl<CpnConfMasterProductFormDTO, CpnConfMasterProductFormDO, CpnConfMasterProductFormRepository>
implements CpnConfMasterProductFormService {
    public int insertSingle(CpnConfMasterProductFormDTO input) {
        if (Strings.isBlank((String)input.getCpnId())) {
            String randomString = CpnConfMasterProductFormServiceImpl.generateRandomString(10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
            input.setCpnId(randomString);
        }
        input.setCpnCategory("P");
        if (Strings.isBlank((String)input.getCpnVersion())) {
            input.setCpnVersion("1.0");
        }
        if (Strings.isBlank((String)input.getCpnState())) {
            input.setCpnState("1");
        }
        input.setCreateUser(input.getLoginUserId());
        input.setCreateTime(DateDataVO.getCurrentTime());
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(CpnConfMasterProductFormDTO input) {
        CpnConfMasterProductFormDTO history = (CpnConfMasterProductFormDTO)super.queryByPk((BaseInfo)input);
        String version = this.generateNextVersion(history.getCpnVersion());
        history.setCpnState("3");
        history.setUpdateUser(input.getLoginUserId());
        history.setUpdateTime(DateDataVO.getCurrentTime());
        history.setCpnId("");
        int output = this.insertSingle(history);
        input.setCpnVersion(version);
        input.setUpdateUser(input.getLoginUserId());
        input.setUpdateTime(DateDataVO.getCurrentTime());
        output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public CpnConfMasterProductFormDTO queryByPk(CpnConfMasterProductFormDTO input) {
        CpnConfMasterProductFormDTO output = (CpnConfMasterProductFormDTO)super.queryByPk((BaseInfo)input);
        return output;
    }

    public int deleteByPk(CpnConfMasterProductFormDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    public List<CpnConfMasterProductFormDTO> queryList(CpnConfMasterProductFormDTO input) {
        List output = super.queryList((BaseInfo)input);
        return output;
    }

    public int excelImport(String excelUploadType, CpnConfMasterProductFormDTO uploadParams, List<CpnConfMasterProductFormDTO> list) {
        List deleteList;
        if (StringUtils.equals((CharSequence)excelUploadType, (CharSequence)"insert") && CollectionUtils.isNotEmpty((Collection)(deleteList = ((CpnConfMasterProductFormRepository)this.getRepository()).queryList(this.beanCopy(uploadParams, CpnConfMasterProductFormDO.class))))) {
            deleteList.forEach(del -> ((CpnConfMasterProductFormRepository)this.getRepository()).deleteByPk(del));
        }
        return this.batchInsert(list);
    }

    public static String generateRandomString(int length, String allowedChars) {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(allowedChars.charAt(secureRandom.nextInt(allowedChars.length())));
        }
        return sb.toString();
    }

    private String generateNextVersion(String currentVersion) {
        try {
            BigDecimal version = new BigDecimal(currentVersion);
            BigDecimal nextVersion = version.add(new BigDecimal("0.1")).setScale(1, RoundingMode.HALF_UP);
            return nextVersion.toPlainString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "1.0";
        }
    }
}

