/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.console.application.service.impl;

import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.flow.WorkflowEngineInterface;
import com.irdstudio.allinflow.flow.console.acl.repository.NWfOrsingConfigRepository;
import com.irdstudio.allinflow.flow.console.domain.entity.NWfOrsingConfigDo;
import com.irdstudio.allinflow.flow.console.facade.NWfCommentService;
import com.irdstudio.allinflow.flow.console.facade.NWfInstanceService;
import com.irdstudio.allinflow.flow.console.facade.NWfNodeDoneService;
import com.irdstudio.allinflow.flow.console.facade.NWfNodeService;
import com.irdstudio.allinflow.flow.console.facade.NWfOrsingConfigService;
import com.irdstudio.allinflow.flow.console.facade.NWfUserDoneService;
import com.irdstudio.allinflow.flow.console.facade.NWfUserTodoService;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfNodeDoneDto;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfNodeDto;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfOrsingConfigDto;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfUserDoneDto;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfUserTodoDto;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultCommentDto;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultInstanceDto;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultMessageDto;
import com.irdstudio.allinflow.flow.console.facade.dto.WFCallbackDto;
import com.irdstudio.allinflow.flow.console.facade.dto.WFCommentDto;
import com.irdstudio.allinflow.flow.console.facade.dto.WFSubmitDto;
import com.irdstudio.allinflow.flow.console.facade.dto.WFTakebackDto;
import com.irdstudio.allinflow.flow.exception.WorkflowException;
import com.irdstudio.allinflow.flow.util.WorkFlowUtil;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="nWfOrsingConfigServiceImpl")
public class NWfOrsingConfigServiceImpl
extends BaseServiceImpl<NWfOrsingConfigDto, NWfOrsingConfigDo, NWfOrsingConfigRepository>
implements NWfOrsingConfigService {
    @Autowired
    private NWfNodeService nWNodeService;
    @Autowired
    private NWfNodeDoneService nWfNodeDoneService;
    @Autowired
    private NWfInstanceService nWfInstanceService;
    @Autowired
    private NWfCommentService nWfCommentService;
    @Autowired
    private NWfUserTodoService nWfUserTodoService;
    @Autowired
    private NWfUserDoneService nWfUserDoneService;
    @Autowired
    private SUserService sUserService;
    @Autowired
    private WorkflowEngineInterface workflowEngineInterface;

    public List<ResultMessageDto> commit(WFSubmitDto wFSubmitDto) throws WorkflowException {
        ArrayList<ResultMessageDto> re = new ArrayList<ResultMessageDto>();
        WFCommentDto comment = wFSubmitDto.getComment();
        String instanceId = comment.getInstanceId();
        String nodeId = comment.getNodeId();
        String userId = comment.getUserId();
        String commentSign = comment.getCommentSign();
        String orgId = wFSubmitDto.getOrgId();
        String end = wFSubmitDto.getEnd();
        logger.info("\u6d41\u7a0b\u63d0\u4ea4:[instanceId=" + instanceId + ";nodeId=" + nodeId + ";userId=" + userId + "]");
        ResultInstanceDto resultInstanceDto = this.nWfInstanceService.getInstanceInfo(instanceId, nodeId);
        resultInstanceDto.setCurrentUserId(userId);
        resultInstanceDto.setCurrentNodeId(nodeId);
        resultInstanceDto.setOrgId(orgId);
        if ("1".equals(commentSign)) {
            resultInstanceDto.setCurrentOpType("O-12");
        } else if ("2".equals(commentSign)) {
            resultInstanceDto.setCurrentOpType("O-1");
        } else if ("3".equals(commentSign)) {
            resultInstanceDto.setCurrentOpType("O-0");
        }
        NWfNodeDto nWfNodeDto = this.nWNodeService.selectInfo(instanceId, nodeId);
        if (WorkFlowUtil.isNullOrEmpty((String)comment.getCommentSign())) {
            comment.setCommentSign("O-12");
        }
        String opType = comment.getCommentSign();
        resultInstanceDto.setCurrentOpType(opType);
        ResultCommentDto resultCommentDto = (ResultCommentDto)this.beanCopy(comment, ResultCommentDto.class);
        resultInstanceDto.setComment(resultCommentDto);
        comment.setNodeName(nWfNodeDto.getNodeName());
        comment.setUserId(userId);
        ResultCommentDto resultComment = this.nWfCommentService.saveComment(comment);
        if ("1".equals(end)) {
            this.end(resultInstanceDto, nWfNodeDto, userId, orgId);
        } else {
            this.submitNextNodeMulti(resultInstanceDto, nWfNodeDto, re, userId, orgId);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultMessageDto tackBack(WFTakebackDto wFTakebackDto) throws WorkflowException {
        ResultMessageDto re = new ResultMessageDto();
        return null;
    }

    public ResultMessageDto callBack(WFCallbackDto callbackDto) throws WorkflowException {
        ResultMessageDto re = new ResultMessageDto();
        logger.info("\u6253\u56de\u5165\u53c2:" + callbackDto);
        WFCommentDto comment = callbackDto.getComment();
        String batchId = callbackDto.getBabatchId();
        String instanceId = comment.getInstanceId();
        String nodeId = comment.getNodeId();
        String orgId = callbackDto.getOrgId();
        String userId = comment.getUserId();
        String completeTime = CurrentDateUtil.getTodayDateEx2();
        String callbackNodeId = callbackDto.getCallbackNodeId();
        String callbackUserId = callbackDto.getCallbackUserId();
        ResultInstanceDto nWfInstanceDto = this.nWfInstanceService.getInstanceInfo(instanceId, nodeId);
        nWfInstanceDto.setCurrentUserId(userId);
        nWfInstanceDto.setCurrentOpType("0-1");
        List<String> userList = Arrays.asList(callbackUserId.split(";"));
        if (userList.isEmpty()) {
            re.setCode("1");
            re.setTip("\u672a\u83b7\u53d6\u5230\u6307\u5b9a\u7684\u6253\u56de\u7528\u6237,\u8bf7\u68c0\u67e5");
            return re;
        }
        this.nWfCommentService.saveComment(comment);
        this.userTodoBackup2Done(instanceId, nodeId, userId, completeTime);
        this.nodeBackup(instanceId, nodeId, completeTime, "O-1");
        this.deleteUserTodo(instanceId, nodeId);
        this.addUserTodo(instanceId, userId, callbackNodeId, userList, completeTime);
        this.addNodeTodo(batchId, orgId, "O-1", instanceId, nodeId, callbackNodeId, completeTime, userId);
        return null;
    }

    public List<NWfNodeDto> queryLastNWNode(WFCallbackDto callbackDto) {
        String callbackNodeId = callbackDto.getCallbackNodeId();
        this.nWNodeService.queryByNodeId(callbackNodeId);
        return null;
    }

    private void userTodoBackup2Done(String instanceId, String nodeId, String userId, String endTime) {
        NWfUserTodoDto userTodo = this.nWfUserTodoService.selectByCondition(instanceId, nodeId, userId);
        if (null != userTodo) {
            NWfUserDoneDto userDone = new NWfUserDoneDto();
            BeanUtils.copyProperties((Object)userTodo, (Object)userDone);
            userDone.setEndTime(endTime);
            this.nWfUserDoneService.insertSelective(userDone);
        }
    }

    private void instanceBackup(ResultInstanceDto instanceInfo, String endTime, String end) {
    }

    private void nodeBackup(String instanceId, String nodeId, String endTime, String opType) {
        NWfNodeDto currentNWNodeDto = this.nWNodeService.selectInfo(instanceId, nodeId);
        if (null != currentNWNodeDto) {
            int result;
            NWfNodeDoneDto nodeDone;
            NWfNodeDoneDto nWfNodeDoneDto = (NWfNodeDoneDto)this.beanCopy(currentNWNodeDto, NWfNodeDoneDto.class);
            nWfNodeDoneDto.setEndTime(endTime);
            opType = WorkFlowUtil.isNullOrEmpty((String)opType) ? currentNWNodeDto.getNodeState() : opType;
            nWfNodeDoneDto.setNodeState(opType);
            if ("0-1".equals(opType) && null != (nodeDone = this.nWfNodeDoneService.selectInfo(instanceId, nodeId)) && "0-1".equals(nodeDone.getNodeState())) {
                nWfNodeDoneDto.setNextNodeId(nodeDone.getNextNodeId());
                nWfNodeDoneDto.setNextUserId(nodeDone.getNextUserId());
            }
            if (0 == (result = this.nWfNodeDoneService.updateSelective(nWfNodeDoneDto))) {
                this.nWfNodeDoneService.insertSelective(nWfNodeDoneDto);
            }
        }
    }

    private void deleteUserTodo(String instanceId, String nodeId) {
        this.nWfUserTodoService.deleteUserTodo(instanceId, nodeId);
    }

    private void addUserTodo(String instanceId, String currentUserId, String nextNodeId, List<String> nextUserIds, String completeTime) {
        NWfUserTodoDto userTodo = new NWfUserTodoDto();
        userTodo.setInstanceId(instanceId);
        userTodo.setLastUserId(currentUserId);
        userTodo.setLastUserName(currentUserId);
        userTodo.setNodeId(nextNodeId);
        userTodo.setStartTime(completeTime);
        for (int i = 0; i < nextUserIds.size(); ++i) {
            userTodo.setUserId(nextUserIds.get(0));
            userTodo.setUserName(this.getUserName(nextUserIds.get(0)));
            NWfUserTodoDto userTodoT = this.nWfUserTodoService.selectByCondition(instanceId, nextNodeId, nextUserIds.get(0));
            if (null == userTodoT) {
                this.nWfUserTodoService.insert((Object)userTodo);
                continue;
            }
            this.nWfUserTodoService.updateByPrimaryKeySelective(userTodo);
        }
    }

    private void addNodeTodo(String babatchId, String orgId, String nodeState, String instanceId, String currentNodeId, String nextNodeId, String completeTime, String currentUserId) {
        NWfNodeDto nodeInfo = new NWfNodeDto();
        nodeInfo.setBatchId(babatchId);
        nodeInfo.setInstanceId(instanceId);
        nodeInfo.setNodeId(nextNodeId);
    }

    private void submitNextNodeMulti(ResultInstanceDto instanceInfo, NWfNodeDto nodeInfoDtos, List<ResultMessageDto> msg, String currentUserId, String orgId) throws WorkflowException {
        ArrayList toNodeIds = new ArrayList();
        String completeTime = CurrentDateUtil.getTodayDateEx2();
        String endTime = CurrentDateUtil.getTodayDateEx2();
        String instanceId = instanceInfo.getInstanceId();
        String nodeId = instanceInfo.getCurrentNodeId();
        String opType = WorkFlowUtil.isNullOrEmpty((String)instanceInfo.getCurrentOpType()) ? "O-12" : instanceInfo.getCurrentOpType();
        String nodeState = "O-12";
        String nodeName = "\u7ed3\u675f";
        instanceInfo.setCurrentOpType("O-14");
        this.instanceBackup(instanceInfo, endTime, "E");
        this.userTodoBackup2Done(instanceId, nodeId, currentUserId, completeTime);
        this.nodeBackup(instanceId, nodeId, completeTime, opType);
        this.nWfUserTodoService.deleteUserTodo(instanceId, nodeId);
        this.nWNodeService.deleteNodeInfo(instanceId, nodeId);
    }

    private ResultMessageDto end(ResultInstanceDto resultInstanceDto, NWfNodeDto nWfNodeDto, String userId, String orgId) {
        String nodeState = "O-12";
        String nodeName = "\u7ed3\u675f";
        String flowState = "E";
        String endTime = CurrentDateUtil.getTodayDateEx2();
        String batchId = resultInstanceDto.getBatchId();
        String instanceId = resultInstanceDto.getInstanceId();
        String nodeId = resultInstanceDto.getNodeId();
        this.instanceBackup(resultInstanceDto, endTime, flowState);
        this.nodeBackup(instanceId, nodeId, endTime, nodeState);
        this.transNodeDone2End(batchId);
        this.deleteAllNode(instanceId);
        this.userTodoBackup2Done(instanceId, nodeId, userId, endTime);
        this.transUSerDone2End(batchId);
        this.nWfUserTodoService.deleteUserTodo(instanceId, nodeId);
        this.workflowEngineInterface.afterSubmit(resultInstanceDto);
        ResultMessageDto result = new ResultMessageDto();
        result.setNodeName(nodeName);
        result.setTip("\u6b63\u5e38\u7ed3\u675f\uff01");
        result.setCode("E");
        return result;
    }

    public int transNodeDone2End(String batchId) {
        List nWfNodeDoneDtoList = this.nWfNodeDoneService.selectList(batchId);
        if (!nWfNodeDoneDtoList.isEmpty()) {
            this.nWfNodeDoneService.insertNodeHisBatch(nWfNodeDoneDtoList);
        }
        return this.nWfNodeDoneService.deleteAllNodeDone(batchId);
    }

    public int deleteAllNode(String batchId) {
        return this.nWNodeService.deleteAllNode(batchId);
    }

    public int transUSerDone2End(String batchId) {
        List userDones = this.nWfUserDoneService.selectList(batchId);
        if (!userDones.isEmpty()) {
            this.nWfUserDoneService.insertUserHisBatch(userDones);
        }
        return this.nWfUserDoneService.deleteAllUserDone(batchId);
    }

    public String getUserName(String userId) {
        SUserDTO userParam = new SUserDTO();
        userParam.setActorno(userId);
        SUserDTO inchargeUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
        return inchargeUser.getActorname();
    }
}

