/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.quality.console.application.service.check.scheme.executor;

import com.irdstudio.allinflow.console.types.YesOrNO;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoService;
import com.irdstudio.allinflow.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinflow.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinflow.quality.console.application.service.check.conn.iml.ConnPoolForDruid;
import com.irdstudio.allinflow.quality.console.application.service.check.scheme.impl.RegexRule;
import com.irdstudio.allinflow.quality.console.application.service.check.scheme.impl.SqlRule;
import com.irdstudio.allinflow.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckRuleService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckSchemeDTO;
import com.irdstudio.allinflow.quality.console.types.CheckScope;
import com.irdstudio.allinflow.quality.console.types.RuleResult;
import com.irdstudio.allinflow.quality.console.types.RuleScheme;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCheckSchemeExecutor
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(SCheckSchemeExecutor.class);
    public static final ConcurrentMap<String, String> taskDebounce = new ConcurrentHashMap<String, String>();
    private SCheckSchemeDTO scheme;
    private String id;
    private String serialNo;
    private IConnPool connTool;
    private final AtomicBoolean schemeCheckFlag = new AtomicBoolean(true);

    public SCheckSchemeExecutor(SCheckSchemeDTO scheme, String serialNo, String id) {
        this.scheme = scheme;
        this.serialNo = serialNo;
        this.id = id;
        this.connTool = new ConnPoolForDruid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ExecuteRtnInfo call() throws Exception {
        block24: {
            conn = null;
            try {
                conn = this.connTool.getConnection();
                checkScope = CheckScope.getByCode((String)this.scheme.getCheckScope());
                if (checkScope == null) {
                    checkScope = CheckScope.Subs;
                }
                exeParam = this.getExecuteParam(this.id, checkScope, conn);
                sCheckRuleService = (SCheckRuleService)SpringContextUtils.getBean(SCheckRuleService.class);
                sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
                ruleParam = new SCheckRuleDTO();
                ruleParam.setSchemeNo(this.scheme.getSchemeNo());
                ruleParam.setSize(Integer.valueOf(0x7FFFFFFF));
                ruleList = sCheckRuleService.queryList((Object)ruleParam);
                if (!CollectionUtils.isNotEmpty((Collection)ruleList)) break block24;
                ruleLen = ruleList.size();
                now = CurrentDateUtil.getTodayDateEx2();
                for (i = 0; i < ruleLen; ++i) {
                    rule = (SCheckRuleDTO)ruleList.get(i);
                    ruleResult = new SCheckResultDTO();
                    ruleResult.setSerialNo(this.serialNo);
                    ruleResult.setSchemeNo(rule.getSchemeNo());
                    ruleResult.setRuleId(rule.getRuleId());
                    ruleResult.setRuleName(rule.getRuleName());
                    ruleResult.setRuleResult(RuleResult.Wait.getCode());
                    ruleResult.setCreateUser(this.scheme.getLoginUserId());
                    ruleResult.setCreateTime(now);
                    ruleResult.setLastModifyUser(this.scheme.getLoginUserId());
                    ruleResult.setLastModifyTime(now);
                    ruleResult.setRefId(this.id);
                    sCheckResultService.insert((Object)ruleResult);
                }
                for (i = 0; i < ruleLen; ++i) {
                    rule = (SCheckRuleDTO)ruleList.get(i);
                    rule.setLoginUserId(this.scheme.getLoginUserId());
                    ruleScope = CheckScope.getByCode((String)rule.getCheckScope());
                    if (ruleScope == null) {
                        ruleScope = checkScope;
                    }
                    ruleExeParam = null;
                    if (ruleScope != checkScope) {
                        conn = this.connTool.getConnection(conn);
                        ruleExeParam = this.getExecuteParam(this.id, ruleScope, conn);
                    } else {
                        ruleExeParam = exeParam;
                    }
                    ruleExeParam.put("ruleScope", ruleScope);
                    ruleScheme = RuleScheme.getByCode((String)rule.getRuleScheme());
                    if (ruleScheme == null) continue;
                    ruleResult = new SCheckResultDTO();
                    ruleResult.setSerialNo(this.serialNo);
                    ruleResult.setRuleId(rule.getRuleId());
                    ruleResult.setRuleResult(RuleResult.Running.getCode());
                    ruleResult.setLastModifyUser(this.scheme.getLoginUserId());
                    ruleResult.setLastModifyTime(now);
                    sCheckResultService.updateByPk((Object)ruleResult);
                    exeResult = false;
                    try {
                        switch (1.$SwitchMap$com$irdstudio$allinflow$quality$console$types$RuleScheme[ruleScheme.ordinal()]) {
                            case 1: {
                                sqlRuleExe = new SqlRule();
                                exeResult = sqlRuleExe.check(this.serialNo, rule, ruleExeParam, this.connTool);
                                ** break;
lbl64:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                ruleCls = Class.forName(rule.getRuleContent());
                                jRuleExe = (CheckJavaRule)ruleCls.newInstance();
                                exeResult = jRuleExe.check(this.serialNo, rule, ruleExeParam, this.connTool);
                                ** break;
lbl70:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                regRuleExe = new RegexRule();
                                exeResult = regRuleExe.check(this.serialNo, rule, ruleExeParam, this.connTool);
                                ** break;
lbl75:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl77:
                            // 1 sources

                            break;
                        }
                    }
                    catch (Exception e) {
                        exeResult = false;
                        SCheckSchemeExecutor.logger.error(String.format(" %s\u89c4\u5219\u6267\u884c\u5f02\u5e38 %s", new Object[]{rule.getRuleId(), e.getMessage()}), (Throwable)e);
                        ruleResult.setRuleResult(RuleResult.Error.getCode());
                        sCheckResultService.updateByPk((Object)ruleResult);
                    }
                    finally {
                        sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
                        updateNum = new SCheckResultDTO();
                        failParam = new SCheckResultDtlDTO();
                        failParam.setSerialNo(ruleResult.getSerialNo());
                        failParam.setRuleId(ruleResult.getRuleId());
                        failNum = sCheckResultDtlService.queryFailNum(failParam);
                        updateNum.setSerialNo(ruleResult.getSerialNo());
                        updateNum.setRuleId(ruleResult.getRuleId());
                        updateNum.setFailNum(failNum);
                        sCheckResultService.updateByPk((Object)updateNum);
                    }
                    if (!exeResult) {
                        this.schemeCheckFlag.set(exeResult);
                    }
                    if (!exeResult && StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)rule.getRuleFailDeal())) break;
                }
            }
            catch (Exception e) {
                try {
                    SCheckSchemeExecutor.logger.error("\u6821\u9a8c\u65b9\u6848 {} \u5728id\u4e3a {} \u6267\u884c\u51fa\u73b0\u5f02\u5e38 {}", new Object[]{this.scheme.getSchemeNo(), this.id, e.getMessage(), e});
                }
                catch (Throwable var26_28) {
                    SCheckSchemeExecutor.taskDebounce.remove(String.format("%s-%s", new Object[]{this.scheme.getSchemeNo(), this.id}));
                    SCheckSchemeExecutor.taskDebounce.put(String.format("%s-%s-result", new Object[]{this.scheme.getSchemeNo(), this.id}), "done");
                    if (conn != null) {
                        conn.close();
                    }
                    this.updateValidateInfo();
                    throw var26_28;
                }
                SCheckSchemeExecutor.taskDebounce.remove(String.format("%s-%s", new Object[]{this.scheme.getSchemeNo(), this.id}));
                SCheckSchemeExecutor.taskDebounce.put(String.format("%s-%s-result", new Object[]{this.scheme.getSchemeNo(), this.id}), "done");
                if (conn != null) {
                    conn.close();
                }
                this.updateValidateInfo();
            }
        }
        SCheckSchemeExecutor.taskDebounce.remove(String.format("%s-%s", new Object[]{this.scheme.getSchemeNo(), this.id}));
        SCheckSchemeExecutor.taskDebounce.put(String.format("%s-%s-result", new Object[]{this.scheme.getSchemeNo(), this.id}), "done");
        if (conn != null) {
            conn.close();
        }
        this.updateValidateInfo();
        return null;
    }

    private void updateValidateInfo() {
    }

    private Map<String, Object> getExecuteParam(String id, CheckScope checkScope, Connection conn) throws Exception {
        SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
        if (checkScope == CheckScope.Subs) {
            String subsId = id;
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            subsInfo.setSubsId(subsId);
            subsInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)subsInfo);
            Map param = BeanUtility.bean2MapCleanNull((Object)subsInfo);
            return param;
        }
        return null;
    }
}

