/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.irdstudio.allinflow.console.acl.repository.PaasSubsUserRepository;
import com.irdstudio.allinflow.console.acl.repository.SSubsInfoPortalRepository;
import com.irdstudio.allinflow.console.domain.entity.PaasSubsUserDO;
import com.irdstudio.allinflow.design.console.acl.repository.PaasSubsGroupRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasSubsGroupDO;
import com.irdstudio.allinflow.design.console.domain.entity.SSubsInfoDO;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinflow.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinflow.design.console.types.SubsRole;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRolesubsService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRoleuserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserProfileService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SRolesubsDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.framework.beans.core.audit.AuditOperate;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service(value="sSubsInfoPortalServiceImpl")
public class SSubsInfoPortalServiceImpl
extends BaseServiceImpl<SSubsInfoDTO, SSubsInfoDO, SSubsInfoPortalRepository>
implements SSubsInfoPortalService {
    @Autowired
    private PaasSubsUserRepository paasSubsUserRepository;
    @Value(value="${tdp.project.path:}")
    private String projectTmpDirPath;
    @Value(value="${cas.client-host-url:}")
    private String clientHostUrl;
    private HttpClient httpClient = HttpClients.createDefault();
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private PaasSubsGroupRepository paasSubsGroupRepository;
    @Autowired
    private SUserService sUserService;
    @Autowired
    private SUserProfileService sUserProfileService;
    @Autowired
    private SRolesubsService sRolesubsService;
    @Autowired
    private SRoleuserService sRoleuserService;
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    @AuditOperate(action=AuditOperate.Action.Add, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].subsId} ${args[0].subsName}")
    public int insert(SSubsInfoDTO inSSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSSubsInfoDTO.toString());
        int num = 0;
        try {
            SSubsInfoDO sSubsInfo = new SSubsInfoDO();
            this.beanCopy(inSSubsInfoDTO, sSubsInfo);
            num = ((SSubsInfoPortalRepository)this.getRepository()).insert((Object)sSubsInfo);
            this.saveSubGroupRef(inSSubsInfoDTO);
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getRolenos())) {
                this.paasSubsUserRepository.updateSubsId(inSSubsInfoDTO.getSubsId(), inSSubsInfoDTO.getRolenos());
            }
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getChargeMan())) {
                SUserDTO userParam = new SUserDTO();
                userParam.setActorno(inSSubsInfoDTO.getChargeMan());
                SUserDTO inchargeUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                if (inchargeUser != null) {
                    PaasSubsUserDO managerMem = new PaasSubsUserDO();
                    managerMem.setUserId(inchargeUser.getActorno());
                    managerMem.setUserName(inchargeUser.getActorname());
                    managerMem.setPhone(inchargeUser.getTelnum());
                    managerMem.setEmail(inchargeUser.getUsermail());
                    managerMem.setUserRole(SubsRole.Admin.getCode());
                    managerMem.setSubsId(inSSubsInfoDTO.getSubsId());
                    managerMem.setCreateUser(inSSubsInfoDTO.getLoginUserId());
                    managerMem.setLastModifyUser(inSSubsInfoDTO.getLoginUserId());
                    String now = CurrentDateUtil.getTodayDateEx2();
                    managerMem.setCreateTime(now);
                    managerMem.setLastModifyTime(now);
                    this.paasSubsUserRepository.insert((Object)managerMem);
                }
            }
        }
        catch (DataAccessException dataAccessException) {
            throw new RuntimeException("\u8be5\u5e94\u7528\u7cfb\u7edf\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728", dataAccessException);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e382", e);
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @AuditOperate(action=AuditOperate.Action.Update, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}")
    public int updateByPk(SSubsInfoDTO inSSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSSubsInfoDTO.toString());
        int num = 0;
        SSubsInfoDTO oldData = (SSubsInfoDTO)this.queryByPk((BaseInfo)inSSubsInfoDTO);
        inSSubsInfoDTO.setOldData((Object)oldData);
        SSubsInfoDO sSubsInfo = new SSubsInfoDO();
        this.beanCopy(inSSubsInfoDTO, sSubsInfo);
        num = ((SSubsInfoPortalRepository)this.getRepository()).updateByPk((Object)sSubsInfo);
        this.saveSubGroupRef(inSSubsInfoDTO);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inSSubsInfoDTO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].subsId} ${args[0].subsName}")
    public int deleteByPk(SSubsInfoDTO paramDTO) {
        String userId = paramDTO.getLoginUserId();
        String userName = paramDTO.getLoginUserName();
        String subsId = paramDTO.getSubsId();
        SRolesubsDTO sRolesubsDTO = (SRolesubsDTO)this.beanCopy(paramDTO, SRolesubsDTO.class, true);
        this.sRolesubsService.deleteByCond(sRolesubsDTO);
        PaasSubsGroupDO deleteGroupDO = (PaasSubsGroupDO)this.beanCopy(paramDTO, PaasSubsGroupDO.class, true);
        this.paasSubsGroupRepository.deleteByCond(deleteGroupDO);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public Integer querySSubsInfoMaxOrder() {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        Integer result = null;
        try {
            result = ((SSubsInfoPortalRepository)this.getRepository()).querySSubsInfoMaxOrder();
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public String querySSubsInfoMaxOrderWithPrefix(String solutionType) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        String result = null;
        try {
            result = ((SSubsInfoPortalRepository)this.getRepository()).querySSubsInfoMaxOrderWithPrefix(solutionType);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public boolean updateGitRoleWithSubs(String subsCode) {
        try {
            logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + subsCode.toString());
            SSubsInfoDO sSubsInfo = new SSubsInfoDO();
            sSubsInfo.setSubsCode(subsCode);
            sSubsInfo = (SSubsInfoDO)((SSubsInfoPortalRepository)this.getRepository()).queryByPk((Object)sSubsInfo);
        }
        catch (DataAccessException dataAccessException) {
            logger.error("\u8be5\u5e94\u7528\u7cfb\u7edf\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728!", (Throwable)dataAccessException);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e382!", (Throwable)e);
        }
        return true;
    }

    public int saveSubsInfoImportList(List<SSubsInfoDTO> list) {
        int num = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (SSubsInfoDTO subs : list) {
                SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
                this.beanCopy(subs, sSubsInfoDO);
                SSubsInfoDO checkObj = (SSubsInfoDO)((SSubsInfoPortalRepository)this.getRepository()).queryByPk((Object)sSubsInfoDO);
                if (checkObj != null) {
                    this.beanCopy(subs, checkObj);
                    num += ((SSubsInfoPortalRepository)this.getRepository()).updateByPk((Object)checkObj);
                    continue;
                }
                num += ((SSubsInfoPortalRepository)this.getRepository()).insert((Object)sSubsInfoDO);
            }
        }
        return num;
    }

    public List<Map<String, Object>> queryDdspaasSummaryByPage(SSubsInfoDTO sSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
            this.beanCopy(sSubsInfoDTO, sSubsInfoDO);
            list = ((SSubsInfoPortalRepository)this.getRepository()).queryDdspaasSummaryByPage(sSubsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
            sSubsInfoDTO.setTotal(sSubsInfoDO.getTotal());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<Map<String, Object>> querySubsSummary(SSubsInfoDTO sSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
            this.beanCopy(sSubsInfoDTO, sSubsInfoDO);
            list = ((SSubsInfoPortalRepository)this.getRepository()).querySubsSummary(sSubsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public boolean gitlabHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, List<String> userIds, String desc) throws Exception {
        boolean result;
        block46: {
            result = true;
            try {
                String group = subsGitGroup;
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUserDTO userParam = new SUserDTO();
                    userParam.setActorno(currentUserId);
                    SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(sUser.getActorno());
                    if (SSubsInfoPortalServiceImpl.validate(sUser.getUsermail())) {
                        gitUserInfo.setEmail(sUser.getUsermail());
                    } else {
                        gitUserInfo.setEmail(String.format("%s@%s.com", currentUserId, "irdstudio"));
                    }
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                if (CollectionUtils.isNotEmpty(userIds)) {
                    for (String userId : userIds) {
                        User tmpUserInfo = null;
                        try {
                            tmpUserInfo = gitLabApi.getUserApi().getUser(userId);
                        }
                        catch (GitLabApiException gitLabApiException) {
                            // empty catch block
                        }
                        if (tmpUserInfo == null) {
                            SUserDTO userParam = new SUserDTO();
                            userParam.setActorno(userId);
                            SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                            tmpUserInfo = new User();
                            tmpUserInfo.setName(userId);
                            tmpUserInfo.setUsername(sUser.getActorno());
                            if (SSubsInfoPortalServiceImpl.validate(sUser.getUsermail())) {
                                tmpUserInfo.setEmail(sUser.getUsermail());
                            } else {
                                tmpUserInfo.setEmail(String.format("%s@%s.com", sUser.getActorno(), "irdstudio"));
                            }
                            try {
                                tmpUserInfo = gitLabApi.getUserApi().createUser(tmpUserInfo, (CharSequence)(userId + userId), false);
                            }
                            catch (GitLabApiException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (tmpUserInfo.getId() == null) continue;
                        try {
                            groupApi.addMember((Object)group, tmpUserInfo.getId(), AccessLevel.MAINTAINER);
                        }
                        catch (GitLabApiException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                String projectName = subsGitGroup + "-wiki";
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException e) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException sUser) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    } else {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                        result = false;
                    }
                } else {
                    logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u5df2\u5b58\u5728");
                    result = true;
                }
                if (!CollectionUtils.isNotEmpty(userIds)) break block46;
                for (String userId : userIds) {
                    User tmpUserInfo = null;
                    try {
                        tmpUserInfo = gitLabApi.getUserApi().getUser(userId);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    try {
                        prjApi.addMember((Object)prj, tmpUserInfo.getId(), AccessLevel.MAINTAINER);
                    }
                    catch (GitLabApiException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public boolean gitlabRepoHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, List<String> userIds, String desc) throws Exception {
        boolean result;
        block28: {
            result = true;
            try {
                logger.info("\u5f53\u524d\u7528\u6237\uff1a " + currentUserId);
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                String projectName = subsGitGroup.substring(subsGitGroup.lastIndexOf("/") + 1);
                String group = StringUtils.replaceOnce((String)subsGitGroup, (String)projectName, (String)"");
                projectName = StringUtils.replaceOnce((String)projectName, (String)".git", (String)"");
                group = group.substring(0, group.lastIndexOf("/"));
                group = group.substring(group.lastIndexOf("/") + 1);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUserDTO userParam = new SUserDTO();
                    userParam.setActorno(currentUserId);
                    SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(sUser.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block28;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block28;
                    }
                    logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block28;
                }
                logger.info("\u4ed3\u5e93\u5df2\u5b58\u5728");
                try {
                    Member member = prjApi.addMember((Object)prj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                result = true;
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public Integer countSubsInfoTbNum(String subsId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + subsId);
        Integer count = ((SSubsInfoPortalRepository)this.getRepository()).countSubsInfoTbNum(subsId);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + count);
        return count;
    }

    public static boolean validate(String emailStr) {
        if (emailStr == null) {
            return false;
        }
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public List<Map<String, Object>> querySummary(Map<String, Object> param) {
        return ((SSubsInfoPortalRepository)this.getRepository()).querySummary(param);
    }

    public List<Map<String, Object>> querySubsInfoSummaryByPage(SSubsInfoDTO param) {
        SSubsInfoDO doParam = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List outputVO = ((SSubsInfoPortalRepository)this.getRepository()).querySubsInfoSummaryByPage(doParam);
        param.setTotal(doParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySummaryBySolutionTypeGroup(SSubsInfoDTO param) {
        SSubsInfoDO doParam = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List outputVO = ((SSubsInfoPortalRepository)this.getRepository()).querySummaryBySolutionTypeGroup(doParam);
        param.setTotal(doParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySubsCbaSummary(Map<String, Object> params) {
        return ((SSubsInfoPortalRepository)this.getRepository()).querySubsCbaSummary(params);
    }

    public List<SSubsInfoDTO> queryWithEnvListByPage(SSubsInfoDTO param) {
        SSubsInfoDO paramDO = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List poList = ((SSubsInfoPortalRepository)this.getRepository()).queryWithEnvListByPage(paramDO);
        return this.beansCopy(poList, SSubsInfoDTO.class);
    }

    private void saveSubGroupRef(SSubsInfoDTO subsInfo) {
        String[] groups;
        if (StringUtils.isNotBlank((CharSequence)subsInfo.getSubsGroupId()) && (groups = StringUtils.split((String)subsInfo.getSubsGroupId())) != null) {
            ArrayList<PaasSubsGroupDO> groupMapList = new ArrayList<PaasSubsGroupDO>(groups.length);
            for (String groupId : groups) {
                PaasSubsGroupDO groupDO = new PaasSubsGroupDO();
                groupDO.setSubsId(subsInfo.getSubsId());
                groupDO.setGroupId(groupId);
                groupMapList.add(groupDO);
            }
            if (CollectionUtils.isNotEmpty(groupMapList)) {
                this.paasSubsGroupRepository.batchInsert(groupMapList);
            }
        }
    }
}

