/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.irdstudio.allinflow.flow.exception.WorkflowException;
import com.irdstudio.framework.beans.core.util.TimeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowUtil {
    private static ObjectMapper jsonObj = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowUtil.class);

    private WorkFlowUtil() {
    }

    public static boolean isNullOrEmpty(String param) {
        return null == param || "".equals(param);
    }

    public static String mapToStr(Map<String, Object> param) throws WorkflowException {
        try {
            if (null != param && !param.isEmpty()) {
                return jsonObj.writeValueAsString(param);
            }
        }
        catch (Exception e) {
            throw new WorkflowException("\u6d41\u7a0b\u516c\u5171\u53c2\u6570\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u5f02\u5e38:{}");
        }
        return null;
    }

    public static <T> T strToObj(String content, Class<T> clazz) {
        try {
            if (!WorkFlowUtil.isNullOrEmpty(content)) {
                return (T)jsonObj.readValue(content, clazz);
            }
        }
        catch (Exception e) {
            throw new WorkflowException("\u5b57\u7b26\u4e32\u53c2\u6570\u683c\u5f0f\u5316\u6210\u5217\u8868\u5f02\u5e38:{}");
        }
        return null;
    }

    public static String generateNextVersion(String currentVersion) {
        try {
            BigDecimal version = new BigDecimal(currentVersion);
            BigDecimal nextVersion = version.add(new BigDecimal("0.1")).setScale(1, RoundingMode.HALF_UP);
            return nextVersion.toPlainString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "1.0";
        }
    }

    public static String generatePrimaryKey() {
        String timestamp = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmss");
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int index = random.nextInt(characters.length());
            sb.append(characters.charAt(index));
        }
        return timestamp + sb.toString();
    }

    public static String concatenateKeyAndNode(String primaryKey, String nodeString) {
        if (nodeString == null || !nodeString.contains("_")) {
            return primaryKey + nodeString;
        }
        int underscoreIndex = nodeString.indexOf(95);
        String suffix = nodeString.substring(underscoreIndex);
        return primaryKey + suffix;
    }
}

