/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.impl;

import com.irdstudio.allinflow.flow.WorkflowBizCallBackService;
import com.irdstudio.allinflow.flow.WorkflowRqsParamInterface;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultCommentDto;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultInstanceDto;
import com.irdstudio.allinflow.flow.console.facade.dto.UrlBaseDto;
import com.irdstudio.allinflow.flow.domain.BizCallBackRqsVo;
import com.irdstudio.allinflow.flow.domain.BizCallBackRspVo;
import com.irdstudio.allinflow.flow.exception.WorkflowException;
import com.irdstudio.allinflow.flow.util.ObjectMapperUtils;
import com.irdstudio.allinflow.flow.util.RestTemplateUtil;
import com.irdstudio.allinflow.flow.util.RetryTemplateUtil;
import com.irdstudio.allinflow.flow.util.WorkFlowUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="workflowBizCallBackServiceImpl")
public class WorkflowBizCallBackServiceImpl
implements WorkflowBizCallBackService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowBizCallBackServiceImpl.class);
    @Autowired
    private WorkflowRqsParamInterface rqsParamService;
    @Autowired
    private RetryTemplateUtil retryTemplateUtil;
    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Override
    public boolean callback(ResultInstanceDto instanceInfo, UrlBaseDto urlBaseDto) {
        String ext;
        if (Objects.isNull(urlBaseDto) || WorkFlowUtil.isNullOrEmpty(urlBaseDto.getUrl())) {
            throw new WorkflowException("\u8282\u70b9\u672a\u8bbe\u7f6e\u56de\u8c03\u63a5\u53e3\uff0c\u65e0\u6cd5\u56de\u8c03\uff01");
        }
        String url = urlBaseDto.getUrl();
        log.info("\u5f00\u59cb\u6267\u884c\u63a5\u53e3\u8c03\u7528\u7b2c\u4e09\u65b9\u4ea4\u6613\u7cfb\u7edf\u300b\u300b\u300bURL:{}", (Object)url);
        if (log.isDebugEnabled()) {
            log.debug("\u5b9e\u4f8b\u4fe1\u606f{}", (Object)ObjectMapperUtils.toJson(instanceInfo));
        }
        String nodeId = instanceInfo.getCurrentNodeId();
        BizCallBackRqsVo rqsVo = new BizCallBackRqsVo();
        try {
            BeanUtils.copyProperties((Object)instanceInfo, (Object)rqsVo);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        rqsVo.setNodeId(nodeId);
        rqsVo.setUserId(instanceInfo.getCurrentUserId());
        rqsVo.setOrgId(instanceInfo.getCurrentOrgId());
        Map<String, Object> param = instanceInfo.getParam();
        log.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u4ea4\u6613\u7cfb\u7edf\uff0c\u8bf7\u6c42\u62a5\u6587\u4f53\u300b\u300b\u300b{}", (Object)rqsVo);
        ResultCommentDto comment = instanceInfo.getComment();
        if (!Objects.nonNull(comment) || WorkFlowUtil.isNullOrEmpty(ext = comment.getExt()) || !"\u65e0".equals(ext)) {
            // empty if block
        }
        rqsVo.setBizParam(WorkFlowUtil.mapToStr(param));
        return this.doPostRequest(url, rqsVo);
    }

    private boolean doPostRequest(String url, BizCallBackRqsVo rqsVo) {
        RestTemplate restTemplate = this.restTemplateUtil.getRestTemplate();
        RetryTemplate retryTemplate = this.retryTemplateUtil.getRetryTemplate();
        try {
            HttpEntity<Object> entity = this.rqsParamService.buildRequestEntity(rqsVo);
            ResponseEntity responseEntity = (ResponseEntity)retryTemplate.execute(retryContext -> {
                ResponseEntity postForEntity = restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
                HttpStatus statusCode = postForEntity.getStatusCode();
                if (!HttpStatus.OK.equals((Object)statusCode)) {
                    log.error("\u63a5\u53e3\uff1a\u3010{}\u3011\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a\u3010{}\u3011", (Object)url, (Object)statusCode.value());
                    throw new WorkflowException("\u63a5\u53e3\uff1a\u3010{0}\u3011\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a\u3010{1}\u3011");
                }
                log.info("\u63a5\u53e3\uff1a\u3010{}\u3011\u8bf7\u6c42\u6210\u529f\uff0cresponse\uff1a\u3010{}\u3011", (Object)url, (Object)postForEntity);
                return postForEntity;
            });
            BizCallBackRspVo response = this.rqsParamService.getBodyFromResponse((ResponseEntity<String>)responseEntity);
            if (Objects.isNull(response)) {
                throw new WorkflowException("\u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u4f53\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new WorkflowException("\u56de\u8c03\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a\u3010{0}\u3011");
        }
        return true;
    }
}

