/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.cpn.web.operation;

import com.irdstudio.allinflow.cpn.facade.operation.CpnConfNodeService;
import com.irdstudio.allinflow.cpn.facade.operation.CpnConfParamService;
import com.irdstudio.allinflow.cpn.facade.operation.CpnInstParamService;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfNodeDTO;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfParamDTO;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnInstParamDTO;
import com.irdstudio.allinflow.cpn.facade.operation.dto.FlowConfParamDTO;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfNodeService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfNodeDTO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class CpnInstParamController
extends BaseController<CpnInstParamDTO, CpnInstParamService> {
    @Autowired
    private CpnInstParamService cpnInstParamService;
    @Autowired
    private CpnConfParamService cpnConfParamService;
    @Autowired
    private FlowConfNodeService flowConfNodeService;
    @Autowired
    private CpnConfNodeService cpnConfNodeService;

    @RequestMapping(value={"/api/CpnTechParam/queryFlowTree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<FlowConfParamDTO>> queryFlowTree(@RequestParam(value="batchId") String batchId, @RequestParam(value="batchName") String batchName) {
        ArrayList<FlowConfParamDTO> taskTree = new ArrayList<FlowConfParamDTO>();
        FlowConfParamDTO root = new FlowConfParamDTO(batchId, batchName, batchName);
        taskTree.add(root);
        List list = this.flowConfNodeService.queryByBatchId(batchId);
        for (FlowConfNodeDTO flowConfNodeDTO : list) {
            FlowConfParamDTO flowConfParamDTO = new FlowConfParamDTO(batchId, flowConfNodeDTO.getTaskId(), flowConfNodeDTO.getTaskName(), flowConfNodeDTO.getPluginId(), flowConfNodeDTO.getTaskName());
            List cpnconfNodeList = this.cpnConfNodeService.queryByBizCpnId(flowConfNodeDTO.getPluginId());
            for (CpnConfNodeDTO cpnConfNodeDTO : cpnconfNodeList) {
                FlowConfParamDTO cpnParamDTO = new FlowConfParamDTO(batchId, cpnConfNodeDTO.getNodeId(), cpnConfNodeDTO.getNodeName(), cpnConfNodeDTO.getBaseCpnId(), cpnConfNodeDTO.getNodeName());
                flowConfParamDTO.getChildren().add(cpnParamDTO);
            }
            root.getChildren().add(flowConfParamDTO);
        }
        return this.getResponseData(taskTree);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryProdTree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<FlowConfParamDTO>> queryProdTree(@RequestParam(value="flowId") String flowId, @RequestParam(value="nodeId") String nodeId, @RequestParam(value="cpnId") String cpnId) {
        ArrayList<FlowConfParamDTO> taskTree = new ArrayList<FlowConfParamDTO>();
        FlowConfNodeDTO flowConfNodeDTO = this.flowConfNodeService.queryProdTree(flowId, nodeId, cpnId);
        if (flowConfNodeDTO != null) {
            FlowConfParamDTO root = new FlowConfParamDTO(flowConfNodeDTO.getTaskId(), flowConfNodeDTO.getTaskName(), flowConfNodeDTO.getTaskName());
            taskTree.add(root);
            List cpnconfNodeList = this.cpnConfNodeService.queryByBizCpnId(flowConfNodeDTO.getPluginId());
            for (CpnConfNodeDTO cpnConfNodeDTO : cpnconfNodeList) {
                FlowConfParamDTO cpnParamDTO = new FlowConfParamDTO(flowId, cpnConfNodeDTO.getNodeId(), cpnConfNodeDTO.getNodeName(), cpnConfNodeDTO.getBaseCpnId(), cpnConfNodeDTO.getNodeName());
                root.getChildren().add(cpnParamDTO);
            }
        }
        return this.getResponseData(taskTree);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryCpnConfParam"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryCpnConfParam(@RequestParam(value="taskId") String taskId) {
        List output = this.cpnInstParamService.queryCpnConfParam(taskId);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryByFlowParam"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryByFlowParam(@RequestParam(value="flowId") String flowId, @RequestParam(value="flowNodeId") String flowNodeId, @RequestParam(value="cpnNodeId") String cpnNodeId) {
        ArrayList<CpnInstParamDTO> output = this.cpnInstParamService.queryByFlowParam(flowId, flowNodeId, cpnNodeId);
        if (CollectionUtils.isEmpty((Collection)output)) {
            List cpnConfParamDTOList = this.cpnConfParamService.queryByCpnId(cpnNodeId);
            if (CollectionUtils.isEmpty((Collection)cpnConfParamDTOList)) {
                output = new ArrayList<CpnInstParamDTO>();
            } else {
                output = new ArrayList();
                for (int i = 0; i < cpnConfParamDTOList.size(); ++i) {
                    CpnInstParamDTO cpnInstParamDTO = new CpnInstParamDTO();
                    cpnInstParamDTO.setFlowId(flowId);
                    cpnInstParamDTO.setFlowNodeId(flowNodeId);
                    cpnInstParamDTO.setCpnNodeId(cpnNodeId);
                    cpnInstParamDTO.setCpnDataInput(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamName());
                    cpnInstParamDTO.setCpnDataInputDesc(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamDesc());
                    cpnInstParamDTO.setParamInoutType(String.valueOf(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamInoutType()));
                    cpnInstParamDTO.setCpnAdapType(String.valueOf(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getInEvalMethod()));
                    cpnInstParamDTO.setCpnAssignOperate("=");
                    output.add(cpnInstParamDTO);
                }
                this.cpnInstParamService.batchInfo(output);
            }
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryBaseCpnParam"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryBaseCpnParam(@RequestParam(value="flowId") String flowId, @RequestParam(value="flowNodeId") String flowNodeId, @RequestParam(value="cpnNodeId") String cpnNodeId) {
        ArrayList<CpnInstParamDTO> output = this.cpnInstParamService.queryBaseCpnParam(flowId, flowNodeId, cpnNodeId);
        if (CollectionUtils.isEmpty((Collection)output)) {
            List cpnConfParamDTOList = this.cpnConfParamService.queryByCpnId(cpnNodeId);
            if (CollectionUtils.isEmpty((Collection)cpnConfParamDTOList)) {
                output = new ArrayList<CpnInstParamDTO>();
            } else {
                output = new ArrayList();
                for (int i = 0; i < cpnConfParamDTOList.size(); ++i) {
                    CpnInstParamDTO cpnInstParamDTO = new CpnInstParamDTO();
                    cpnInstParamDTO.setFlowId(flowId);
                    cpnInstParamDTO.setFlowNodeId(flowNodeId);
                    cpnInstParamDTO.setCpnNodeId(cpnNodeId);
                    cpnInstParamDTO.setCpnDataInput(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamName());
                    cpnInstParamDTO.setCpnDataInputDesc(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamDesc());
                    cpnInstParamDTO.setParamInoutType(String.valueOf(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getParamInoutType()));
                    cpnInstParamDTO.setCpnAdapType(String.valueOf(((CpnConfParamDTO)cpnConfParamDTOList.get(i)).getInEvalMethod()));
                    cpnInstParamDTO.setCpnAssignOperate("=");
                    output.add(cpnInstParamDTO);
                }
                this.cpnInstParamService.batchInfo(output);
            }
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryByCpnId"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryByCpnId(@RequestParam(value="flowId") String flowId, @RequestParam(value="cpnId") String cpnId) {
        List output = this.cpnInstParamService.queryByCpnId(flowId, cpnId);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryList(CpnInstParamDTO input) {
        List output = this.cpnInstParamService.queryCpnTechParamList(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/queryInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<CpnInstParamDTO>> queryInfo(@RequestParam(value="flowId") String flowId, @RequestParam(value="cpnId") String cpnId) {
        List output = this.cpnInstParamService.queryInfo(flowId, cpnId);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insert(@RequestBody CpnInstParamDTO input) {
        List list = this.cpnConfParamService.queryByCpnId(input.getCpnId());
        int output = this.cpnInstParamService.insertInfo(input, list);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> update(@RequestBody List<CpnInstParamDTO> input) {
        int output = this.cpnInstParamService.updateInfo(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnTechParam/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody CpnInstParamDTO input) {
        int outputVo = this.cpnInstParamService.deleteCpnTechParam(input);
        return this.getResponseData(outputVo);
    }
}

