/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.consolse.web.controller.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.irdstudio.allinflow.console.types.FlowSheetNodeType;
import com.irdstudio.allinflow.cpn.facade.operation.CpnConfMasterFormService;
import com.irdstudio.allinflow.cpn.facade.operation.CpnConfNodeService;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfMasterFormDTO;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfNodeDTO;
import com.irdstudio.allinflow.cpn.types.CpnCategoryEnum;
import com.irdstudio.allinflow.cpn.types.CpnStateEnum;
import com.irdstudio.allinflow.cpn.types.CpnTypeEnum;
import com.irdstudio.allinflow.cpn.types.NodeBackgroundEnum;
import com.irdstudio.allinflow.cpn.types.TaskUseAreaEnum;
import com.irdstudio.allinflow.cpn.types.TaskUseStateEnum;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfMasterService;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfNodeService;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfStageService;
import com.irdstudio.allinflow.deliver.console.facade.FlowInstNodeService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfMasterDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfNodeDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfStageDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstNodeDTO;
import com.irdstudio.allinflow.deliver.console.types.BatchState;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.UUIDUtil;
import com.irdstudio.allinflow.flow.console.facade.dto.FlowSheetDTO;
import com.irdstudio.allinflow.flow.console.facade.dto.TreeCpnDTO;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.FlowDocumentJson;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.FlowNodeData;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.FlowNodeJson;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.WorkflowEdgeJson;
import com.irdstudio.allinflow.flow.consolse.web.controller.util.FlowSheetHandle;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.DateTool;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FlowSheetController
extends AbstractController
implements FrameworkService {
    public static Logger logger = LoggerFactory.getLogger(FlowSheetController.class);
    @Autowired
    private FlowInstNodeService flowInstNodeService;
    @Autowired
    private CpnConfNodeService cpnConfNodeService;
    @Autowired
    private FlowConfNodeService flowConfNodeService;
    @Autowired
    private CpnConfMasterFormService cpnConfMasterFormService;
    @Autowired
    private FlowConfMasterService flowConfMasterService;
    @Autowired
    private FlowConfStageService flowConfStageService;

    @RequestMapping(value={"/client/cpn/queryTreeByCpnCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowSheetDTO> queryTreeByCpnCategory(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)dto.getCpnCategoryList())) {
            responseData.setMessage("\u672a\u4f20\u7ec4\u4ef6\u7c7b\u522b\uff01");
            return responseData;
        }
        String cpnCategorys = dto.getCpnCategoryList().stream().collect(Collectors.joining(","));
        CpnConfMasterFormDTO input = new CpnConfMasterFormDTO();
        input.setCpnCategory(cpnCategorys);
        input.setCpnState(CpnStateEnum.CPN_STATE_ISSUE.getCode());
        List list = this.cpnConfMasterFormService.queryListNotPage(input);
        FlowSheetDTO r = new FlowSheetDTO();
        if ("busi".equals(dto.getLayoutType())) {
            this.handBusiTreeMenu(r, list);
        } else {
            this.handCpnTreeMenu(r, list);
        }
        responseData.setData((Object)r);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowSheetDTO>> queryList(@RequestBody FlowSheetDTO dto) {
        CpnConfMasterFormDTO input = (CpnConfMasterFormDTO)this.beanCopy(dto, new CpnConfMasterFormDTO(), true);
        input.setCpnCategory(FlowSheetNodeType.cpnCategoryByCodeLayoutType((String)dto.getNodeType(), (String)dto.getLayoutType()));
        input.setCpnState(CpnStateEnum.CPN_STATE_ISSUE.getCode());
        List list = this.cpnConfMasterFormService.queryList(input);
        List repList = this.beansCopy(list, FlowSheetDTO.class);
        repList.forEach(item -> item.setNodeType(dto.getNodeType()));
        return this.getResponseData(repList);
    }

    @RequestMapping(value={"/client/cpn/checkFlowSheetByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> checkFlowSheetByPk(@RequestBody FlowSheetDTO dto) {
        this.setUserInfoToVO(dto);
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getBatchId())) {
            responseData.setData((Object)"\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        if (StringUtils.isBlank((String)dto.getFlowSheet())) {
            responseData.setData((Object)"\u672a\u4f20\u6d41\u7a0b\u6570\u636e\uff01");
            return responseData;
        }
        FlowDocumentJson flowDocumentJson = null;
        String checkResult = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(dto.getFlowSheet(), FlowDocumentJson.class);
            checkResult = FlowSheetHandle.analyzeAndVerify(flowDocumentJson);
            if (StringUtils.isBlank((String)checkResult)) {
                checkResult = FlowSheetHandle.isSettingCpn(flowDocumentJson);
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u56fe\u6821\u9a8c\u5904\u7406\u5f02\u5e38\u3010{}\u3011", (Object)dto.getBatchId(), (Object)e);
            responseData.setData((Object)"\u6821\u9a8c\u5904\u7406\u5f02\u5e38");
            return responseData;
        }
        HashMap<String, String> pre = new HashMap<String, String>();
        HashMap<String, String> next = new HashMap<String, String>();
        for (WorkflowEdgeJson workflowEdgeJson : flowDocumentJson.getEdges()) {
            pre.put(workflowEdgeJson.getTargetNodeID(), workflowEdgeJson.getSourceNodeID());
            next.put(workflowEdgeJson.getSourceNodeID(), workflowEdgeJson.getTargetNodeID());
        }
        if (StringUtils.isBlank((String)checkResult)) {
            FlowConfMasterDTO inFlowConfMasterDTO = new FlowConfMasterDTO();
            inFlowConfMasterDTO.setBatchId(dto.getBatchId());
            inFlowConfMasterDTO.setLastModifyUser(dto.getLoginUserId());
            inFlowConfMasterDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            inFlowConfMasterDTO.setFlowSheet(dto.getFlowSheet());
            this.flowConfMasterService.updateByPk((Object)inFlowConfMasterDTO);
        }
        FlowConfStageDTO flowConfStage = new FlowConfStageDTO();
        flowConfStage.setBatchId(dto.getBatchId());
        this.flowConfStageService.deleteByBatchId(flowConfStage);
        FlowConfNodeDTO flowConfNode = new FlowConfNodeDTO();
        flowConfNode.setBatchId(dto.getBatchId());
        this.flowConfNodeService.deleteByBatchId(flowConfNode);
        ArrayList batchList = new ArrayList();
        ArrayList<FlowConfNodeDTO> flowNodeList = new ArrayList<FlowConfNodeDTO>();
        FlowSheetHandle.nodeToOrder(flowDocumentJson);
        for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
            FlowConfNodeDTO fcnd = new FlowConfNodeDTO();
            fcnd.setTaskId(flowNodeJson.getId());
            fcnd.setPreviousTaskId((String)pre.get(flowNodeJson.getId()));
            fcnd.setNextTaskId((String)next.get(flowNodeJson.getId()));
            fcnd.setBatchId(dto.getBatchId());
            if ("start".equals(flowNodeJson.getType())) {
                fcnd.setTaskName("\u5f00\u59cb");
                fcnd.setPluginId("start");
                fcnd.setTaskPri("0");
            } else if ("end".equals(flowNodeJson.getType())) {
                fcnd.setTaskName("\u7ed3\u675f");
                fcnd.setPluginId("end");
                fcnd.setTaskPri(String.valueOf(flowDocumentJson.getNodes().size()));
            } else {
                fcnd.setTaskName(flowNodeJson.getData().getTitle());
                fcnd.setPluginId(flowNodeJson.getData().getCpnId());
                if (flowNodeJson.getData().getNodeOrder() != null) {
                    fcnd.setTaskPri(String.valueOf(flowNodeJson.getData().getNodeOrder()));
                }
            }
            fcnd.setTaskUseState(TaskUseStateEnum.TODO.getCode());
            fcnd.setTaskUseArea(TaskUseAreaEnum.FIRUN.getCode());
            fcnd.setPluginType(CpnCategoryEnum.CPN_CATETORY_PRODUCT.getCode());
            if (FlowSheetNodeType.ROUTE.getCode().equals(flowNodeJson.getType())) {
                fcnd.setPluginType(CpnCategoryEnum.R.getCode());
            } else if (FlowSheetNodeType.SUBAPPR.getCode().equals(flowNodeJson.getType())) {
                fcnd.setPluginType(CpnCategoryEnum.S.getCode());
            } else if (FlowSheetNodeType.RENGONG.getCode().equals(flowNodeJson.getType())) {
                fcnd.setPluginType(CpnCategoryEnum.M.getCode());
            }
            fcnd.setTaskRunType("1");
            fcnd.setPluginSourceType("1");
            flowNodeList.add(fcnd);
        }
        int n = this.flowConfStageService.batchInsert(batchList);
        if ((n += this.flowConfNodeService.batchInsert(flowNodeList)) <= 0) {
            checkResult = "\u8282\u70b9\u4fdd\u5b58\u5904\u7406\u5931\u8d25";
        }
        responseData.setData((Object)checkResult);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/pushCheckByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowConfMasterDTO> pushCheckByPk(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getBatchId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        FlowConfMasterDTO qryDto = new FlowConfMasterDTO();
        qryDto.setBatchId(dto.getBatchId());
        FlowConfMasterDTO flowConfMasterDTO = (FlowConfMasterDTO)this.flowConfMasterService.queryByPk((Object)qryDto);
        if (flowConfMasterDTO == null) {
            responseData.setMessage("\u4e3b\u952e\u3010" + qryDto.getBatchId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
            return responseData;
        }
        try {
            FlowDocumentJson newJson;
            ObjectMapper objectMapper = new ObjectMapper();
            FlowDocumentJson flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(flowConfMasterDTO.getFlowSheet(), FlowDocumentJson.class);
            String checkResult = FlowSheetHandle.analyzeAndVerify(flowDocumentJson);
            if (StringUtils.isNotBlank((String)checkResult)) {
                logger.info("\u53d1\u5e03\u5931\u8d25\uff01\u3010{}\u3011\u3010{}\u3011", (Object)dto.getBatchId(), (Object)checkResult);
                checkResult = "\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01";
            }
            if (StringUtils.isBlank((String)checkResult) && StringUtils.isNotBlank((String)(checkResult = FlowSheetHandle.newSheetVsOldSheet(newJson = (FlowDocumentJson)objectMapper.readValue(dto.getFlowSheet(), FlowDocumentJson.class), flowDocumentJson)))) {
                logger.info("\u6d41\u7a0b\u56fe\u5b58\u5728\u53d8\u66f4\uff0c\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01\u3010{}\u3011\u3010{}\u3011", (Object)dto.getBatchId(), (Object)checkResult);
                checkResult = "\u6d41\u7a0b\u56fe\u5b58\u5728\u53d8\u66f4\uff0c\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01";
            }
            if (StringUtils.isBlank((String)checkResult)) {
                FlowConfMasterDTO updateDto = new FlowConfMasterDTO();
                updateDto.setBatchId(dto.getBatchId());
                updateDto.setBatchState(BatchState.Validated.getCode());
                this.flowConfMasterService.updateByPk((Object)updateDto);
            }
            responseData.setMessage(checkResult);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u56fe\u6821\u9a8c\u5904\u7406\u5f02\u5e38\u3010{}\u3011\uff1a", (Object)dto.getBatchId(), (Object)e);
            responseData.setData((Object)"\u6821\u9a8c\u5904\u7406\u5f02\u5e38");
            return responseData;
        }
        responseData.setData((Object)flowConfMasterDTO);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/checkCpnSheetByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> checkCpnSheetByPk(@RequestBody FlowSheetDTO dto) {
        this.setUserInfoToVO(dto);
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getCpnId())) {
            responseData.setData((Object)"\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        if (StringUtils.isBlank((String)dto.getCpnSheet())) {
            responseData.setData((Object)"\u672a\u4f20\u6d41\u7a0b\u6570\u636e\uff01");
            return responseData;
        }
        FlowDocumentJson flowDocumentJson = null;
        String checkResult = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(dto.getCpnSheet(), FlowDocumentJson.class);
            checkResult = FlowSheetHandle.analyzeAndVerify(flowDocumentJson);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u56fe\u6821\u9a8c\u5904\u7406\u5f02\u5e38\u3010{}\u3011\uff1a", (Object)dto.getCpnId(), (Object)e);
            responseData.setData((Object)"\u6821\u9a8c\u5904\u7406\u5f02\u5e38\uff01");
            return responseData;
        }
        if (StringUtils.isBlank((String)checkResult)) {
            CpnConfMasterFormDTO input = new CpnConfMasterFormDTO();
            input.setCpnId(dto.getCpnId());
            input.setCpnSheet(dto.getCpnSheet());
            this.cpnConfMasterFormService.openUpdateByPk(input);
        }
        FlowSheetHandle.nodeToOrder(flowDocumentJson);
        HashMap<String, String> pre = new HashMap<String, String>();
        HashMap<String, String> next = new HashMap<String, String>();
        for (WorkflowEdgeJson workflowEdgeJson : flowDocumentJson.getEdges()) {
            pre.put(workflowEdgeJson.getTargetNodeID(), workflowEdgeJson.getSourceNodeID());
            next.put(workflowEdgeJson.getSourceNodeID(), workflowEdgeJson.getTargetNodeID());
        }
        ArrayList<CpnConfNodeDTO> batchList = new ArrayList<CpnConfNodeDTO>();
        for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
            CpnConfNodeDTO cpnConfNodeDTO = new CpnConfNodeDTO();
            cpnConfNodeDTO.setNodeId(flowNodeJson.getId());
            cpnConfNodeDTO.setPreviousNodeId((String)pre.get(flowNodeJson.getId()));
            cpnConfNodeDTO.setNextNodeId((String)next.get(flowNodeJson.getId()));
            cpnConfNodeDTO.setBizCpnId(dto.getCpnId());
            if ("start".equals(flowNodeJson.getType())) {
                cpnConfNodeDTO.setNodeName("\u5f00\u59cb");
                cpnConfNodeDTO.setBaseCpnId("start");
                cpnConfNodeDTO.setNodePri("0");
            } else if ("end".equals(flowNodeJson.getType())) {
                cpnConfNodeDTO.setNodeName("\u7ed3\u675f");
                cpnConfNodeDTO.setBaseCpnId("end");
                cpnConfNodeDTO.setNodePri(String.valueOf(flowDocumentJson.getNodes().size()));
            } else {
                cpnConfNodeDTO.setNodeName(flowNodeJson.getData().getTitle());
                cpnConfNodeDTO.setBaseCpnId(flowNodeJson.getData().getCpnId());
                if (flowNodeJson.getData().getNodeOrder() != null) {
                    cpnConfNodeDTO.setNodePri(String.valueOf(flowNodeJson.getData().getNodeOrder()));
                }
            }
            cpnConfNodeDTO.setNodeUseState(TaskUseStateEnum.TODO.getCode());
            cpnConfNodeDTO.setNodeUseArea(TaskUseAreaEnum.FIRUN.getCode());
            cpnConfNodeDTO.setNodeRunType("1");
            cpnConfNodeDTO.setPluginSourceType("1");
            cpnConfNodeDTO.setBaseCpnType(CpnCategoryEnum.CPN_CATEGORY_BASIC.getCode());
            if (FlowSheetNodeType.ROUTE.getCode().equals(flowNodeJson.getType())) {
                cpnConfNodeDTO.setBaseCpnType(CpnCategoryEnum.R.getCode());
            } else if (FlowSheetNodeType.SUBAPPR.getCode().equals(flowNodeJson.getType())) {
                cpnConfNodeDTO.setBaseCpnType(CpnCategoryEnum.S.getCode());
            } else if (FlowSheetNodeType.RENGONG.getCode().equals(flowNodeJson.getType())) {
                cpnConfNodeDTO.setBaseCpnType(CpnCategoryEnum.M.getCode());
            }
            batchList.add(cpnConfNodeDTO);
        }
        this.cpnConfNodeService.deleteByBizCpnId(dto.getCpnId());
        this.cpnConfNodeService.batchInsert(batchList);
        responseData.setData((Object)checkResult);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/pushCpnCheckByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowConfMasterDTO> pushCpnCheckByPk(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getCpnId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        CpnConfMasterFormDTO qryDto = new CpnConfMasterFormDTO();
        qryDto.setCpnId(dto.getCpnId());
        CpnConfMasterFormDTO flowConfMasterDTO = this.cpnConfMasterFormService.queryByPk(qryDto);
        if (flowConfMasterDTO == null) {
            responseData.setMessage("\u4e3b\u952e\u3010" + qryDto.getCpnId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
            return responseData;
        }
        try {
            FlowDocumentJson newJson;
            ObjectMapper objectMapper = new ObjectMapper();
            FlowDocumentJson flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(flowConfMasterDTO.getCpnSheet(), FlowDocumentJson.class);
            String checkResult = FlowSheetHandle.analyzeAndVerify(flowDocumentJson);
            if (StringUtils.isNotBlank((String)checkResult)) {
                logger.info("\u53d1\u5e03\u5931\u8d25\uff01\u3010{}\u3011\u3010{}\u3011", (Object)dto.getCpnId(), (Object)checkResult);
                checkResult = "\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01";
            }
            if (StringUtils.isBlank((String)checkResult) && StringUtils.isNotBlank((String)(checkResult = FlowSheetHandle.newSheetVsOldSheet(newJson = (FlowDocumentJson)objectMapper.readValue(dto.getCpnSheet(), FlowDocumentJson.class), flowDocumentJson)))) {
                logger.info("\u6d41\u7a0b\u56fe\u5b58\u5728\u53d8\u66f4\uff0c\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01\u3010{}\u3011\u3010{}\u3011", (Object)dto.getCpnId(), (Object)checkResult);
                checkResult = "\u6d41\u7a0b\u56fe\u5b58\u5728\u53d8\u66f4\uff0c\u8bf7\u5148\u8fdb\u884c\u6821\u9a8c\uff01";
            }
            responseData.setMessage(checkResult);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u56fe\u6821\u9a8c\u5904\u7406\u5f02\u5e38\u3010{}\u3011\uff1a", (Object)dto.getCpnId(), (Object)e);
            responseData.setData((Object)"\u6821\u9a8c\u5904\u7406\u5f02\u5e38\uff01");
            return responseData;
        }
        responseData.setData((Object)flowConfMasterDTO);
        return responseData;
    }

    private void handCpnTreeMenu(FlowSheetDTO r, List<CpnConfMasterFormDTO> list) {
        ArrayList<TreeCpnDTO> treeCpnDTOList = new ArrayList<TreeCpnDTO>();
        HashSet<String> treeOpenKeys = new HashSet<String>();
        TreeMap<String, List<CpnConfMasterFormDTO>> collectCpnCategory = new TreeMap<String, List<CpnConfMasterFormDTO>>(list.stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getCpnCategory)));
        for (Map.Entry<String, List<CpnConfMasterFormDTO>> m1 : collectCpnCategory.entrySet()) {
            TreeCpnDTO root = new TreeCpnDTO();
            root.setKey(m1.getKey());
            root.setLabel(CpnCategoryEnum.nameByCode((String)m1.getKey()));
            root.setChildren(new ArrayList());
            if (!CollectionUtils.isNotEmpty((Collection)m1.getValue())) continue;
            treeOpenKeys.add(m1.getKey());
            ArrayList<TreeCpnDTO> cpnCategoryChilds = new ArrayList<TreeCpnDTO>();
            TreeMap<String, List<CpnConfMasterFormDTO>> collectCpnType = new TreeMap<String, List<CpnConfMasterFormDTO>>(m1.getValue().stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getCpnType)));
            for (Map.Entry<String, List<CpnConfMasterFormDTO>> m2 : collectCpnType.entrySet()) {
                TreeCpnDTO cpnTypeChild = new TreeCpnDTO();
                cpnTypeChild.setKey(m2.getKey());
                cpnTypeChild.setLabel(CpnTypeEnum.nameByCode((String)m2.getKey()));
                if (CollectionUtils.isNotEmpty((Collection)m2.getValue())) {
                    treeOpenKeys.add(m2.getKey());
                    ArrayList cpnTypeChilds = new ArrayList();
                    m2.getValue().forEach(cpnDto -> {
                        TreeCpnDTO treeCpnDTO = FlowSheetController.cpnToTreeCpn(cpnDto);
                        cpnTypeChilds.add(treeCpnDTO);
                    });
                    cpnTypeChild.setChildren(cpnTypeChilds);
                }
                cpnCategoryChilds.add(cpnTypeChild);
            }
            root.getChildren().addAll(cpnCategoryChilds);
            treeCpnDTOList.add(root);
        }
        r.setTreeItems(treeCpnDTOList);
        r.setTreeOpenKeys(treeOpenKeys);
    }

    private void handBusiTreeMenu(FlowSheetDTO r, List<CpnConfMasterFormDTO> list) {
        ArrayList<TreeCpnDTO> treeCpnDTOList = new ArrayList<TreeCpnDTO>();
        HashSet<String> treeOpenKeys = new HashSet<String>();
        TreeCpnDTO root = new TreeCpnDTO();
        root.setKey("root");
        root.setLabel("\u667a\u6167\u4fe1\u8d37");
        root.setChildren(new ArrayList());
        TreeCpnDTO first = new TreeCpnDTO();
        first.setKey("first");
        first.setLabel("\u516c\u5171\u4ea7\u54c1\u7ec4\u4ef6");
        first.setChildren(new ArrayList());
        root.getChildren().add(first);
        treeOpenKeys.add("root");
        treeOpenKeys.add("first");
        TreeMap<String, List<CpnConfMasterFormDTO>> collectCpnCategory = new TreeMap<String, List<CpnConfMasterFormDTO>>(list.stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getCpnCategory)));
        for (Map.Entry<String, List<CpnConfMasterFormDTO>> m1 : collectCpnCategory.entrySet()) {
            if (CpnCategoryEnum.CPN_CATETORY_PRODUCT.getCode().equals(m1.getKey())) {
                if (!CollectionUtils.isNotEmpty((Collection)m1.getValue())) continue;
                Map<Boolean, List<CpnConfMasterFormDTO>> bizLinePartitioned = m1.getValue().stream().collect(Collectors.partitioningBy(line -> StringUtils.isBlank((String)line.getOwnerBizLine())));
                if (CollectionUtils.isNotEmpty((Collection)bizLinePartitioned.get(false))) {
                    TreeMap<String, List<CpnConfMasterFormDTO>> collectOwnerBizLine = new TreeMap<String, List<CpnConfMasterFormDTO>>(bizLinePartitioned.get(false).stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getOwnerBizLine)));
                    for (Map.Entry<String, List<CpnConfMasterFormDTO>> m : collectOwnerBizLine.entrySet()) {
                        TreeCpnDTO lineCpnDto = new TreeCpnDTO();
                        lineCpnDto.setKey(UUIDUtil.getUUID());
                        lineCpnDto.setLabel(m.getKey());
                        lineCpnDto.setChildren(new ArrayList());
                        treeOpenKeys.add(lineCpnDto.getKey());
                        Map<Boolean, List<CpnConfMasterFormDTO>> bizPrdPartitioned = m.getValue().stream().collect(Collectors.partitioningBy(line -> StringUtils.isBlank((String)line.getOwnerBizProduct())));
                        if (CollectionUtils.isNotEmpty((Collection)bizPrdPartitioned.get(false))) {
                            TreeMap<String, List<CpnConfMasterFormDTO>> collectOwnerBizProduct = new TreeMap<String, List<CpnConfMasterFormDTO>>(bizPrdPartitioned.get(false).stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getOwnerBizProduct)));
                            for (Map.Entry<String, List<CpnConfMasterFormDTO>> m2 : collectOwnerBizProduct.entrySet()) {
                                TreeCpnDTO bizPrdDto = new TreeCpnDTO();
                                bizPrdDto.setKey(UUIDUtil.getUUID());
                                bizPrdDto.setLabel(m2.getKey());
                                bizPrdDto.setChildren(new ArrayList());
                                treeOpenKeys.add(bizPrdDto.getKey());
                                m2.getValue().forEach(child -> {
                                    TreeCpnDTO treeDto = FlowSheetController.cpnToTreeCpn(child);
                                    bizPrdDto.getChildren().add(treeDto);
                                });
                                lineCpnDto.getChildren().add(bizPrdDto);
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)bizPrdPartitioned.get(true))) {
                            bizPrdPartitioned.get(true).forEach(prdDto -> {
                                TreeCpnDTO treeCpnDTO = FlowSheetController.cpnToTreeCpn(prdDto);
                                lineCpnDto.getChildren().add(treeCpnDTO);
                            });
                        }
                        root.getChildren().add(lineCpnDto);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)bizLinePartitioned.get(true))) continue;
                Map<Boolean, List<CpnConfMasterFormDTO>> bizPrdPartitioned = bizLinePartitioned.get(true).stream().collect(Collectors.partitioningBy(line -> StringUtils.isBlank((String)line.getOwnerBizProduct())));
                if (CollectionUtils.isNotEmpty((Collection)bizPrdPartitioned.get(true))) {
                    bizPrdPartitioned.get(true).forEach(prdDto -> {
                        TreeCpnDTO treeCpnDTO = FlowSheetController.cpnToTreeCpn(prdDto);
                        ((TreeCpnDTO)root.getChildren().get(0)).getChildren().add(treeCpnDTO);
                    });
                }
                if (!CollectionUtils.isNotEmpty((Collection)bizPrdPartitioned.get(false))) continue;
                TreeMap<String, List<CpnConfMasterFormDTO>> collectOwnerBizProduct = new TreeMap<String, List<CpnConfMasterFormDTO>>(bizPrdPartitioned.get(false).stream().collect(Collectors.groupingBy(CpnConfMasterFormDTO::getOwnerBizProduct)));
                for (Map.Entry<String, List<CpnConfMasterFormDTO>> m : collectOwnerBizProduct.entrySet()) {
                    TreeCpnDTO bizPrdDto = new TreeCpnDTO();
                    bizPrdDto.setKey(UUIDUtil.getUUID());
                    bizPrdDto.setLabel(m.getKey());
                    bizPrdDto.setChildren(new ArrayList());
                    treeOpenKeys.add(bizPrdDto.getKey());
                    m.getValue().forEach(child -> {
                        TreeCpnDTO treeDto = FlowSheetController.cpnToTreeCpn(child);
                        bizPrdDto.getChildren().add(treeDto);
                    });
                    root.getChildren().add(bizPrdDto);
                }
                continue;
            }
            TreeCpnDTO pubChilds = new TreeCpnDTO();
            pubChilds.setKey(m1.getKey());
            treeOpenKeys.add(pubChilds.getKey());
            pubChilds.setLabel(CpnCategoryEnum.nameByCode((String)m1.getKey()));
            if (!CollectionUtils.isNotEmpty((Collection)m1.getValue())) continue;
            ArrayList pubChildList = new ArrayList();
            m1.getValue().forEach(pubDto -> {
                TreeCpnDTO treeCpnDTO = FlowSheetController.cpnToTreeCpn(pubDto);
                pubChildList.add(treeCpnDTO);
            });
            pubChilds.setChildren(pubChildList);
            ((TreeCpnDTO)root.getChildren().get(0)).getChildren().add(pubChilds);
        }
        treeCpnDTOList.add(root);
        r.setTreeItems(treeCpnDTOList);
        r.setTreeOpenKeys(treeOpenKeys);
    }

    private static TreeCpnDTO cpnToTreeCpn(CpnConfMasterFormDTO cpnDto) {
        TreeCpnDTO treeCpnDTO = new TreeCpnDTO();
        treeCpnDTO.setKey(cpnDto.getCpnId());
        treeCpnDTO.setCpnCode(cpnDto.getCpnCode());
        treeCpnDTO.setLabel(cpnDto.getCpnName());
        if (CpnCategoryEnum.CPN_CATEGORY_BASIC.getCode().equals(cpnDto.getCpnCategory())) {
            treeCpnDTO.setNodeType(FlowSheetNodeType.AUTO.getCode());
        } else if (CpnCategoryEnum.R.getCode().equals(cpnDto.getCpnCategory())) {
            treeCpnDTO.setNodeType(FlowSheetNodeType.ROUTE.getCode());
        } else if (CpnCategoryEnum.CPN_CATETORY_PRODUCT.getCode().equals(cpnDto.getCpnCategory())) {
            treeCpnDTO.setNodeType(FlowSheetNodeType.AUTO.getCode());
        } else if (CpnCategoryEnum.S.getCode().equals(cpnDto.getCpnCategory())) {
            treeCpnDTO.setNodeType(FlowSheetNodeType.SUBAPPR.getCode());
        } else if (CpnCategoryEnum.M.getCode().equals(cpnDto.getCpnCategory())) {
            treeCpnDTO.setNodeType(FlowSheetNodeType.RENGONG.getCode());
        }
        return treeCpnDTO;
    }

    @RequestMapping(value={"/client/cpn/pushByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> pushByPk(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getBatchId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        FlowConfMasterDTO updateDto = new FlowConfMasterDTO();
        updateDto.setBatchId(dto.getBatchId());
        updateDto.setBatchState(BatchState.Publish.getCode());
        int n = this.flowConfMasterService.updateByPk((Object)updateDto);
        if (n <= 0) {
            throw new RuntimeException("\u4e1a\u52a1\u6d41\u7a0b\u53d1\u5e03\u5f02\u5e38");
        }
        responseData.setData((Object)n);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/pushCpnByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> pushCpnByPk(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getCpnId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952e\uff01");
            return responseData;
        }
        CpnConfMasterFormDTO input = new CpnConfMasterFormDTO();
        input.setCpnId(dto.getCpnId());
        input.setCpnState(CpnStateEnum.CPN_STATE_ISSUE.getCode());
        int n = this.cpnConfMasterFormService.updateByPk(input);
        if (n <= 0) {
            throw new RuntimeException("\u7ec4\u4ef6\u6d41\u7a0b\u53d1\u5e03\u5f02\u5e38");
        }
        responseData.setData((Object)n);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/delByNodeId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> delByNodeId(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getNodeId())) {
            responseData.setMessage("\u672a\u4f20\u8282\u70b9ID\uff01");
            return responseData;
        }
        int n = this.cpnConfNodeService.delAllParamsByNodeId(dto.getNodeId());
        responseData.setData((Object)n);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/view"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowSheetDTO> view(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getFlowId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952eID");
            return responseData;
        }
        if (StringUtils.isBlank((String)dto.getViewType())) {
            responseData.setMessage("\u672a\u4f20\u67e5\u8be2\u7c7b\u578b");
            return responseData;
        }
        FlowSheetDTO r = new FlowSheetDTO();
        if ("cpn".equals(dto.getViewType())) {
            CpnConfMasterFormDTO qryDto = new CpnConfMasterFormDTO();
            qryDto.setCpnId(dto.getFlowId());
            CpnConfMasterFormDTO flowConfMasterDTO = this.cpnConfMasterFormService.queryByPk(qryDto);
            if (flowConfMasterDTO == null) {
                responseData.setMessage("\u4e3b\u952e\u3010" + qryDto.getCpnId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
                return responseData;
            }
            r.setFlowSheet(flowConfMasterDTO.getCpnSheet());
        } else if ("busi".equals(dto.getViewType())) {
            FlowConfMasterDTO qryDto = new FlowConfMasterDTO();
            qryDto.setBatchId(dto.getFlowId());
            FlowConfMasterDTO flowConfMasterDTO = (FlowConfMasterDTO)this.flowConfMasterService.queryByPk((Object)qryDto);
            if (flowConfMasterDTO == null) {
                responseData.setMessage("\u4e3b\u952e\u3010" + qryDto.getBatchId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
                return responseData;
            }
            r.setFlowSheet(flowConfMasterDTO.getFlowSheet());
        } else if ("busiProgress".equals(dto.getViewType())) {
            FlowInstNodeDTO qryDto = new FlowInstNodeDTO();
            qryDto.setBatchId(dto.getFlowId());
            qryDto.setBatchSerialNo(dto.getSerialNo());
            List flowInstNodeDTOList = this.flowInstNodeService.queryList((Object)qryDto);
            FlowConfMasterDTO qryDto2 = new FlowConfMasterDTO();
            qryDto2.setBatchId(dto.getFlowId());
            FlowConfMasterDTO flowConfMasterDTO = (FlowConfMasterDTO)this.flowConfMasterService.queryByPk((Object)qryDto2);
            if (flowConfMasterDTO == null) {
                responseData.setMessage("\u4e3b\u952e\u3010" + qryDto2.getBatchId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
                return responseData;
            }
            if (CollectionUtils.isNotEmpty((Collection)flowInstNodeDTOList)) {
                HashMap<String, String> stMap = new HashMap<String, String>();
                for (FlowInstNodeDTO flowInstNodeDTO : flowInstNodeDTOList) {
                    stMap.put(flowInstNodeDTO.getTaskId(), flowInstNodeDTO.getTaskRunState());
                }
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    FlowDocumentJson flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(flowConfMasterDTO.getFlowSheet(), FlowDocumentJson.class);
                    for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
                        if ("start".equals(flowNodeJson.getType()) || "end".equals(flowNodeJson.getType())) continue;
                        String color = NodeBackgroundEnum.colorByCode((String)((String)stMap.get(flowNodeJson.getId())));
                        flowNodeJson.getData().setNodeRunState((String)stMap.get(flowNodeJson.getId()));
                        flowNodeJson.getData().setNodeBackground(color);
                        String name = NodeBackgroundEnum.nameByCode((String)((String)stMap.get(flowNodeJson.getId())));
                        if (!StringUtils.isNotBlank((String)name)) continue;
                        flowNodeJson.getData().setTitle(flowNodeJson.getData().getTitle() + "\u3010" + name + "\u3011");
                    }
                    r.setFlowSheet(objectMapper.writeValueAsString((Object)flowDocumentJson));
                }
                catch (Exception e) {
                    logger.error("\u6d41\u7a0b\u56fe\u8fdb\u5ea6\u67e5\u770b\u5f02\u5e38\u3010{}\u3011\uff1a", (Object)dto.getCpnId(), (Object)e);
                    responseData.setData((Object)"\u6d41\u7a0b\u56fe\u8fdb\u5ea6\u67e5\u770b\u5f02\u5e38\uff01");
                    return responseData;
                }
            } else {
                r.setFlowSheet(flowConfMasterDTO.getFlowSheet());
            }
        } else if ("cpnProgress".equals(dto.getViewType())) {
            FlowInstNodeDTO qryDto = new FlowInstNodeDTO();
            qryDto.setBatchId(dto.getFlowId());
            qryDto.setBatchSerialNo(dto.getSerialNo());
            List flowInstNodeDTOList = this.flowInstNodeService.queryList((Object)qryDto);
            CpnConfMasterFormDTO qryDto2 = new CpnConfMasterFormDTO();
            qryDto2.setCpnId(dto.getFlowId());
            CpnConfMasterFormDTO flowConfMasterDTO = this.cpnConfMasterFormService.queryByPk(qryDto2);
            if (flowConfMasterDTO == null) {
                responseData.setMessage("\u4e3b\u952e\u3010" + qryDto2.getCpnId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55\uff01");
                return responseData;
            }
            if (CollectionUtils.isNotEmpty((Collection)flowInstNodeDTOList)) {
                HashMap<String, String> stMap = new HashMap<String, String>();
                for (FlowInstNodeDTO flowInstNodeDTO : flowInstNodeDTOList) {
                    stMap.put(flowInstNodeDTO.getTaskId(), flowInstNodeDTO.getTaskRunState());
                }
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    FlowDocumentJson flowDocumentJson = (FlowDocumentJson)objectMapper.readValue(flowConfMasterDTO.getCpnSheet(), FlowDocumentJson.class);
                    for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
                        if ("start".equals(flowNodeJson.getType()) || "end".equals(flowNodeJson.getType())) continue;
                        String color = NodeBackgroundEnum.colorByCode((String)((String)stMap.get(flowNodeJson.getId())));
                        flowNodeJson.getData().setNodeRunState((String)stMap.get(flowNodeJson.getId()));
                        flowNodeJson.getData().setNodeBackground(color);
                        String name = NodeBackgroundEnum.nameByCode((String)((String)stMap.get(flowNodeJson.getId())));
                        if (!StringUtils.isNotBlank((String)name)) continue;
                        flowNodeJson.getData().setTitle(flowNodeJson.getData().getTitle() + "\u3010" + name + "\u3011");
                    }
                    r.setFlowSheet(objectMapper.writeValueAsString((Object)flowDocumentJson));
                }
                catch (Exception e) {
                    logger.error("\u6d41\u7a0b\u56fe\u8fdb\u5ea6\u67e5\u770b\u5f02\u5e38\u3010{}\u3011\uff1a", (Object)dto.getCpnId(), (Object)e);
                    responseData.setData((Object)"\u6d41\u7a0b\u56fe\u8fdb\u5ea6\u67e5\u770b\u5f02\u5e38\uff01");
                    return responseData;
                }
            } else {
                r.setFlowSheet(flowConfMasterDTO.getCpnSheet());
            }
        } else {
            responseData.setMessage("\u4e0d\u5b58\u5728\u7684\u9884\u89c8\u7c7b\u578b\uff01");
            return responseData;
        }
        responseData.setData((Object)r);
        return responseData;
    }

    @RequestMapping(value={"/client/cpn/getRouteChilds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowSheetDTO> getRouteChilds(@RequestBody FlowSheetDTO dto) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((String)dto.getFlowId())) {
            responseData.setMessage("\u672a\u4f20\u4e3b\u952eID");
            return responseData;
        }
        String dateTime = DateTool.getCurrentDateTimeSSS().substring(0, 16);
        String id1 = dto.getFlowId() + "_" + dateTime + "1";
        String id2 = dto.getFlowId() + "_" + dateTime + "2";
        String id3 = dto.getFlowId() + "_" + dateTime + "3";
        ArrayList<FlowNodeJson> routeChilds = new ArrayList<FlowNodeJson>();
        FlowNodeJson f1 = new FlowNodeJson();
        f1.setId(id1);
        f1.setType("auto");
        f1.setData(new FlowNodeData("\u8def\u7531\u81ea\u52a8\u5b50\u8282\u70b91", "\u5148\u8bf7\u9009\u62e9\u7ec4\u4ef6"));
        HashMap meta1 = new HashMap();
        HashMap<String, Double> position1 = new HashMap<String, Double>();
        position1.put("x", dto.getX() + 438.0);
        position1.put("y", dto.getY() - 162.0);
        meta1.put("position", position1);
        f1.setMeta(meta1);
        FlowNodeJson f2 = new FlowNodeJson();
        f2.setId(id2);
        f2.setType("auto");
        f2.setData(new FlowNodeData("\u8def\u7531\u81ea\u52a8\u5b50\u8282\u70b92", "\u5148\u8bf7\u9009\u62e9\u7ec4\u4ef6"));
        HashMap meta2 = new HashMap();
        HashMap<String, Double> position2 = new HashMap<String, Double>();
        position2.put("x", dto.getX() + 438.0);
        position2.put("y", dto.getY());
        meta2.put("position", position2);
        f2.setMeta(meta2);
        FlowNodeJson f3 = new FlowNodeJson();
        f3.setId(id3);
        f3.setType("auto");
        f3.setData(new FlowNodeData("\u8def\u7531\u81ea\u52a8\u5b50\u8282\u70b93", "\u5148\u8bf7\u9009\u62e9\u7ec4\u4ef6"));
        HashMap meta3 = new HashMap();
        HashMap<String, Double> position3 = new HashMap<String, Double>();
        position3.put("x", dto.getX() + 438.0);
        position3.put("y", dto.getY() + 162.0);
        meta3.put("position", position3);
        f3.setMeta(meta3);
        routeChilds.add(f1);
        routeChilds.add(f2);
        routeChilds.add(f3);
        WorkflowEdgeJson w1 = new WorkflowEdgeJson(dto.getNodeId(), id1);
        WorkflowEdgeJson w2 = new WorkflowEdgeJson(dto.getNodeId(), id2);
        WorkflowEdgeJson w3 = new WorkflowEdgeJson(dto.getNodeId(), id3);
        ArrayList<WorkflowEdgeJson> routeChildEdges = new ArrayList<WorkflowEdgeJson>();
        routeChildEdges.add(w1);
        routeChildEdges.add(w2);
        routeChildEdges.add(w3);
        FlowSheetDTO r = new FlowSheetDTO();
        r.setRouteChilds(routeChilds);
        r.setRouteChildEdges(routeChildEdges);
        responseData.setData((Object)r);
        return responseData;
    }
}

