/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinflow.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allintpaas.sdk.dict.facade.operation.SDicService;
import com.irdstudio.allintpaas.sdk.dict.facade.operation.dto.SDicDTO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.core.vo.UserInfo;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class SSubsInfoPortalController
extends BaseController<SSubsInfoDTO, SSubsInfoPortalService> {
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private SeqInstInfoService seqService;
    @Autowired
    private SDicService sDicService;

    @RequestMapping(value={"/api/portal/s/subs/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> querySSubsInfoAll(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/envs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> queryWithEnvListByPage(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryWithEnvListByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/max"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> querySSubsInfoMaxOrder() {
        Integer outputVo = ((SSubsInfoPortalService)this.getService()).querySSubsInfoMaxOrder();
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/ddspaas"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryDdspaasSummaryByPage(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        this.setUserInfoToVO(vo);
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryDdspaasSummaryByPage(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsSummary(SSubsInfoDTO vo) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySubsSummary(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SSubsInfoDTO> queryByPk(@PathVariable(value="subsId") String subsId) {
        SSubsInfoDTO inVo = new SSubsInfoDTO();
        inVo.setSubsId(subsId);
        SSubsInfoDTO outputVo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        this.setUserInfoToVO(inSSubsInfoVo);
        int outputVo = ((SSubsInfoPortalService)this.getService()).deleteByPk((Object)inSSubsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        SSubsInfoDTO oldSubsInfo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inSSubsInfoVo);
        this.setUserInfoToVO(inSSubsInfoVo);
        inSSubsInfoVo.setLastUpdateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((SSubsInfoPortalService)this.getService()).updateByPk((Object)inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, !org.apache.commons.lang3.StringUtils.equals((CharSequence)oldSubsInfo.getDocLibraryId(), (CharSequence)inSSubsInfoVo.getDocLibraryId()));
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSSubsInfo(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        inSSubsInfoVo.setSubsDataDate(formatter.format(date));
        this.setUserInfoToVO(inSSubsInfoVo);
        inSSubsInfoVo.setCreateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inSSubsInfoVo.setLastUpdateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)inSSubsInfoVo.getSubsId())) {
            inSSubsInfoVo.setSubsId(this.seqService.nextSequence("PAAS-SUBS-ID", inSSubsInfoVo.getSolutionType()));
        }
        int outputVo = ((SSubsInfoPortalService)this.getService()).insert((Object)inSSubsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/gen/wiki/dirs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestParam(value="subsId") String subsId) {
        SSubsInfoDTO inSSubsInfoVo = new SSubsInfoDTO();
        inSSubsInfoVo.setSubsId(subsId);
        inSSubsInfoVo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inSSubsInfoVo);
        this.setUserInfoToVO(inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, true);
        }
        return this.getResponseData(1);
    }

    private void initWikiDirectory(SSubsInfoDTO subsInfo, Boolean recovery) {
    }

    @RequestMapping(value={"/api/portal/s/subs/info/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> queryAllSSubsInfo(SSubsInfoDTO vo) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/apps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySubsApps() {
        SSubsInfoDTO vo = new SSubsInfoDTO();
        vo.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List subsList = ((SSubsInfoPortalService)this.getService()).queryList((Object)vo);
        HashMap<String, List> outputVo = new HashMap<String, List>();
        outputVo.put("subs", subsList);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/portal/s/subs/info/import/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestPart(value="file") MultipartFile file) {
        try {
            UserInfo userInfo = this.getUserInfo();
            String userId = userInfo.getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u5e94\u7528\u7cfb\u7edf\u7f16\u53f7", "\u5e94\u7528\u7cfb\u7edf\u7b80\u79f0", "\u5e94\u7528\u7cfb\u7edf\u540d\u79f0", "\u5e94\u7528\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u5e94\u7528\u7cfb\u7edf\u7b80\u4ecb", "\u5e94\u7528\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u5e94\u7528\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u5e94\u7528\u7cfb\u7edf\u72b6\u6001");
            ArrayList headCellList = new ArrayList();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            SubsInfoExcelReadListener subsListener = new SubsInfoExcelReadListener();
            ReadSheet subsSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)subsListener)).headRowNumber(Integer.valueOf(1))).build();
            excelReader.read(new ReadSheet[]{subsSheet});
            if (subsListener.getList().size() > 0) {
                SDicDTO dicParam = new SDicDTO();
                dicParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                dicParam.setOpttypes(Arrays.asList("ARCH_LEVEL_TYPE", "SUBS_STATE", "SCOPE_USE", "SERVICE_USED"));
                List dictList = this.sDicService.queryList((Object)dicParam);
                HashMap<String, SDicDTO> dictMap = new HashMap<String, SDicDTO>();
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (SDicDTO d : dictList) {
                        String key = String.format("%s-%s", d.getOpttype(), d.getCnname());
                        dictMap.put(key, d);
                    }
                }
                List<SSubsInfoDTO> subsList = subsListener.getList();
                for (SSubsInfoDTO s : subsList) {
                    SDicDTO code;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getArchLevelType())) {
                        String archLevel = s.getArchLevelType();
                        code = (SDicDTO)dictMap.get("ARCH_LEVEL_TYPE-" + archLevel);
                        if (code != null) {
                            s.setArchLevelType(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getScopeUse())) {
                        String scopeUse = s.getScopeUse();
                        code = (SDicDTO)dictMap.get("SCOPE_USE-" + scopeUse);
                        if (code != null) {
                            s.setScopeUse(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getServiceUsed())) {
                        String serviceUsed = s.getServiceUsed();
                        code = (SDicDTO)dictMap.get("SERVICE_USED-" + serviceUsed);
                        if (code != null) {
                            s.setServiceUsed(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getSubsState())) {
                        String state = s.getSubsState();
                        code = (SDicDTO)dictMap.get("SUBS_STATE-" + state);
                        if (code != null) {
                            s.setSubsState(code.getEnname());
                        }
                    }
                    s.setSolutionType("S");
                }
                ((SSubsInfoPortalService)this.getService()).saveSubsInfoImportList(subsList);
            }
            return this.getResponseData("S");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u6807\u51c6\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/api/portal/s/subs/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAllSSubsInfo(@RequestParam(value="solutionType") String solutionType) {
        String result = ((SSubsInfoPortalService)this.getService()).querySSubsInfoMaxOrderWithPrefix(solutionType);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySummary(Map<String, Object> param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySummary(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsInfoSummary(SSubsInfoDTO param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySubsInfoSummaryByPage(param);
        ResponseData result = this.getResponseData(outputVo);
        result.setTotal(param.getTotal().intValue());
        return result;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/group/solutionType"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySummaryBySolutionTypeGroup(SSubsInfoDTO param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySummaryBySolutionTypeGroup(param);
        ResponseData result = this.getResponseData(outputVo);
        result.setTotal(param.getTotal().intValue());
        return result;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/cba"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsCbaSummary(@RequestBody Map<String, Object> params) {
        return this.getResponseData(((SSubsInfoPortalService)this.getService()).querySubsCbaSummary(params));
    }

    public static class SubsInfoExcelReadListener
    extends AnalysisEventListener {
        private List<SSubsInfoDTO> list = new ArrayList<SSubsInfoDTO>();
        private List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u5e94\u7528\u7cfb\u7edf\u7f16\u53f7", "\u5e94\u7528\u7cfb\u7edf\u7b80\u79f0", "\u5e94\u7528\u7cfb\u7edf\u540d\u79f0", "\u5e94\u7528\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u5e94\u7528\u7cfb\u7edf\u7b80\u4ecb", "\u5e94\u7528\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u5e94\u7528\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u5e94\u7528\u7cfb\u7edf\u72b6\u6001");
        private List<String> headCellList = new ArrayList<String>();

        public List<SSubsInfoDTO> getList() {
            return this.list;
        }

        public void setList(List<SSubsInfoDTO> list) {
            this.list = list;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Map map = (Map)data;
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            String id = (String)map.get(5);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            subsInfo.setArchLevelType((String)map.get(4));
            subsInfo.setSubsId((String)map.get(5));
            subsInfo.setSubsCode((String)map.get(6));
            subsInfo.setSubsName((String)map.get(7));
            subsInfo.setSubsEnname((String)map.get(8));
            subsInfo.setSubsIntro((String)map.get(9));
            subsInfo.setScopeUse((String)map.get(10));
            subsInfo.setServiceUsed((String)map.get(11));
            subsInfo.setSubsState((String)map.get(12));
            this.list.add(subsInfo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }
}

