/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.assembly.imdbcp.datasource;

import com.irdstudio.allinflow.executor.application.executor.core.assembly.imdbcp.datasource.DataSourceParm;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.imdbcp.datasource.PoolMonitorThread;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.imdbcp.resource.RsConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PoolDataSource
implements DataSource {
    public static final String VERSION = "PoolDataSource 1.0.0.1";
    public static final int DSSTATE_INITING = 1;
    public static final int DSSTATE_CONNECTING = 2;
    public static final int DSSTATE_CLOSEING = 4;
    private ArrayList freeConnections = new ArrayList();
    private ArrayList useConnections = new ArrayList();
    private DataSourceParm connParm;
    private int state = 1;
    private PoolMonitorThread monitor = null;

    public PoolDataSource() {
    }

    public PoolDataSource(DataSourceParm parm) {
        this.connParm = parm;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.connParm.getUser(), this.connParm.getPassword());
    }

    private synchronized void waitForInit() throws SQLException {
        int state = this.getState();
        if (state == 1) {
            this.init();
        }
    }

    private synchronized void init() throws SQLException {
        System.err.println(VERSION);
        System.err.println(this.connParm.toString());
        for (int i = 0; i < this.connParm.getMinConnection(); ++i) {
            this.freeConnections.add(this.newConnection(this.connParm.getUser(), this.connParm.getPassword()));
        }
        this.monitor = new PoolMonitorThread(this, this.connParm.getCheckInterval());
        this.monitor.start();
        this.setState(2);
    }

    public int getFreeCount() {
        return this.freeConnections.size();
    }

    public int getConnectionCount() {
        return this.freeConnections.size() + this.useConnections.size();
    }

    public synchronized RsConnection newConnection(String username, String password) throws SQLException {
        try {
            Class.forName(this.connParm.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("\u6570\u636e\u5e93\u9a71\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        Properties extendParm = (Properties)this.connParm.getExtendProperties().clone();
        extendParm.setProperty("user", username);
        extendParm.setProperty("password", password);
        try (Connection _con = DriverManager.getConnection(this.connParm.getUrl(), extendParm);){
            _con.setTransactionIsolation(this.connParm.getTransation());
            RsConnection _rscon = new RsConnection(_con, this.connParm);
            _rscon.setDataSource(this);
            RsConnection rsConnection = _rscon;
            return rsConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeConnection(RsConnection con) {
        ArrayList arrayList = this.freeConnections;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.useConnections;
            synchronized (arrayList2) {
                if (this.getConnectionCount() < this.connParm.getLimitConnection()) {
                    this.useConnections.remove(con);
                    this.freeConnections.add(con);
                    this.freeConnections.notifyAll();
                } else {
                    con.realClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnection(RsConnection con) {
        ArrayList arrayList = this.freeConnections;
        synchronized (arrayList) {
            this.freeConnections.remove(con);
            ArrayList arrayList2 = this.useConnections;
            synchronized (arrayList2) {
                this.useConnections.remove(con);
                if (this.getFreeCount() < this.connParm.getLimitConnection()) {
                    this.freeConnections.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheck() {
        ArrayList arrayList = this.freeConnections;
        synchronized (arrayList) {
            ArrayList list = (ArrayList)this.freeConnections.clone();
            for (RsConnection tscon : list) {
                if (tscon.checkConnected()) continue;
                System.err.println("[DS]\u7a7a\u95f2\u8fde\u63a5\u5df2\u7ecf\u4e0d\u53ef\u7528\uff0c\u5f3a\u884c\u5173\u95ed\uff01 ");
                try {
                    tscon.close();
                }
                catch (SQLException e) {
                    System.err.println("[DS]\u5f3a\u884c\u5173\u95ed\u8fde\u63a5\u9519\u8bef\uff01");
                    e.printStackTrace(System.err);
                }
            }
            list.clear();
            ArrayList arrayList2 = this.useConnections;
            synchronized (arrayList2) {
                ArrayList list2 = (ArrayList)this.useConnections.clone();
                for (RsConnection tscon : list2) {
                    if (!tscon.isOverTime()) continue;
                    System.err.println("[DS]\u8fde\u63a5\u8d85\u65f6\u6ca1\u6709\u5173\u95ed\uff0c\u5f3a\u884c\u5173\u95ed\uff01 sql=" + tscon.getLastSql());
                    try {
                        tscon.close();
                    }
                    catch (SQLException e) {
                        System.err.println("[DS]\u5f3a\u884c\u5173\u95ed\u8fde\u63a5\u9519\u8bef\uff01");
                        e.printStackTrace(System.err);
                    }
                }
                list2.clear();
            }
        }
        while (this.getConnectionCount() < this.connParm.getMinConnection()) {
            arrayList = this.freeConnections;
            synchronized (arrayList) {
                try {
                    this.freeConnections.add(this.newConnection(this.connParm.getUser(), this.connParm.getPassword()));
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        while (this.getConnectionCount() > this.connParm.getMaxConnection() && this.getFreeCount() > 10 || this.getConnectionCount() > this.connParm.getLimitConnection() && this.getFreeCount() > 0) {
            RsConnection conn = null;
            try {
                conn = (RsConnection)this.getConnection();
                conn.setHealth(false);
                conn.close();
                conn = null;
            }
            catch (Exception exception) {}
            continue;
            finally {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() throws SQLException {
        this.setState(4);
        this.monitor.setStop(true);
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.monitor = null;
        Collection list = (Collection)this.useConnections.clone();
        for (RsConnection rsconn : list) {
            rsconn.setHealth(false);
            try {
                rsconn.close();
            }
            catch (Exception exception) {}
        }
        list = (Collection)this.freeConnections.clone();
        for (RsConnection rsconn : list) {
            rsconn.setHealth(false);
            try {
                rsconn.close();
            }
            catch (Exception exception) {}
        }
        this.useConnections.clear();
        this.freeConnections.clear();
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.waitForInit();
        int state = this.getState();
        if (state == 2) {
            long maxTime = System.currentTimeMillis() + (long)(this.connParm.getMaxWaitTime() * 1000);
            ArrayList arrayList = this.freeConnections;
            synchronized (arrayList) {
                block16: {
                    boolean isFirst = true;
                    do {
                        if (this.freeConnections.size() > 0) {
                            ArrayList arrayList2 = this.useConnections;
                            synchronized (arrayList2) {
                                RsConnection con = (RsConnection)this.freeConnections.remove(0);
                                con.setLastSql(null);
                                this.useConnections.add(con);
                                return con;
                            }
                        }
                        if (!isFirst || this.freeConnections.size() + this.useConnections.size() < this.connParm.getLimitConnection()) {
                            ArrayList arrayList3 = this.useConnections;
                            synchronized (arrayList3) {
                                RsConnection con = this.newConnection(username, password);
                                this.useConnections.add(con);
                                return con;
                            }
                        }
                        isFirst = false;
                        if (this.getState() != 2) break block16;
                        try {
                            this.freeConnections.wait(this.connParm.getMaxWaitTime());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (maxTime >= System.currentTimeMillis());
                    throw new SQLException("[DS]\u83b7\u53d6\u8fde\u63a5\u8d85\u65f6\uff01");
                }
            }
        }
        if (state == 1) {
            throw new SQLException("[DS]\u7b49\u5f85\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
        throw new SQLException("[DS]\u8fde\u63a5\u6c60\u5173\u95ed\u4e2d\uff0c\u4e0d\u80fd\u7533\u8bf7\u8fde\u63a5\uff01");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        DriverManager.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        DriverManager.setLoginTimeout(arg0);
    }

    public DataSourceParm getConnectionParm() {
        return this.connParm;
    }

    public void setConnectionParm(DataSourceParm connParm) {
        this.connParm = connParm;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

