/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchDataUtil;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginExecutor;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginLogService;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.DateVerify;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.Convert;
import java.sql.SQLException;

public class BatchTaskThread
extends Thread {
    private FlowInstMaster batchInst = null;
    private FlowInstNode taskInst = null;
    private FlowConfNode taskConf = null;
    private ILogger logger = null;
    private PluginLogService taskLogService = null;
    public static final int TASK_RUN_TYPE_NORMAL = 1;
    public static final int TASK_RUN_TYPE_CYCLE = 2;
    public static final int TASK_RUN_TYPE_CRON = 3;
    public BatchRunProcess batchRunProcess;

    public BatchTaskThread(FlowInstMaster batchInst, FlowInstNode taskInst, FlowConfNode taskConf, BatchRunProcess batchRunProcess) {
        this.batchInst = batchInst;
        this.taskInst = taskInst;
        this.taskConf = taskConf;
        this.taskLogService = PluginLogService.getInstance();
        this.batchRunProcess = batchRunProcess;
    }

    @Override
    public void run() {
        this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
        int taskRunType = Convert.StrToInt(this.taskConf.getTaskRunType());
        switch (taskRunType) {
            case 1: {
                this.doNomalTask();
                break;
            }
            case 2: {
                this.doCycleTask();
                break;
            }
            case 3: {
                this.doCronTask();
            }
        }
        this.batchRunProcess.doTaskTheadCalc(-1);
    }

    private void doNomalTask() {
        this.logger.debug("\u6279\u6b21\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        PluginContext ctx = this.newPluginContext();
        if (this.callPlugin(ctx)) {
            this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "6", this.taskInst.getBatchSerialNo());
        } else {
            this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "7", this.taskInst.getBatchSerialNo());
        }
        this.logger.debug("\u6279\u6b21\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private void doCronTask() {
        this.logger.debug("\u6279\u6b21\u5b9a\u65f6\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        if (null == this.taskConf.getTaskCycleType() || "".equals(this.taskConf.getTaskCycleType())) {
            this.taskLogService.updateBatchTaskToEnd(this.taskConf, System.currentTimeMillis(), "7", this.taskInst.getBatchSerialNo());
        } else {
            boolean isCanExecute = false;
            if ("M".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBatchDate(), 2);
            } else if ("S".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBatchDate(), 4);
            } else if ("Y".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBatchDate(), 3);
            } else if ("W".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBatchDate(), 2);
            }
            if (isCanExecute) {
                PluginContext ctx = this.newPluginContext();
                if (this.callPlugin(ctx)) {
                    this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "6", this.taskInst.getBatchSerialNo());
                } else {
                    this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "7", this.taskInst.getBatchSerialNo());
                }
            } else {
                this.taskLogService.updateBatchTaskToEndEx(this.taskConf, System.currentTimeMillis(), "7", this.taskInst.getBatchSerialNo());
            }
        }
        this.logger.debug("\u6279\u6b21\u5b9a\u65f6\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private void doCycleTask() {
        this.logger.debug("\u6279\u6b21\u8f6e\u8be2\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        int accTime = 0;
        int cycleInteval = this.taskConf.getCycleInteval();
        int maxWaitTime = this.taskConf.getMaxWaitTime();
        PluginContext ctx = this.newPluginContext();
        boolean bResult = this.callPlugin(ctx);
        while (!(bResult || maxWaitTime > 0 && accTime >= maxWaitTime)) {
            try {
                accTime += cycleInteval;
                Thread.sleep((long)cycleInteval * 1000L);
                String state = BatchDataUtil.getTaskState(this.taskInst.getTaskId());
                if ("1".equals(state)) {
                    bResult = true;
                    break;
                }
                if ("3".equals(state)) {
                    bResult = false;
                    break;
                }
                bResult = this.callPlugin(ctx);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
        if (bResult) {
            this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "6", this.taskInst.getBatchSerialNo());
        } else {
            this.taskLogService.updateBatchTaskToEnd(this.taskConf, ctx.getStartMills(), "7", this.taskInst.getBatchSerialNo());
        }
        this.logger.debug("\u6279\u6b21\u8f6e\u8be2\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private PluginContext newPluginContext() {
        PluginContext ctx = new PluginContext();
        ctx.setnPluginId(this.taskConf.getPluginId());
        ctx.setnPluginConfType(Convert.StrToInt(this.taskConf.getPluginSourceType(), 1));
        ctx.setSzPluginConfId(this.taskConf.getPluginParaFlag());
        ctx.setSzBatchSn(this.batchInst.getBatchSerialNo());
        ctx.setSzBatchId(this.batchInst.getBatchId());
        ctx.setSzTaskId(this.taskInst.getTaskId());
        ctx.setSzTaskName(this.taskInst.getTaskName());
        ctx.setSzSubsCode(this.batchInst.getSubsId());
        ctx.setSzSubsDsCode(this.taskConf.getSubsDsCode());
        ctx.setFlowConfSource(this.batchRunProcess.getFlowConfSource());
        return ctx;
    }

    private boolean callPlugin(PluginContext ctx) {
        boolean bIsCallSuccess = false;
        try {
            this.taskLogService.updateBatchTaskToRunning(ctx.getSzTaskId(), this.taskInst.getBatchSerialNo());
            bIsCallSuccess = PluginExecutor.callPlugin(ctx);
        }
        catch (SQLException e) {
            bIsCallSuccess = false;
            this.logger.error(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            bIsCallSuccess = false;
            this.logger.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            bIsCallSuccess = false;
            this.logger.error(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            bIsCallSuccess = false;
            this.logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            bIsCallSuccess = false;
            this.logger.error(e.getMessage(), e);
        }
        return bIsCallSuccess;
    }
}

