/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.dao;

import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class FlowInstNodeDao {
    Connection conn = null;

    public FlowInstNodeDao(Connection conn) {
        this.conn = conn;
    }

    public FlowInstNode queryWithKeys(String batchId, String batchSerialNo, int batchOrder, String taskId) throws SQLException {
        FlowInstNode dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_inst_node WHERE batch_id=? and batch_serial_no = ? and batch_order=? and task_id=?");
            ps.setString(1, batchId);
            ps.setString(2, batchSerialNo);
            ps.setInt(3, batchOrder);
            ps.setString(4, taskId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new FlowInstNode();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowInstNodeWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<FlowInstNode> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<FlowInstNode> dcList = new ArrayList<FlowInstNode>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_inst_node " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                FlowInstNode dc = new FlowInstNode();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowInstNodeWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public boolean updateFlowInstNode(String szCondition) throws SQLException {
        PreparedStatement ps = null;
        boolean executeResult = false;
        try {
            ps = this.conn.prepareStatement("update flow_inst_node " + szCondition);
            executeResult = ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("updateFlowInstNode is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
        return executeResult;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void resetFaildTask(String batchId, String batchSerialNo) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update flow_inst_node set task_run_state=?,start_time='',end_time='',cost_time=0 where batch_id=? batch_serial_no = ? and task_run_state='7'");
            ps.setString(1, String.valueOf(1));
            ps.setString(2, batchId);
            ps.setString(3, batchSerialNo);
            ps.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO flow_hist_node SELECT * FROM flow_inst_node WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM flow_inst_node WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public FlowInstNode queryByTaskId(String batchId, String batchSerialNo, String taskId) throws SQLException {
        FlowInstNode dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_inst_node WHERE batch_id=? and batch_serial_no = ? and task_id=?");
            ps.setString(1, batchId);
            ps.setString(2, batchSerialNo);
            ps.setString(3, taskId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new FlowInstNode();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowInstNodeWithKeys is Wrong!" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }
}

