/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.SSubsIndex;
import com.irdstudio.allinflow.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSubsIndexDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(SSubsIndexDao.class);
    Connection conn = null;

    public SSubsIndexDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<SSubsIndex> queryList(final SSubsIndex paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinflow_db`.s_subs_index");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SSubsIndex> list = new ArrayList<SSubsIndex>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsIndex bean = (SSubsIndex)((Object)POJOUtils.generatePOJO((ResultSet)rs, SSubsIndex.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryList is wrong", e);
        }
        return list;
    }

    public SSubsIndex queryByPk(final String subsId, final String indexCode) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinflow_db`.s_subs_index");
                this.WHERE("subs_id = ?");
                param.add(subsId);
                this.WHERE("index_code = ?");
                param.add(indexCode);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SSubsIndex> list = new ArrayList<SSubsIndex>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsIndex bean = (SSubsIndex)((Object)POJOUtils.generatePOJO((ResultSet)rs, SSubsIndex.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (SSubsIndex)((Object)list.get(0));
    }

    public int saveIndex(final SSubsIndex index) throws Exception {
        SSubsIndex checkObj = this.queryByPk(index.getSubsId(), index.getIndexCode());
        final ArrayList param = new ArrayList();
        String sql = null;
        sql = checkObj == null ? new ProxySQL(){
            {
                this.INSERT_INTO("`allinflow_db`.s_subs_index");
                List vals = POJOUtils.getPOJOValues((Object)((Object)index));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString() : new ProxySQL(){
            {
                this.UPDATE("`allinflow_db`.s_subs_index");
                List vals = POJOUtils.getPOJOValues((Object)((Object)index));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("index_code")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("subs_id = ?");
                param.add(index.getSubsId());
                this.WHERE("index_code = ?");
                param.add(index.getIndexCode());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong " + JSON.toJSONString(param), e);
        }
        return result;
    }
}

