/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.impl;

import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnPoolForC3P0
implements IConnPool {
    private String jdbcUrl;
    private String user;
    private String password;
    private String driverClass = "com.mysql.jdbc.Driver";
    private int maxPoolSize = 100;
    private int minPoolSize = 10;
    private int initialPoolSize = 3;
    private int maxIdleTime = 20;
    private int acquireIncrement = 2;
    private ComboPooledDataSource dataSource;

    public ConnPoolForC3P0(String jdbcUrl, String user, String password, String driverClass, Integer maxPoolSize, Integer minPoolSize, Integer initialPoolSize, Integer maxIdleTime, Integer acquireIncrement) {
        this.initC3p0Properties(jdbcUrl, user, password, driverClass, maxPoolSize, minPoolSize, initialPoolSize, maxIdleTime, acquireIncrement);
        this.start();
    }

    private void start() {
        this.dataSource = new ComboPooledDataSource();
        this.dataSource.setJdbcUrl(this.jdbcUrl);
        this.dataSource.setUser(this.user);
        this.dataSource.setPassword(this.password);
        try {
            this.dataSource.setDriverClass(this.driverClass);
        }
        catch (PropertyVetoException e) {
            this.dataSource = null;
            System.err.println("C3p0Plugin start error");
            throw new RuntimeException(e);
        }
        this.dataSource.setMaxPoolSize(this.maxPoolSize);
        this.dataSource.setMinPoolSize(this.minPoolSize);
        this.dataSource.setInitialPoolSize(this.initialPoolSize);
        this.dataSource.setMaxIdleTime(this.maxIdleTime);
        this.dataSource.setAcquireIncrement(this.acquireIncrement);
    }

    private void initC3p0Properties(String jdbcUrl, String user, String password, String driverClass, Integer maxPoolSize, Integer minPoolSize, Integer initialPoolSize, Integer maxIdleTime, Integer acquireIncrement) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        this.driverClass = driverClass != null ? driverClass : this.driverClass;
        this.maxPoolSize = maxPoolSize != null ? maxPoolSize : this.maxPoolSize;
        this.minPoolSize = minPoolSize != null ? minPoolSize : this.minPoolSize;
        this.initialPoolSize = initialPoolSize != null ? initialPoolSize : this.initialPoolSize;
        this.maxIdleTime = maxIdleTime != null ? maxIdleTime : this.maxIdleTime;
        this.acquireIncrement = acquireIncrement != null ? acquireIncrement : this.acquireIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        ComboPooledDataSource comboPooledDataSource = this.dataSource;
        synchronized (comboPooledDataSource) {
            return this.dataSource.getConnection();
        }
    }

    @Override
    public int getConnectionCount() {
        try {
            return this.dataSource.getNumConnections();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(Connection conn) {
        ComboPooledDataSource comboPooledDataSource = this.dataSource;
        synchronized (comboPooledDataSource) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void clearAndFree() {
        this.dataSource.close();
    }
}

