/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class CustomTransaction {
    private Connection conn = null;

    protected CustomTransaction(Connection conn) {
        this.conn = conn;
        if (conn != null) {
            try {
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSql(String sql) throws SQLException {
        boolean flag = false;
        Statement st = null;
        try {
            st = this.conn.createStatement();
            st.executeUpdate(sql);
            flag = true;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                    st = null;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    public void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }
}

