/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.util.repo;

import com.irdstudio.framework.beans.core.util.TerminalExecUtil;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.common.URL;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class JGitUtil {
    private String localPath;
    private String localGitPath;
    private String remotePath;
    private Repository localRepository;
    private String username;
    private String password;
    private Git git;

    public JGitUtil(String localPath, String remotePath, String username, String password) {
        this.localPath = localPath;
        this.remotePath = remotePath;
        this.username = username;
        this.password = password;
        this.localGitPath = this.localPath + "/.git";
        try {
            this.localRepository = new FileRepository(this.localGitPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.git = new Git(this.localRepository);
    }

    public void create() throws IOException {
        FileRepository repository = new FileRepository(this.localGitPath);
        repository.create();
        System.out.println("create success");
    }

    public void cloneBranch(String branchName) throws GitAPIException {
        ((CloneCommand)Git.cloneRepository().setURI(this.remotePath).setBranch(branchName).setDirectory(new File(this.localPath)).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call().close();
        System.out.println("clone success");
    }

    public void pull(String branchName) throws Exception {
        ((PullCommand)this.git.pull().setRemoteBranchName(branchName).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call();
        System.out.println("pull success");
    }

    public void add(String fileName) throws Exception {
        File myFile = new File(this.localPath + fileName);
        myFile.createNewFile();
        this.git.add().addFilepattern(fileName).call();
        System.out.println("add success");
    }

    public void addAll() throws Exception {
        this.git.add().addFilepattern(".").call();
        this.git.add().setUpdate(true).addFilepattern(".").call();
        System.out.println("add success");
    }

    public void commit(String message) throws Exception {
        this.git.commit().setMessage(message).call();
        System.out.println("commit success");
    }

    public void commit(String username, String email, String message) throws Exception {
        this.git.commit().setAuthor(username, email).setMessage(message).call();
        System.out.println("commit success");
    }

    public void push() throws Exception {
        this.git.getRepository().getConfig().setInt("http", null, "postBuffer", 0x3200000);
        ((PushCommand)this.git.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call();
        System.out.println("push success");
    }

    public void push(String remotePath, Boolean forceLag) throws Exception {
        this.git.getRepository().getConfig().setInt("http", null, "postBuffer", 0x3200000);
        ((PushCommand)this.git.push().setRemote(remotePath).setForce(forceLag.booleanValue()).setPushAll().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call();
        System.out.println("push success");
    }

    public static void shallowClone(String localPath, String remotePath, String username, String password, String branchName, Consumer<String> consumer) {
        File dir = new File(localPath);
        File homeDir = dir.getParentFile();
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        String outputFolder = dir.getName();
        username = URL.encode((String)username);
        password = URL.encode((String)password);
        String url = String.format("https://%s:%s@%s", username, password, remotePath.replaceFirst("https://", ""));
        boolean result = false;
        if (dir.exists()) {
            result = TerminalExecUtil.localTerminalExec((File)new File(homeDir, outputFolder), consumer, (String[])new String[]{"git", "pull", "--depth", "1", url});
            if (!result) {
                if (dir.exists()) {
                    try {
                        FileUtils.forceDelete((File)dir);
                    }
                    catch (Exception e) {
                        FileUtils.deleteQuietly((File)dir);
                    }
                }
                TerminalExecUtil.localTerminalExec((File)homeDir, consumer, (String[])new String[]{"git", "clone", "--branch", branchName, "--depth", "1", url, outputFolder});
            }
        } else {
            if (dir.exists()) {
                try {
                    FileUtils.forceDelete((File)dir);
                }
                catch (Exception e) {
                    FileUtils.deleteQuietly((File)dir);
                }
            }
            TerminalExecUtil.localTerminalExec((File)homeDir, consumer, (String[])new String[]{"git", "clone", "--branch", branchName, "--depth", "1", url, outputFolder});
        }
    }

    public void close() {
        if (this.git != null) {
            this.git.close();
        }
    }
}

