/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.service.impl;

import com.irdstudio.allinflow.executor.application.executor.core.batch.BizFlowEngineApplication;
import com.irdstudio.allinflow.executor.facade.BizFlowEngineFacade;
import com.irdstudio.allinflow.executor.facade.dto.ResponseDTO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="BizFlowEngineServiceImpl")
public class BizFlowEngineServiceImpl
implements BizFlowEngineFacade {
    private static Logger logger = LoggerFactory.getLogger(BizFlowEngineServiceImpl.class);

    public ResponseDTO flowActionHandler(String action, String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        logger.info("\u4e1a\u52a1\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        ResponseDTO vo = new ResponseDTO();
        try {
            logger.info("\u4e1a\u52a1\u6d41\u7a0b\u6267\u884c\u5f00\u59cb, \u4e1a\u52a1\u6d41\u7a0bID\uff1a" + batchId + ", \u4e1a\u52a1\u6d41\u7a0b\u52a8\u4f5c\uff1a" + action);
            BizFlowEngineApplication batchEngine = new BizFlowEngineApplication(batchSerialNo, action, batchId, envId, param);
            batchEngine.start();
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u4e1a\u52a1\u6d41\u7a0b");
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u6d41\u7a0b\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
            vo.setFlag("fail");
            vo.setMsg("\u6267\u884c\u4e1a\u52a1\u6d41\u7a0b\u5f02\u5e38");
        }
        logger.info("\u4e1a\u52a1\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }

    public ResponseDTO startFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("run", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO continueFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("continue", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO stepContinueFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("stepContinue", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO suspendFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("suspend", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO resumeFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("resume", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO stopFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("stop", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO simulateFlow(String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("simulate", null, batchId, envId, param);
    }

    public ResponseDTO replayFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("replay", batchSerialNo, batchId, envId, param);
    }
}

